/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.lra.LatentRelationalAnalysis;
import edu.ucla.sspace.mains.GenericMain;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import java.io.File;
import java.util.Properties;

public class LRAMain
extends GenericMain {
    protected boolean verbose = false;
    protected ArgOptions argOptions;

    private LRAMain() {
    }

    @Override
    public void usage() {
        System.out.println("usage: java LRAMain [options] <corpusDir> <analogyFile> <testAnalogies> <outputFile>\n" + this.argOptions.prettyPrint());
    }

    @Override
    public Properties setupProperties() {
        Properties properties = System.getProperties();
        if (this.argOptions.hasOption("dimensions")) {
            properties.setProperty("edu.ucla.sspace.lra.LRA.dimensions", this.argOptions.getStringOption("dimensions"));
        }
        if (this.argOptions.hasOption("indexDir")) {
            properties.setProperty("edu.ucla.sspace.lra.LRA.index_dir", this.argOptions.getStringOption("indexDir"));
        }
        if (this.argOptions.hasOption("skipIndex")) {
            properties.setProperty("edu.ucla.sspace.lra.LRA.skip_index", "true");
        }
        if (this.argOptions.hasOption("readMatrixFile")) {
            properties.setProperty("edu.ucla.sspace.lra.LRA.readMatrixFile", this.argOptions.getStringOption("readMatrixFile"));
        }
        if (this.argOptions.hasOption("writeMatrixFile")) {
            properties.setProperty("edu.ucla.sspace.lra.LRA.writeMatrixFile", this.argOptions.getStringOption("writeMatrixFile"));
        }
        return properties;
    }

    @Override
    protected ArgOptions setupOptions() {
        ArgOptions argOptions = new ArgOptions();
        argOptions.addOption('c', "corpusDir", "the directory of the corpus", true, "DIR", "Required");
        argOptions.addOption('a', "analogyFile", "the file containing list of word pairs", true, "FILE", "Required");
        argOptions.addOption('t', "testAnalogies", "the file containing list of analogies", true, "FILE", "Required");
        argOptions.addOption('o', "outputFile", "the file containing the cosine similarity output for the analogies from testAnalogies", true, "FILE", "Required");
        argOptions.addOption('i', "indexDir", "a Directory for storing or loading the Lucene index", true, "DIR", "Required");
        argOptions.addOption('n', "dimensions", "the number of dimensions in the semantic space", true, "INT");
        argOptions.addOption('r', "readMatrixFile", "file containing projection matrix", true, "FILE");
        argOptions.addOption('s', "skipIndex", "turn indexing off.  Must specify index directory", false, null);
        argOptions.addOption('v', "verbose", "prints verbose output", false, null, "Program Options");
        argOptions.addOption('w', "writeMatrixFile", "file to write projection matrix to", true, "FILE");
        return argOptions;
    }

    public static void main(String[] stringArray) {
        LRAMain lRAMain = new LRAMain();
        try {
            lRAMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public SemanticSpace getSpace() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(String[] stringArray) {
        this.argOptions = this.setupOptions();
        try {
            Matrix matrix;
            Object object;
            if (stringArray.length < 3) {
                this.usage();
                System.exit(1);
            }
            this.argOptions.parseOptions(stringArray);
            if (this.argOptions.numPositionalArgs() < 4) {
                throw new IllegalArgumentException("must include all Required args");
            }
            Properties properties = this.setupProperties();
            String string = this.argOptions.getPositionalArg(0);
            String string2 = this.argOptions.getPositionalArg(1);
            String string3 = this.argOptions.getPositionalArg(2);
            String string4 = this.argOptions.getPositionalArg(3);
            String string5 = string;
            String string6 = properties.getProperty("edu.ucla.sspace.lra.LRA.index_dir");
            if (string6 != null) {
                string5 = string6;
            }
            boolean bl = true;
            String string7 = properties.getProperty("edu.ucla.sspace.lra.LRA.skip_index");
            if (string7.equals("true")) {
                bl = false;
            }
            LatentRelationalAnalysis latentRelationalAnalysis = new LatentRelationalAnalysis(string, string5, bl);
            latentRelationalAnalysis.loadAnalogiesFromFile(string2);
            String string8 = properties.getProperty("edu.ucla.sspace.lra.LRA.readMatrixFile");
            if (string8 != null) {
                object = new File(string8);
                if (!((File)object).exists()) throw new IllegalArgumentException("specified projection file does not exist");
                matrix = MatrixIO.readMatrix(new File(string8), MatrixIO.Format.SVDLIBC_SPARSE_TEXT, Matrix.Type.SPARSE_IN_MEMORY);
            } else {
                latentRelationalAnalysis.findPatterns();
                latentRelationalAnalysis.mapRows();
                latentRelationalAnalysis.mapColumns();
                object = latentRelationalAnalysis.createSparseMatrix();
                object = latentRelationalAnalysis.applyEntropyTransformations((Matrix)object);
                int n = 300;
                String string9 = properties.getProperty("edu.ucla.sspace.lra.LRA.dimensions");
                if (string9 != null) {
                    try {
                        n = Integer.parseInt(string9);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("edu.ucla.sspace.lra.LRA.dimensions is not an integer: " + string9);
                    }
                }
                Matrix[] matrixArray = LatentRelationalAnalysis.computeSVD((Matrix)object, n);
                matrix = Matrices.multiply(matrixArray[0], matrixArray[1]);
            }
            if ((object = properties.getProperty("edu.ucla.sspace.lra.LRA.writeMatrixFile")) != null) {
                MatrixIO.writeMatrix(matrix, new File((String)object), MatrixIO.Format.SVDLIBC_SPARSE_TEXT);
            }
            latentRelationalAnalysis.evaluateAnalogies(matrix, string3, string4);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected void verbose(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    @Override
    protected void verbose(String string, Object ... objectArray) {
        if (this.verbose) {
            System.out.printf(string, objectArray);
        }
    }
}

