/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.evaluation.NormedWordPrimingTest;
import edu.ucla.sspace.evaluation.WordChoiceEvaluation;
import edu.ucla.sspace.evaluation.WordChoiceEvaluationRunner;
import edu.ucla.sspace.evaluation.WordPrimingTest;
import edu.ucla.sspace.evaluation.WordSimilarityEvaluation;
import edu.ucla.sspace.evaluation.WordSimilarityEvaluationRunner;
import edu.ucla.sspace.text.WordIterator;
import edu.ucla.sspace.util.LoggerUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EvaluatorMain {
    private static final Logger LOGGER = Logger.getLogger(EvaluatorMain.class.getName());
    private final ArgOptions argOptions = new ArgOptions();
    private Collection<WordChoiceEvaluation> wordChoiceTests;
    private Collection<WordSimilarityEvaluation> wordSimilarityTests;
    private Collection<WordPrimingTest> wordPrimingTests;
    private Collection<NormedWordPrimingTest> normedPrimingTests;
    private ResultReporter reporter;
    private PrintStream resultWriter;

    public EvaluatorMain() {
        this.addOptions();
    }

    protected void addOptions() {
        this.argOptions.addOption('c', "wordChoice", "a list of WordChoiceEvaluation class names and their data files", true, "CLASS=FILE[=FILE2...][,CLASS=FILE...]", "Required (at least one of)");
        this.argOptions.addOption('s', "wordSimilarity", "a list of WordSimilarityEvaluation class names", true, "CLASS=FILE[=FILE2...][,CLASS=FILE...]", "Required (at least one of)");
        this.argOptions.addOption('p', "wordPriming", "a list of WordPrimingTest class names", true, "CLASS[=FILE][=FILE2...][,CLASS=FILE...]", "Required (at least one of)");
        this.argOptions.addOption('n', "normedPriming", "a list of NormedWordPrimingTest class names", true, "CLASS[=FILE][=FILE2...][,CLASS=FILE...]", "Required (at least one of)");
        this.argOptions.addOption('g', "testConfiguration", "a file containing a list of test configurations to run", true, "FILE", "Required (at least one of)");
        this.argOptions.addOption('l', "latexOutput", "writes the results to a file in a latex table format", false, null, "Program Options");
        this.argOptions.addOption('o', "outputFile", "writes the results to this file", true, "FILE", "Program Options");
        this.argOptions.addOption('t', "threads", "the number of threads to use", true, "INT", "Program Options");
        this.argOptions.addOption('v', "verbose", "prints verbose output", false, null, "Program Options");
    }

    public void run(String[] stringArray) throws Exception {
        Similarity.SimType simType;
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        String string;
        if (stringArray.length == 0) {
            this.usage();
            System.exit(1);
        }
        this.argOptions.parseOptions(stringArray);
        if (this.argOptions.hasOption("verbose")) {
            LoggerUtil.setLevel(Level.FINE);
        }
        String string2 = this.argOptions.hasOption("wordChoice") ? this.argOptions.getStringOption("wordChoice") : null;
        String string3 = this.argOptions.hasOption("wordSimilarity") ? this.argOptions.getStringOption("wordSimilarity") : null;
        String string4 = this.argOptions.hasOption("wordPriming") ? this.argOptions.getStringOption("wordPriming") : null;
        String string5 = this.argOptions.hasOption("normedPriming") ? this.argOptions.getStringOption("normedPriming") : null;
        String string6 = string = this.argOptions.hasOption("testConfiguration") ? this.argOptions.getStringOption("testConfiguration") : null;
        if (string2 == null && string3 == null && string4 == null && string == null) {
            this.usage();
            System.out.println("no tests specified");
            System.exit(1);
        }
        this.wordChoiceTests = string2 == null ? new LinkedList() : this.loadWordChoiceEvaluations(string2);
        this.wordSimilarityTests = string3 == null ? new LinkedList() : this.loadWordSimilarityEvaluations(string3);
        this.resultWriter = this.argOptions.hasOption("outputFile") ? new PrintStream(this.argOptions.getStringOption("outputFile")) : System.out;
        this.reporter = this.argOptions.hasOption('l') ? new LatexReporter() : new DefaultReporter();
        this.wordPrimingTests = string4 == null ? new LinkedList() : this.loadWordPrimingTests(string4);
        Collection<Object> collection = this.normedPrimingTests = string5 == null ? new LinkedList() : this.loadNormedPrimingTests(string5);
        if (string != null) {
            object3 = new WordIterator(new BufferedReader(new FileReader(string)));
            while (((WordIterator)object3).hasNext()) {
                String string7 = ((WordIterator)object3).next();
                if (!((WordIterator)object3).hasNext()) {
                    throw new Error("test is not matched with data file: " + string7);
                }
                String[] stringArray2 = ((WordIterator)object3).next().split(",");
                object2 = Class.forName(string7);
                objectArray = new Class[stringArray2.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = String.class;
                }
                object = ((Class)object2).getConstructor((Class<?>[])objectArray);
                System.out.println(string7);
                simType = ((Constructor)object).newInstance(stringArray2);
                if (simType instanceof WordChoiceEvaluation) {
                    this.wordChoiceTests.add((WordChoiceEvaluation)((Object)simType));
                    this.verbose("Loaded word choice test " + string7);
                    continue;
                }
                if (simType instanceof WordSimilarityEvaluation) {
                    this.wordSimilarityTests.add((WordSimilarityEvaluation)((Object)simType));
                    this.verbose("Loaded word similarity test " + string7);
                    continue;
                }
                if (simType instanceof WordPrimingTest) {
                    this.wordPrimingTests.add((WordPrimingTest)((Object)simType));
                    this.verbose("Loaded word priming test " + string7);
                    continue;
                }
                if (simType instanceof NormedWordPrimingTest) {
                    this.normedPrimingTests.add((NormedWordPrimingTest)((Object)simType));
                    this.verbose("Loaded normed word priming test " + string7);
                    continue;
                }
                throw new IllegalStateException("provided class is not an known Evaluation class type: " + string7);
            }
        }
        object3 = new HashSet();
        int n = this.argOptions.numPositionalArgs();
        for (int i = 0; i < n; ++i) {
            object2 = null;
            objectArray = this.argOptions.getPositionalArg(i).split(",");
            object = objectArray[0];
            simType = Similarity.SimType.COSINE;
            if (objectArray.length > 1) {
                for (int j = 1; j < objectArray.length; ++j) {
                    Object object4 = objectArray[j];
                    if (j > 2) {
                        throw new IllegalStateException("too many .sspace file arguments:" + this.argOptions.getPositionalArg(i));
                    }
                    if (!((String)object4).startsWith("function")) {
                        throw new IllegalArgumentException("unknown sspace parameter: " + (String)object4);
                    }
                    simType = Similarity.SimType.valueOf(((String)object4).substring(10));
                }
            }
            if (object3.contains(object2)) continue;
            this.verbose("Loading semantic space: " + (String)object);
            object2 = SemanticSpaceIO.load((String)object);
            object3.add(object);
            this.verbose("Done loading.");
            this.verbose("Evaluating semantic space: " + (String)object);
            this.evaluateSemanticSpace((SemanticSpace)object2, simType);
            this.verbose("Done evaluating.");
        }
        this.reporter.printResults();
    }

    private void evaluateSemanticSpace(SemanticSpace semanticSpace, Similarity.SimType simType) {
        Object object;
        String[] stringArray = new String[this.wordChoiceTests.size() + this.wordSimilarityTests.size() + this.wordPrimingTests.size() + this.normedPrimingTests.size()];
        int n = 0;
        for (WordChoiceEvaluation object2 : this.wordChoiceTests) {
            object = WordChoiceEvaluationRunner.evaluate(semanticSpace, object2, simType);
            this.verbose("Results for %s:%n%s%n", object2, object);
            stringArray[n++] = String.format("%4.3f", object.score());
        }
        for (WordSimilarityEvaluation wordSimilarityEvaluation : this.wordSimilarityTests) {
            object = WordSimilarityEvaluationRunner.evaluate(semanticSpace, wordSimilarityEvaluation, simType);
            this.verbose("Results for %s:%n%s%n", wordSimilarityEvaluation, object);
            stringArray[n++] = String.format("%4.3f", object.correlation());
        }
        for (WordPrimingTest wordPrimingTest : this.wordPrimingTests) {
            object = wordPrimingTest.evaluate(semanticSpace);
            this.verbose("Results for %s:%n%s%n", wordPrimingTest, object);
            stringArray[n++] = String.format("%4.3f & %4.3f & %4.3f", object.relatedPriming(), object.unrelatedPriming(), object.effect());
        }
        for (NormedWordPrimingTest normedWordPrimingTest : this.normedPrimingTests) {
            object = normedWordPrimingTest.evaluate(semanticSpace);
            this.verbose("Results for %s:%n%s%n", normedWordPrimingTest, object);
            stringArray[n++] = String.format("%4.3f", object.averageCorrelation());
        }
        this.reporter.addResults(semanticSpace.getSpaceName(), simType.toString(), stringArray);
    }

    protected void verbose(String string) {
        LOGGER.fine(string);
    }

    protected void verbose(String string, Object ... objectArray) {
        LOGGER.fine(String.format(string, objectArray));
    }

    public void usage() {
        System.out.println("java EvaluatorMain " + this.argOptions.prettyPrint() + "<sspace-file>[,format=SSpaceFormat[,function=SimType]] " + "[<sspace-file>...]\n\n" + "The .sspace file arguments may have option specifications that " + "indicate\n what vector " + "comparison method\n" + "should be used (default COSINE).  Users should specify the name " + "of a\n" + "Similarity.SimType.  A single .sspace can be evaluated with " + "multiple\n" + "comparison functions by specifying the file multiple times on " + "the command\n" + "line.  The .sspace file will be loaded only once.\n\n" + "A test configuration file is a series of fully qualified class " + "names of evaluations\nthat should be run followed by the data" + "files that contains\nthe test information, comma separated");
    }

    public static void main(String[] stringArray) {
        try {
            new EvaluatorMain().run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Collection<WordChoiceEvaluation> loadWordChoiceEvaluations(String string) {
        String[] stringArray = string.split(",");
        LinkedList<WordChoiceEvaluation> linkedList = new LinkedList<WordChoiceEvaluation>();
        try {
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split("=");
                Class<?> clazz = Class.forName(stringArray2[0]);
                Class[] classArray = new Class[stringArray2.length - 1];
                for (int i = 0; i < classArray.length; ++i) {
                    classArray[i] = String.class;
                }
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new String[stringArray2.length - 1];
                for (int i = 1; i < stringArray2.length; ++i) {
                    objectArray[i - 1] = stringArray2[i];
                }
                WordChoiceEvaluation wordChoiceEvaluation = (WordChoiceEvaluation)constructor.newInstance(objectArray);
                this.verbose("Loaded word choice test " + stringArray2[0]);
                linkedList.add(wordChoiceEvaluation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return linkedList;
    }

    private Collection<WordSimilarityEvaluation> loadWordSimilarityEvaluations(String string) {
        String[] stringArray = string.split(",");
        LinkedList<WordSimilarityEvaluation> linkedList = new LinkedList<WordSimilarityEvaluation>();
        try {
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split("=");
                Class<?> clazz = Class.forName(stringArray2[0]);
                Class[] classArray = new Class[stringArray2.length - 1];
                for (int i = 0; i < classArray.length; ++i) {
                    classArray[i] = String.class;
                }
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new String[stringArray2.length - 1];
                for (int i = 1; i < stringArray2.length; ++i) {
                    objectArray[i - 1] = stringArray2[i];
                }
                WordSimilarityEvaluation wordSimilarityEvaluation = (WordSimilarityEvaluation)constructor.newInstance(objectArray);
                this.verbose("Loaded word similarity test " + stringArray2[0]);
                linkedList.add(wordSimilarityEvaluation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return linkedList;
    }

    private Collection<WordPrimingTest> loadWordPrimingTests(String string) {
        String[] stringArray = string.split(",");
        LinkedList<WordPrimingTest> linkedList = new LinkedList<WordPrimingTest>();
        try {
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split("=");
                Class<?> clazz = Class.forName(stringArray2[0]);
                Class[] classArray = new Class[stringArray2.length - 1];
                for (int i = 0; i < classArray.length; ++i) {
                    classArray[i] = String.class;
                }
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new String[stringArray2.length - 1];
                for (int i = 1; i < stringArray2.length; ++i) {
                    objectArray[i - 1] = stringArray2[i];
                }
                WordPrimingTest wordPrimingTest = (WordPrimingTest)constructor.newInstance(objectArray);
                this.verbose("Loaded word priming test " + stringArray2[0]);
                linkedList.add(wordPrimingTest);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return linkedList;
    }

    private Collection<NormedWordPrimingTest> loadNormedPrimingTests(String string) {
        String[] stringArray = string.split(",");
        LinkedList<NormedWordPrimingTest> linkedList = new LinkedList<NormedWordPrimingTest>();
        try {
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split("=");
                Class<?> clazz = Class.forName(stringArray2[0]);
                Class[] classArray = new Class[stringArray2.length - 1];
                for (int i = 0; i < classArray.length; ++i) {
                    classArray[i] = String.class;
                }
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new String[stringArray2.length - 1];
                for (int i = 1; i < stringArray2.length; ++i) {
                    objectArray[i - 1] = stringArray2[i];
                }
                NormedWordPrimingTest normedWordPrimingTest = (NormedWordPrimingTest)constructor.newInstance(objectArray);
                this.verbose("Loaded normed word priming test " + stringArray2[0]);
                linkedList.add(normedWordPrimingTest);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return linkedList;
    }

    private class LatexReporter
    implements ResultReporter {
        private List<String> titleList = new ArrayList<String>();
        private List<String[]> resultList = new ArrayList<String[]>();

        @Override
        public void addResults(String string, String string2, String[] stringArray) {
            this.titleList.add(string + "-" + string2);
            this.resultList.add(stringArray);
        }

        @Override
        public void printResults() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SSpace Name  ");
            for (String[] stringArray : EvaluatorMain.this.wordChoiceTests) {
                stringBuilder.append("  &  ").append(stringArray.toString());
            }
            for (String[] stringArray : EvaluatorMain.this.wordSimilarityTests) {
                stringBuilder.append("  &  ").append(stringArray.toString());
            }
            for (String[] stringArray : EvaluatorMain.this.wordPrimingTests) {
                stringBuilder.append("  &  ").append(stringArray.toString());
            }
            for (String[] stringArray : EvaluatorMain.this.normedPrimingTests) {
                stringBuilder.append("  &  ").append(stringArray.toString());
            }
            stringBuilder.append("  \\");
            EvaluatorMain.this.resultWriter.println(stringBuilder.toString());
            for (int i = 0; i < this.titleList.size(); ++i) {
                String[] stringArray;
                EvaluatorMain.this.resultWriter.printf("%s ", this.titleList.get(i));
                for (String string : stringArray = this.resultList.get(i)) {
                    EvaluatorMain.this.resultWriter.printf("  &  %s", string);
                }
                EvaluatorMain.this.resultWriter.printf("  \\\\\n", new Object[0]);
            }
            EvaluatorMain.this.resultWriter.close();
        }
    }

    private class DefaultReporter
    implements ResultReporter {
        private DefaultReporter() {
        }

        @Override
        public void addResults(String string, String string2, String[] stringArray) {
            int n = 0;
            for (Object object : EvaluatorMain.this.wordChoiceTests) {
                EvaluatorMain.this.resultWriter.printf("Result for sspace %s-%s on synonymy test %s: %s\n", string, string2, object, stringArray[n++]);
            }
            for (Object object : EvaluatorMain.this.wordSimilarityTests) {
                EvaluatorMain.this.resultWriter.printf("Result for sspace %s-%s on similarity test %s: %s\n", string, string2, object, stringArray[n++]);
            }
            for (Object object : EvaluatorMain.this.wordPrimingTests) {
                EvaluatorMain.this.resultWriter.printf("Result for sspace %s-%s on priming test %s: %s\n", string, string2, object, stringArray[n++]);
            }
            for (Object object : EvaluatorMain.this.normedPrimingTests) {
                EvaluatorMain.this.resultWriter.printf("Result for sspace %s-%s on priming test %s: %s\n", string, string2, object, stringArray[n++]);
            }
        }

        @Override
        public void printResults() {
            EvaluatorMain.this.resultWriter.close();
        }
    }

    private static interface ResultReporter {
        public void addResults(String var1, String var2, String[] var3);

        public void printResults();
    }
}

