/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.dependency.DefaultDependencyPermutationFunction;
import edu.ucla.sspace.dependency.DependencyPermutationFunction;
import edu.ucla.sspace.index.PermutationFunction;
import edu.ucla.sspace.index.RandomIndexVectorGenerator;
import edu.ucla.sspace.mains.DVWordsiMain;
import edu.ucla.sspace.util.GeneratorMap;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.wordsi.DependencyContextGenerator;
import edu.ucla.sspace.wordsi.RandomIndexingDependencyContextGenerator;

public class DVRIWordsiMain
extends DVWordsiMain {
    private GeneratorMap<TernaryVector> indexMap;
    private DependencyPermutationFunction<TernaryVector> permFunc;

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        super.addExtraOptions(argOptions);
        argOptions.addOption('P', "permutationFunction", "Specifies the DependencyPermutationFunction for TernaryVectors that will permute index vectors before adding them to context vectors. (Default: None)", true, "CLASSNAME", "Optional");
        argOptions.addOption('l', "vectorLength", "Specifies the length of each index vector. (Default: 5000)", true, "CLASSNAME", "Optional");
    }

    @Override
    protected void postProcessing() {
        if (this.argOptions.hasOption('S')) {
            this.saveObject(this.openSaveFile(), this.indexMap);
            this.saveObject(this.openSaveFile(), this.permFunc);
        }
    }

    @Override
    protected DependencyContextGenerator getContextGenerator() {
        int n = this.argOptions.getIntOption('W', 5);
        int n2 = this.argOptions.getIntOption('l', 5000);
        if (this.argOptions.hasOption('L')) {
            this.indexMap = (GeneratorMap)this.loadObject(this.openLoadFile());
            this.permFunc = (DependencyPermutationFunction)this.loadObject(this.openLoadFile());
        } else {
            this.indexMap = new GeneratorMap<TernaryVector>(new RandomIndexVectorGenerator(n2));
            if (this.argOptions.hasOption('P')) {
                PermutationFunction permutationFunction = (PermutationFunction)ReflectionUtil.getObjectInstance(this.argOptions.getStringOption('P'));
                this.permFunc = new DefaultDependencyPermutationFunction<TernaryVector>(permutationFunction);
            }
        }
        if (this.argOptions.hasOption('e')) {
            this.indexMap.setReadOnly(true);
        }
        return new RandomIndexingDependencyContextGenerator(this.permFunc, this.getAcceptor(), this.indexMap, n2, n);
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }
}

