/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.coals.Coals;
import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.mains.GenericMain;
import java.util.Properties;

public class CoalsMain
extends GenericMain {
    private CoalsMain() {
    }

    @Override
    public void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('n', "dimensions", "Set the number of columns to keep in the raw co-occurance matrix.", true, "INT", "Optional");
        argOptions.addOption('m', "maxWords", "Set the maximum number of words to keep in the space, ordered by frequency", true, "INT", "Optional");
        argOptions.addOption('s', "reducedDimension", "Set the number of dimension to reduce to using the Singular Value Decompositon.  This is used if --reduce is set.", true, "INT", "Optional");
        argOptions.addOption('r', "reduce", "Set to true if the co-occurrance matrix should be reduced using the Singluar Value Decomposition", false, null, "Optional");
    }

    public static void main(String[] stringArray) {
        CoalsMain coalsMain = new CoalsMain();
        try {
            coalsMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public SemanticSpace getSpace() {
        return new Coals();
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }

    @Override
    public Properties setupProperties() {
        Properties properties = System.getProperties();
        if (this.argOptions.hasOption("reducedDimension")) {
            properties.setProperty("edu.ucla.sspace.coals.Coals.dimension", this.argOptions.getStringOption("reducedDimension"));
        }
        if (this.argOptions.hasOption("reduce")) {
            properties.setProperty("edu.ucla.sspace.coals.Coals.reduce", "true");
        }
        if (this.argOptions.hasOption("dimensions")) {
            properties.setProperty("edu.ucla.sspace.coals.Coals.maxDimensions", this.argOptions.getStringOption("dimensions"));
        }
        if (this.argOptions.hasOption("maxWords")) {
            properties.setProperty("edu.ucla.sspace.coals.Coals.maxWords", this.argOptions.getStringOption("maxWords"));
        }
        return properties;
    }
}

