/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.beagle.Beagle;
import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.index.GaussianVectorGenerator;
import edu.ucla.sspace.mains.GenericMain;
import edu.ucla.sspace.util.GeneratorMap;
import edu.ucla.sspace.util.SerializableUtil;
import edu.ucla.sspace.vector.DoubleVector;
import java.io.File;

public class BeagleMain
extends GenericMain {
    private static final int DEFAULT_DIMENSION = 2048;
    private int dimension;
    private GeneratorMap<DoubleVector> generatorMap;

    private BeagleMain() {
    }

    public static void main(String[] stringArray) {
        BeagleMain beagleMain = new BeagleMain();
        try {
            beagleMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('n', "dimension", "the length of each beagle vector", true, "INT", "Options");
        argOptions.addOption('s', "semanticType", "The type of semantic vectors to generate", true, "SemanticType", "Options");
        argOptions.addOption('S', "saveVectors", "save word-to-IndexVector mapping after processing", true, "FILE", "Options");
        argOptions.addOption('L', "loadVectors", "load word-to-IndexVector mapping before processing", true, "FILE", "Options");
    }

    @Override
    public void handleExtraOptions() {
        int n = this.dimension = this.argOptions.hasOption("dimension") ? this.argOptions.getIntOption("dimension") : 2048;
        if (this.argOptions.hasOption("loadVectors")) {
            this.generatorMap = SerializableUtil.load(new File(this.argOptions.getStringOption("loadVectors")), GeneratorMap.class);
        } else {
            double d = 1.0 / Math.sqrt(this.dimension);
            System.setProperty("edu.ucla.sspace.index.GuassianVectorGenerator.stdev", Double.toString(d));
            GaussianVectorGenerator gaussianVectorGenerator = new GaussianVectorGenerator(this.dimension);
            this.generatorMap = new GeneratorMap<DoubleVector>(gaussianVectorGenerator);
        }
    }

    @Override
    protected void postProcessing() {
        if (this.argOptions.hasOption("saveVectors")) {
            SerializableUtil.save(this.generatorMap, new File(this.argOptions.getStringOption("saveVectors")));
        }
    }

    @Override
    public SemanticSpace getSpace() {
        Beagle.SemanticType semanticType = this.argOptions.hasOption('s') ? Beagle.SemanticType.valueOf(this.argOptions.getStringOption('s').toUpperCase()) : Beagle.SemanticType.COMPOSITE;
        return new Beagle(this.dimension, semanticType, this.generatorMap);
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.BINARY;
    }
}

