/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.isa;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.index.PermutationFunction;
import edu.ucla.sspace.index.RandomIndexVectorGenerator;
import edu.ucla.sspace.index.TernaryPermutationFunction;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.util.GeneratorMap;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class IncrementalSemanticAnalysis
implements SemanticSpace {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.isa.IncrementalSemanticAnalysis";
    public static final String HISTORY_DECAY_RATE_PROPERTY = "edu.ucla.sspace.isa.IncrementalSemanticAnalysis.historyDecayRate";
    public static final String IMPACT_RATE_PROPERTY = "edu.ucla.sspace.isa.IncrementalSemanticAnalysis.impactRate";
    public static final String PERMUTATION_FUNCTION_PROPERTY = "edu.ucla.sspace.isa.IncrementalSemanticAnalysis.permutationFunction";
    public static final String USE_PERMUTATIONS_PROPERTY = "edu.ucla.sspace.isa.IncrementalSemanticAnalysis.usePermutations";
    public static final String VECTOR_LENGTH_PROPERTY = "edu.ucla.sspace.isa.IncrementalSemanticAnalysis.vectorLength";
    public static final String WINDOW_SIZE_PROPERTY = "edu.ucla.sspace.isa.IncrementalSemanticAnalysis.windowSize";
    public static final String USE_SPARSE_SEMANTICS_PROPERTY = "edu.ucla.sspace.isa.IncrementalSemanticAnalysis.sparseSemantics";
    public static final double DEFAULT_HISTORY_DECAY_RATE = 100.0;
    public static final double DEFAULT_IMPACT_RATE = 0.003;
    public static final int DEFAULT_VECTOR_LENGTH = 1800;
    public static final int DEFAULT_WINDOW_SIZE = 5;
    private final double historyDecayRate;
    private final double impactRate;
    private final PermutationFunction<TernaryVector> permutationFunc;
    private final boolean usePermutations;
    private final boolean useSparseSemantics;
    private final int vectorLength;
    private final int windowSize;
    private final Map<String, TernaryVector> wordToIndexVector;
    private final Map<String, SemanticVector> wordToMeaning;
    private final Map<String, Integer> wordToOccurrences;

    public IncrementalSemanticAnalysis() {
        this(System.getProperties());
    }

    public IncrementalSemanticAnalysis(Properties properties) {
        String string = properties.getProperty(VECTOR_LENGTH_PROPERTY);
        this.vectorLength = string != null ? Integer.parseInt(string) : 1800;
        String string2 = properties.getProperty(WINDOW_SIZE_PROPERTY);
        this.windowSize = string2 != null ? Integer.parseInt(string2) : 5;
        String string3 = properties.getProperty(USE_PERMUTATIONS_PROPERTY);
        this.usePermutations = string3 != null ? Boolean.parseBoolean(string3) : false;
        String string4 = properties.getProperty(PERMUTATION_FUNCTION_PROPERTY);
        this.permutationFunc = string4 != null ? IncrementalSemanticAnalysis.loadPermutationFunction(string4) : new TernaryPermutationFunction();
        RandomIndexVectorGenerator randomIndexVectorGenerator = new RandomIndexVectorGenerator(this.vectorLength, properties);
        String string5 = properties.getProperty(USE_SPARSE_SEMANTICS_PROPERTY);
        this.useSparseSemantics = string5 != null ? Boolean.parseBoolean(string5) : false;
        String string6 = properties.getProperty(HISTORY_DECAY_RATE_PROPERTY);
        this.historyDecayRate = string6 != null ? Double.parseDouble(string6) : 100.0;
        String string7 = properties.getProperty(IMPACT_RATE_PROPERTY);
        this.impactRate = string7 != null ? Double.parseDouble(string7) : 0.003;
        this.wordToIndexVector = new GeneratorMap<TernaryVector>(randomIndexVectorGenerator);
        this.wordToMeaning = new HashMap<String, SemanticVector>();
        this.wordToOccurrences = new HashMap<String, Integer>();
    }

    private static PermutationFunction<TernaryVector> loadPermutationFunction(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (PermutationFunction)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public void clearSemantics() {
        this.wordToMeaning.clear();
    }

    private SemanticVector getSemanticVector(String string) {
        SemanticVector semanticVector = this.wordToMeaning.get(string);
        if (semanticVector == null) {
            semanticVector = this.useSparseSemantics ? new SparseSemanticVector(this.vectorLength) : new DenseSemanticVector(this.vectorLength);
            this.wordToMeaning.put(string, semanticVector);
        }
        return semanticVector;
    }

    @Override
    public String getSpaceName() {
        return "IncrementSemanticAnalysis--" + this.vectorLength + "v-" + this.windowSize + "w-" + (this.usePermutations ? this.permutationFunc.toString() : "noPermutations");
    }

    @Override
    public Vector getVector(String string) {
        SemanticVector semanticVector = this.wordToMeaning.get(string);
        if (semanticVector == null) {
            return null;
        }
        return Vectors.immutable(semanticVector);
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }

    public Map<String, TernaryVector> getWordToIndexVector() {
        return Collections.unmodifiableMap(this.wordToIndexVector);
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.wordToMeaning.keySet());
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(this.windowSize);
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>(this.windowSize);
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        String string = null;
        for (int i = 0; i < this.windowSize && iterator.hasNext(); ++i) {
            arrayDeque2.offer(iterator.next());
        }
        while (!arrayDeque2.isEmpty()) {
            string = (String)arrayDeque2.remove();
            if (iterator.hasNext()) {
                String string2 = iterator.next();
                arrayDeque2.offer(string2);
            }
            if (!string.equals("")) {
                TernaryVector ternaryVector;
                SemanticVector semanticVector = this.getSemanticVector(string);
                int n = -arrayDeque.size();
                for (String string3 : arrayDeque) {
                    if (string3.equals("")) {
                        ++n;
                        continue;
                    }
                    ternaryVector = this.wordToIndexVector.get(string3);
                    if (this.usePermutations) {
                        ternaryVector = this.permutationFunc.permute(ternaryVector, n);
                        ++n;
                    }
                    this.updateSemantics(semanticVector, string3, ternaryVector);
                }
                n = 1;
                for (String string3 : arrayDeque2) {
                    if (string3.equals("")) {
                        ++n;
                        continue;
                    }
                    ternaryVector = this.wordToIndexVector.get(string3);
                    if (this.usePermutations) {
                        ternaryVector = this.permutationFunc.permute(ternaryVector, n);
                        ++n;
                    }
                    this.updateSemantics(semanticVector, string3, ternaryVector);
                }
            }
            arrayDeque.offer(string);
            Integer n = this.wordToOccurrences.get(string);
            this.wordToOccurrences.put(string, n == null ? 1 : n + 1);
            if (arrayDeque.size() <= this.windowSize) continue;
            arrayDeque.remove();
        }
        bufferedReader.close();
    }

    @Override
    public void processSpace(Properties properties) {
    }

    public void setWordToIndexVector(Map<String, TernaryVector> map) {
        this.wordToIndexVector.clear();
        this.wordToIndexVector.putAll(map);
    }

    private void updateSemantics(SemanticVector semanticVector, String string, TernaryVector ternaryVector) {
        SemanticVector semanticVector2 = this.getSemanticVector(string);
        Integer n = this.wordToOccurrences.get(string);
        if (n == null) {
            n = 0;
        }
        double d = 1.0 / Math.exp((double)n.intValue() / this.historyDecayRate);
        IncrementalSemanticAnalysis.add(semanticVector, ternaryVector, this.impactRate * (1.0 - d));
        semanticVector.addVector(semanticVector2, this.impactRate * d);
    }

    private static void add(DoubleVector doubleVector, TernaryVector ternaryVector, double d) {
        for (int n : ternaryVector.positiveDimensions()) {
            doubleVector.add(n, d);
        }
        for (int n : ternaryVector.negativeDimensions()) {
            doubleVector.add(n, -d);
        }
    }

    private class SparseSemanticVector
    extends SparseHashDoubleVector
    implements SemanticVector<SparseDoubleVector> {
        private static final long serialVersionUID = 1L;

        public SparseSemanticVector(int n) {
            super(n);
        }

        @Override
        public void addVector(SparseDoubleVector sparseDoubleVector, double d) {
            for (int n : sparseDoubleVector.getNonZeroIndices()) {
                this.add(n, d * sparseDoubleVector.get(n));
            }
        }
    }

    private class DenseSemanticVector
    extends DenseVector
    implements SemanticVector<DenseVector> {
        private static final long serialVersionUID = 1L;

        public DenseSemanticVector(int n) {
            super(n);
        }

        @Override
        public void addVector(DenseVector denseVector, double d) {
            int n = denseVector.length();
            for (int i = 0; i < n; ++i) {
                this.add(i, d * denseVector.get(i));
            }
        }
    }

    private static interface SemanticVector<T extends DoubleVector>
    extends DoubleVector {
        public void addVector(T var1, double var2);
    }
}

