/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.index;

import edu.ucla.sspace.index.IntegerVectorGenerator;
import edu.ucla.sspace.vector.TernaryVector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;

public class RandomIndexVectorGenerator
implements IntegerVectorGenerator<TernaryVector>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Random RANDOM = new Random();
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.index.RandomIndexVectorGenerator";
    public static final String VALUES_TO_SET_PROPERTY = "edu.ucla.sspace.index.RandomIndexVectorGenerator.values";
    public static final String INDEX_VECTOR_VARIANCE_PROPERTY = "edu.ucla.sspace.index.RandomIndexVectorGenerator.variance";
    public static final int DEFAULT_INDEX_VECTOR_VALUES = 4;
    public static final int DEFAULT_INDEX_VECTOR_LENGTH = 20000;
    public static final int DEFAULT_INDEX_VECTOR_VARIANCE = 0;
    private int numVectorValues;
    private int variance;
    private int indexVectorLength;

    public RandomIndexVectorGenerator(int n) {
        this(n, System.getProperties());
    }

    public RandomIndexVectorGenerator(int n, Properties properties) {
        this.indexVectorLength = n;
        String string = properties.getProperty(VALUES_TO_SET_PROPERTY);
        this.numVectorValues = string != null ? Integer.parseInt(string) : 4;
        String string2 = properties.getProperty(INDEX_VECTOR_VARIANCE_PROPERTY);
        this.variance = string2 != null ? Integer.parseInt(string2) : 0;
    }

    @Override
    public TernaryVector generate() {
        int n;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet hashSet2 = new HashSet();
        int n2 = this.numVectorValues + (int)(RANDOM.nextDouble() * (double)this.variance * (double)(RANDOM.nextDouble() > 0.5 ? 1 : -1));
        for (int i = 0; i < n2; ++i) {
            boolean bl = false;
            while (!bl) {
                int n3 = RANDOM.nextInt(this.indexVectorLength);
                if (hashSet.contains(n3) || hashSet2.contains(n3)) continue;
                (RANDOM.nextDouble() > 0.5 ? hashSet : hashSet2).add(n3);
                bl = true;
            }
        }
        int[] nArray = new int[hashSet.size()];
        int[] nArray2 = new int[hashSet2.size()];
        Iterator iterator = hashSet.iterator();
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (Integer)iterator.next();
        }
        iterator = hashSet2.iterator();
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = (Integer)iterator.next();
        }
        Arrays.sort(nArray);
        Arrays.sort(nArray2);
        return new TernaryVector(this.indexVectorLength, nArray, nArray2);
    }
}

