/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.hal;

import edu.ucla.sspace.vector.SparseDoubleVector;
import java.io.Serializable;

class ConcatenatedSparseDoubleVector
implements SparseDoubleVector,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SparseDoubleVector v1;
    private final SparseDoubleVector v2;

    public ConcatenatedSparseDoubleVector(SparseDoubleVector sparseDoubleVector, SparseDoubleVector sparseDoubleVector2) {
        this.v1 = sparseDoubleVector;
        this.v2 = sparseDoubleVector2;
    }

    @Override
    public double add(int n, double d) {
        return n < this.v1.length() ? this.v1.add(n, n) : this.v2.add(n - this.v1.length(), d);
    }

    @Override
    public double get(int n) {
        return n < this.v1.length() ? this.v1.get(n) : this.v2.get(n - this.v1.length());
    }

    @Override
    public int[] getNonZeroIndices() {
        int[] nArray = this.v1.getNonZeroIndices();
        int[] nArray2 = this.v2.getNonZeroIndices();
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        int n = 0;
        int n2 = nArray.length;
        while (n < nArray2.length) {
            nArray3[n2] = nArray2[n] + this.v1.length();
            ++n;
            ++n2;
        }
        return nArray3;
    }

    @Override
    public Double getValue(int n) {
        return n < this.v1.length() ? (Number)this.v1.getValue(n) : (Number)this.v2.getValue(n - this.v1.length());
    }

    @Override
    public int length() {
        return this.v1.length() + this.v2.length();
    }

    @Override
    public double magnitude() {
        double d;
        double d2 = 0.0;
        for (int n : this.v1.getNonZeroIndices()) {
            d = this.v1.get(n);
            d2 += d * d;
        }
        for (int n : this.v2.getNonZeroIndices()) {
            d = this.v2.get(n);
            d2 += d * d;
        }
        return Math.sqrt(d2);
    }

    @Override
    public void set(int n, Number number) {
        if (n < this.v1.length()) {
            this.v1.set(n, n);
        } else {
            this.v2.set(n - this.v1.length(), number);
        }
    }

    @Override
    public void set(int n, double d) {
        if (n < this.v1.length()) {
            this.v1.set(n, n);
        } else {
            this.v2.set(n - this.v1.length(), d);
        }
    }

    @Override
    public double[] toArray() {
        double[] dArray = new double[this.length()];
        for (int n : this.v1.getNonZeroIndices()) {
            dArray[n] = this.v1.get(n);
        }
        for (int n : this.v2.getNonZeroIndices()) {
            dArray[n + this.v1.length()] = this.v2.get(n);
        }
        return dArray;
    }
}

