/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.gws;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.common.DimensionallyInterpretableSemanticSpace;
import edu.ucla.sspace.common.Filterable;
import edu.ucla.sspace.gws.WordBasisMapping;
import edu.ucla.sspace.gws.WordOrderBasisMapping;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.util.Duple;
import edu.ucla.sspace.vector.CompactSparseIntegerVector;
import edu.ucla.sspace.vector.SparseIntegerVector;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class GenericWordSpace
implements DimensionallyInterpretableSemanticSpace<String>,
Filterable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GWS_SSPACE_NAME = "generic-word-space";
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.gws.GenericWordSpace";
    public static final String WINDOW_SIZE_PROPERTY = "edu.ucla.sspace.gws.GenericWordSpace.windowSize";
    public static final String USE_WORD_ORDER_PROPERTY = "edu.ucla.sspace.gws.GenericWordSpace.useWordOrder";
    public static final int DEFAULT_WINDOW_SIZE = 2;
    private final Map<String, SparseIntegerVector> wordToSemantics;
    private final int windowSize;
    private final Set<String> semanticFilter;
    private final BasisMapping<Duple<String, Integer>, String> basisMapping;

    public GenericWordSpace() {
        this(System.getProperties());
    }

    public GenericWordSpace(Properties properties) {
        String string = properties.getProperty(WINDOW_SIZE_PROPERTY);
        this.windowSize = string != null ? Integer.parseInt(string) : 2;
        String string2 = properties.getProperty(USE_WORD_ORDER_PROPERTY);
        boolean bl = string2 != null ? Boolean.parseBoolean(string2) : false;
        this.basisMapping = bl ? new WordOrderBasisMapping() : new WordBasisMapping();
        this.wordToSemantics = new HashMap<String, SparseIntegerVector>(1024, 4.0f);
        this.semanticFilter = new HashSet<String>();
    }

    public GenericWordSpace(int n) {
        this(n, new WordBasisMapping());
    }

    public GenericWordSpace(int n, boolean bl) {
        this(n, bl ? new WordOrderBasisMapping() : new WordBasisMapping());
    }

    public GenericWordSpace(int n, BasisMapping<Duple<String, Integer>, String> basisMapping) {
        this.windowSize = n;
        this.basisMapping = basisMapping;
        this.wordToSemantics = new HashMap<String, SparseIntegerVector>(1024, 4.0f);
        this.semanticFilter = new HashSet<String>();
    }

    public void clearSemantics() {
        this.wordToSemantics.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparseIntegerVector getSemanticVector(String string) {
        SparseIntegerVector sparseIntegerVector = this.wordToSemantics.get(string);
        if (sparseIntegerVector == null) {
            GenericWordSpace genericWordSpace = this;
            synchronized (genericWordSpace) {
                sparseIntegerVector = this.wordToSemantics.get(string);
                if (sparseIntegerVector == null) {
                    sparseIntegerVector = new CompactSparseIntegerVector(Integer.MAX_VALUE);
                    this.wordToSemantics.put(string, sparseIntegerVector);
                }
            }
        }
        return sparseIntegerVector;
    }

    @Override
    public String getDimensionDescription(int n) {
        return this.basisMapping.getDimensionDescription(n);
    }

    @Override
    public SparseIntegerVector getVector(String string) {
        SparseIntegerVector sparseIntegerVector = this.wordToSemantics.get(string);
        if (sparseIntegerVector == null) {
            return null;
        }
        return Vectors.immutable(Vectors.subview(sparseIntegerVector, 0, this.getVectorLength()));
    }

    @Override
    public String getSpaceName() {
        return "generic-word-space-w-" + this.windowSize + "-" + this.basisMapping;
    }

    @Override
    public int getVectorLength() {
        return this.basisMapping.numDimensions();
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.wordToSemantics.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        int n;
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(this.windowSize);
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>(this.windowSize);
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        String string = null;
        for (n = 0; n < this.windowSize && iterator.hasNext(); ++n) {
            arrayDeque2.offer(iterator.next());
        }
        while (!arrayDeque2.isEmpty()) {
            string = (String)arrayDeque2.remove();
            if (iterator.hasNext()) {
                String string2 = iterator.next();
                arrayDeque2.offer(string2);
            }
            int n2 = n = this.semanticFilter.isEmpty() || this.semanticFilter.contains(string) && !string.equals("") ? 1 : 0;
            if (n != 0) {
                SparseIntegerVector sparseIntegerVector;
                int n3;
                SparseIntegerVector sparseIntegerVector2 = this.getSemanticVector(string);
                int n4 = -arrayDeque.size();
                for (String string3 : arrayDeque) {
                    if (string3.equals("")) {
                        ++n4;
                        continue;
                    }
                    n3 = this.basisMapping.getDimension(new Duple<String, Integer>(string3, n4));
                    sparseIntegerVector = sparseIntegerVector2;
                    synchronized (sparseIntegerVector) {
                        sparseIntegerVector2.add(n3, 1);
                    }
                    ++n4;
                }
                n4 = 1;
                for (String string3 : arrayDeque2) {
                    if (string3.equals("")) {
                        ++n4;
                        continue;
                    }
                    n3 = this.basisMapping.getDimension(new Duple<String, Integer>(string3, n4));
                    sparseIntegerVector = sparseIntegerVector2;
                    synchronized (sparseIntegerVector) {
                        sparseIntegerVector2.add(n3, 1);
                    }
                    ++n4;
                }
            }
            arrayDeque.offer(string);
            if (arrayDeque.size() <= this.windowSize) continue;
            arrayDeque.remove();
        }
        bufferedReader.close();
    }

    @Override
    public void processSpace(Properties properties) {
    }

    @Override
    public void setSemanticFilter(Set<String> set) {
        this.semanticFilter.clear();
        this.semanticFilter.addAll(set);
    }
}

