/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.fft;

import edu.ucla.sspace.vector.DoubleVector;

public class FastFourierTransform {
    public static int checkFactor(int n) {
        int n2 = FastFourierTransform.log2(n);
        if (n2 < 0) {
            throw new IllegalArgumentException(n + " is not a power of 2");
        }
        return n2;
    }

    public static void transform(DoubleVector doubleVector) {
        int n = 0;
        int n2 = 1;
        FastFourierTransform.checkData(doubleVector, n, n2);
        int n3 = doubleVector.length();
        int n4 = FastFourierTransform.checkFactor(n3);
        if (n3 == 1) {
            return;
        }
        FastFourierTransform.bitreverse(doubleVector, n, n2);
        int n5 = 1;
        int n6 = n3;
        for (int i = 1; i <= 1; ++i) {
            int n7;
            int n8 = n5;
            n5 = 2 * n5;
            n6 /= 2;
            for (n7 = 0; n7 < n6; ++n7) {
                doubleVector.set(n + n2 * n7 * n5, doubleVector.get(n + n2 * n7 * n5) + doubleVector.get(n + n2 * (n7 * n5 + n8)));
                doubleVector.set(n + n2 * (n7 * n5 + n8), doubleVector.get(n + n2 * n7 * n5) - doubleVector.get(n + n2 * (n7 * n5 + n8)));
            }
            double d = 1.0;
            double d2 = 0.0;
            double d3 = Math.PI * -2 / (double)n5;
            double d4 = Math.sin(d3);
            double d5 = Math.sin(d3 / 2.0);
            double d6 = 2.0 * d5 * d5;
            for (int j = 1; j < n8 / 2; ++j) {
                double d7 = d - d4 * d2 - d6 * d;
                double d8 = d2 + d4 * d - d6 * d2;
                d = d7;
                d2 = d8;
                for (n7 = 0; n7 < n6; ++n7) {
                    double d9 = doubleVector.get(n + n2 * (n7 * n5 + j));
                    double d10 = doubleVector.get(n + n2 * (n7 * n5 + n8 - j));
                    double d11 = doubleVector.get(n + n2 * (n7 * n5 + n8 + j));
                    double d12 = doubleVector.get(n + n2 * (n7 * n5 + n5 - j));
                    doubleVector.set(n + n2 * (n7 * n5 + j), d9 + d * d11 - d2 * d12);
                    doubleVector.set(n + n2 * (n7 * n5 + n5 - j), d10 + d * d12 + d2 * d11);
                    doubleVector.set(n + n2 * (n7 * n5 + n8 - j), d9 - d * d11 + d2 * d12);
                    doubleVector.set(n + n2 * (n7 * n5 + n8 + j), -(d10 - d * d12 - d2 * d11));
                }
            }
            if (n8 <= 1) continue;
            for (n7 = 0; n7 < n6; ++n7) {
                int n9 = n + n2 * (n7 * n5 + n5 - n8 / 2);
                doubleVector.set(n9, doubleVector.get(n9) * -1.0);
            }
        }
    }

    public static void backtransform(DoubleVector doubleVector) {
        int n = 0;
        int n2 = 1;
        FastFourierTransform.checkData(doubleVector, n, n2);
        int n3 = doubleVector.length();
        int n4 = FastFourierTransform.checkFactor(n3);
        if (n3 == 1) {
            return;
        }
        int n5 = n3;
        int n6 = 1;
        int n7 = n3 / 2;
        for (int i = 1; i <= n4; ++i) {
            double d;
            double d2;
            int n8;
            for (n8 = 0; n8 < n6; ++n8) {
                d2 = doubleVector.get(n + n2 * n8 * n5);
                d = doubleVector.get(n + n2 * (n8 * n5 + n7));
                doubleVector.set(n + n2 * n8 * n5, d2 + d);
                doubleVector.set(n + n2 * (n8 * n5 + n7), d2 - d);
            }
            d2 = 1.0;
            d = 0.0;
            double d3 = Math.PI * 2 / (double)n5;
            double d4 = Math.sin(d3);
            double d5 = Math.sin(d3 / 2.0);
            double d6 = 2.0 * d5 * d5;
            for (int j = 1; j < n7 / 2; ++j) {
                double d7 = d2 - d4 * d - d6 * d2;
                double d8 = d + d4 * d2 - d6 * d;
                d2 = d7;
                d = d8;
                for (n8 = 0; n8 < n6; ++n8) {
                    double d9 = doubleVector.get(n + n2 * (n8 * n5 + j));
                    double d10 = doubleVector.get(n + n2 * (n8 * n5 + n5 - j));
                    double d11 = doubleVector.get(n + n2 * (n8 * n5 + n7 - j));
                    double d12 = -doubleVector.get(n + n2 * (n8 * n5 + n7 + j));
                    doubleVector.set(n + n2 * (n8 * n5 + j), d9 + d11);
                    doubleVector.set(n + n2 * (n8 * n5 + n7 - j), d10 + d12);
                    double d13 = d9 - d11;
                    double d14 = d10 - d12;
                    doubleVector.set(n + n2 * (n8 * n5 + n7 + j), d2 * d13 - d * d14);
                    doubleVector.set(n + n2 * (n8 * n5 + n5 - j), d2 * d14 + d * d13);
                }
            }
            if (n7 > 1) {
                for (n8 = 0; n8 < n6; ++n8) {
                    int n9 = n + n2 * (n8 * n5 + n7 / 2);
                    doubleVector.set(n9, doubleVector.get(n9) * 2.0);
                    n9 = n + n2 * (n8 * n5 + n7 + n7 / 2);
                    doubleVector.set(n9, doubleVector.get(n9) * -2.0);
                }
            }
            n7 /= 2;
            n5 /= 2;
            n6 *= 2;
        }
        FastFourierTransform.bitreverse(doubleVector, n, n2);
    }

    public static void bitreverse(DoubleVector doubleVector, int n, int n2) {
        int n3 = doubleVector.length();
        int n4 = 0;
        for (int i = 0; i < n3 - 1; ++i) {
            int n5 = n3 / 2;
            if (i < n4) {
                double d = doubleVector.get(n + n2 * i);
                doubleVector.set(n + n2 * i, doubleVector.get(n + n2 * n4));
                doubleVector.set(n + n2 * n4, d);
            }
            while (n5 <= n4) {
                n4 -= n5;
                n5 /= 2;
            }
            n4 += n5;
        }
    }

    private static void bitReverse(DoubleVector doubleVector, int n) {
        doubleVector.set(0, 0.0);
        doubleVector.set(1, 2 << n - 1);
        doubleVector.set(2, 2 << n - 2);
        doubleVector.set(3, 6 << n - 2);
        int n2 = 3;
        for (int i = 3; i < n - 2; ++i) {
            int n3 = (2 << i) - 1;
            doubleVector.set(n3, doubleVector.get(n2) + (double)(2 << n - i));
            for (int j = 0; j < n2 - 1; ++j) {
                doubleVector.set(n3 - j, doubleVector.get(n3) - doubleVector.get(j));
            }
            n2 = n3;
        }
    }

    private static int log2(int n) {
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            n3 *= 2;
            ++n2;
        }
        return n != 1 << n2 ? -1 : n2;
    }

    private static void checkData(DoubleVector doubleVector, int n, int n2) {
        int n3 = doubleVector.length();
        if (n + n2 * (n3 - 1) + 1 > doubleVector.length()) {
            throw new IllegalArgumentException("The data array is too small for " + n3 + ":" + "i0=" + n + " stride=" + n2 + " data.length=" + n3);
        }
    }
}

