/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.evaluation.WordSimilarity;
import edu.ucla.sspace.evaluation.WordSimilarityEvaluation;
import edu.ucla.sspace.evaluation.WordSimilarityReport;
import edu.ucla.sspace.vector.Vector;
import java.util.ArrayList;
import java.util.Collection;

public class WordSimilarityEvaluationRunner {
    public static WordSimilarityReport evaluate(SemanticSpace semanticSpace, WordSimilarityEvaluation wordSimilarityEvaluation, Similarity.SimType simType) {
        Collection<WordSimilarity> collection = wordSimilarityEvaluation.getPairs();
        int n = 0;
        ArrayList<Double> arrayList = new ArrayList<Double>(collection.size());
        ArrayList<Double> arrayList2 = new ArrayList<Double>(collection.size());
        double d = wordSimilarityEvaluation.getMostSimilarValue() - wordSimilarityEvaluation.getLeastSimilarValue();
        for (WordSimilarity object2 : collection) {
            Vector i = semanticSpace.getVector(object2.getFirstWord());
            Vector vector = semanticSpace.getVector(object2.getSecondWord());
            if (i == null || vector == null) {
                ++n;
                continue;
            }
            double d2 = Similarity.getSimilarity(simType, i, vector);
            double d3 = d2 * d + wordSimilarityEvaluation.getLeastSimilarValue();
            arrayList.add(object2.getSimilarity());
            arrayList2.add(d3);
        }
        Object object3 = new double[arrayList.size()];
        double[] dArray = new double[arrayList.size()];
        for (int d4 = 0; d4 < ((Object)object3).length; ++d4) {
            object3[d4] = (Double)arrayList.get(d4);
            dArray[d4] = (Double)arrayList2.get(d4);
        }
        double d4 = Similarity.correlation((double[])object3, dArray);
        return new SimpleReport(collection.size(), d4, n);
    }

    private static class SimpleReport
    implements WordSimilarityReport {
        private final int numWordPairs;
        private final double correlation;
        private final int unanswerable;

        public SimpleReport(int n, double d, int n2) {
            this.numWordPairs = n;
            this.correlation = d;
            this.unanswerable = n2;
        }

        @Override
        public int numberOfWordPairs() {
            return this.numWordPairs;
        }

        @Override
        public double correlation() {
            return this.correlation;
        }

        @Override
        public int unanswerableQuestions() {
            return this.unanswerable;
        }

        public String toString() {
            return String.format("%.4f correlation; %d/%d unanswered", this.correlation, this.unanswerable, this.numWordPairs);
        }
    }
}

