/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.evaluation.MultipleChoiceQuestion;
import edu.ucla.sspace.evaluation.WordChoiceEvaluation;
import edu.ucla.sspace.evaluation.WordChoiceReport;
import edu.ucla.sspace.vector.Vector;
import java.util.Collection;

public class WordChoiceEvaluationRunner {
    public static WordChoiceReport evaluate(SemanticSpace semanticSpace, WordChoiceEvaluation wordChoiceEvaluation, Similarity.SimType simType) {
        Collection<MultipleChoiceQuestion> collection = wordChoiceEvaluation.getQuestions();
        int n = 0;
        int n2 = 0;
        block0: for (MultipleChoiceQuestion multipleChoiceQuestion : collection) {
            String string = multipleChoiceQuestion.getPrompt();
            Vector vector = semanticSpace.getVector(string);
            if (vector == null) {
                ++n2;
                continue;
            }
            int n3 = 0;
            double d = Double.MIN_VALUE;
            int n4 = 0;
            for (String string2 : multipleChoiceQuestion.getOptions()) {
                Vector vector2 = semanticSpace.getVector(string2);
                if (vector2 == null) {
                    ++n2;
                    continue block0;
                }
                double d2 = Similarity.getSimilarity(simType, vector, vector2);
                if (d2 > d) {
                    n3 = n4;
                    d = d2;
                }
                ++n4;
            }
            if (n3 != multipleChoiceQuestion.getCorrectAnswer()) continue;
            ++n;
        }
        return new SimpleReport(collection.size(), n, n2);
    }

    private static class SimpleReport
    implements WordChoiceReport {
        private final int numQuestions;
        private final int correct;
        private final int unanswerable;

        public SimpleReport(int n, int n2, int n3) {
            this.numQuestions = n;
            this.correct = n2;
            this.unanswerable = n3;
        }

        @Override
        public int numberOfQuestions() {
            return this.numQuestions;
        }

        @Override
        public int correctAnswers() {
            return this.correct;
        }

        @Override
        public int unanswerableQuestions() {
            return this.unanswerable;
        }

        @Override
        public double score() {
            return this.unanswerable == this.numQuestions ? 0.0 : 100.0 * (double)this.correct / (double)(this.numQuestions - this.unanswerable);
        }

        public String toString() {
            return String.format("%.2f correct; %d/%d unanswered", this.score(), this.unanswerable, this.numQuestions);
        }
    }
}

