/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.evaluation.SimpleWordSimilarity;
import edu.ucla.sspace.evaluation.WordSimilarity;
import edu.ucla.sspace.evaluation.WordSimilarityEvaluation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class RubensteinGoodenoughWordSimilarityEvaluation
implements WordSimilarityEvaluation {
    private final Collection<WordSimilarity> pairs;
    private final String dataFileName;

    public RubensteinGoodenoughWordSimilarityEvaluation(String string) {
        this(new File(string));
    }

    public RubensteinGoodenoughWordSimilarityEvaluation(File file) {
        this.pairs = this.parse(file);
        this.dataFileName = file.getName();
    }

    private Collection<WordSimilarity> parse(File file) {
        LinkedList<WordSimilarity> linkedList = new LinkedList<WordSimilarity>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            bufferedReader.readLine();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#") || string.length() == 0) continue;
                String[] stringArray = string.split("\\s+");
                if (stringArray.length != 3) {
                    throw new Error("Unexpected line formatting: " + string);
                }
                linkedList.add(new SimpleWordSimilarity(stringArray[0], stringArray[1], Double.parseDouble(stringArray[2])));
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return linkedList;
    }

    @Override
    public Collection<WordSimilarity> getPairs() {
        return this.pairs;
    }

    @Override
    public double getMostSimilarValue() {
        return 10.0;
    }

    @Override
    public double getLeastSimilarValue() {
        return 0.0;
    }

    public String toString() {
        return "Rubenstein & Goodenough Word Similarity Test [" + this.dataFileName + "]";
    }
}

