/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.evaluation.AbstractNormedWordPrimingTest;
import edu.ucla.sspace.evaluation.NormedPrimingQuestion;
import edu.ucla.sspace.evaluation.SimpleNormedPrimingQuestion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class OneNormedQuestionPerLineTest
extends AbstractNormedWordPrimingTest {
    public OneNormedQuestionPerLineTest(String string) {
        this(new File(string));
    }

    public OneNormedQuestionPerLineTest(File file) {
        super(OneNormedQuestionPerLineTest.prepareQuestionSet(file));
    }

    private static Set<NormedPrimingQuestion> prepareQuestionSet(File file) {
        HashSet<NormedPrimingQuestion> hashSet = new HashSet<NormedPrimingQuestion>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("\\|");
                String[] stringArray2 = new String[stringArray.length - 1];
                double[] dArray = new double[stringArray.length - 1];
                for (int i = 1; i < stringArray.length; ++i) {
                    String[] stringArray3 = stringArray[i].split(",");
                    stringArray2[i - 1] = stringArray3[0].trim();
                    dArray[i - 1] = Double.parseDouble(stringArray3[1]);
                }
                hashSet.add(new SimpleNormedPrimingQuestion(stringArray[0].trim(), stringArray2, dArray));
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return hashSet;
    }

    @Override
    public double computeStrength(SemanticSpace semanticSpace, String string, String string2) {
        return Similarity.cosineSimilarity(semanticSpace.getVector(string), semanticSpace.getVector(string2));
    }
}

