/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.evaluation.WordPrimingReport;
import edu.ucla.sspace.evaluation.WordPrimingTest;
import edu.ucla.sspace.util.Pair;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractWordPrimingTest
implements WordPrimingTest {
    protected final Set<Pair<String>> primeTargetPairs;

    public AbstractWordPrimingTest(Set<Pair<String>> set) {
        this.primeTargetPairs = set;
    }

    @Override
    public WordPrimingReport evaluate(SemanticSpace semanticSpace) {
        Pair<double[]> pair = this.evaluateRelation(semanticSpace, this.primeTargetPairs);
        int n = ((double[])pair.x).length;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += ((double[])pair.x)[i];
            d2 += ((double[])pair.y)[i];
        }
        return new SimpleWordPrimingReport(n, d /= (double)n, d2 /= (double)n);
    }

    private Pair<double[]> evaluateRelation(SemanticSpace semanticSpace, Set<Pair<String>> set) {
        Set<String> set2 = semanticSpace.getWords();
        HashSet hashSet = new HashSet();
        for (Pair<String> object2 : set) {
            if (!set2.contains(object2.x) || !set2.contains(object2.y)) continue;
            hashSet.add(object2.x);
        }
        int n = hashSet.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        for (Pair<String> pair : set) {
            double d;
            if (!set2.contains(pair.x) || !set2.contains(pair.y)) continue;
            double d2 = d = this.computePriming(semanticSpace, (String)pair.x, (String)pair.y).doubleValue();
            for (String string : hashSet) {
                if (string.equals(pair.x)) continue;
                d2 += this.computePriming(semanticSpace, string, (String)pair.y).doubleValue();
            }
            dArray[n2] = d;
            dArray2[n2] = d2 /= (double)hashSet.size();
            ++n2;
        }
        return new Pair<double[]>(dArray, dArray2);
    }

    protected abstract Double computePriming(SemanticSpace var1, String var2, String var3);

    public class SimpleWordPrimingReport
    implements WordPrimingReport {
        private int numDataPoints;
        private double relatedScore;
        private double unrelatedScore;

        public SimpleWordPrimingReport(int n, double d, double d2) {
            this.numDataPoints = n;
            this.relatedScore = d;
            this.unrelatedScore = d2;
        }

        @Override
        public int numberOfWordPairs() {
            return this.numDataPoints;
        }

        @Override
        public double relatedPriming() {
            return this.relatedScore;
        }

        @Override
        public double unrelatedPriming() {
            return this.unrelatedScore;
        }

        @Override
        public double effect() {
            return this.relatedScore - this.unrelatedScore;
        }

        public String toString() {
            return String.format("Primed Pairs: %f\nUnrelated Pairs: %f\n", this.relatedScore, this.unrelatedScore);
        }
    }
}

