/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.evaluation.NormedPrimingQuestion;
import edu.ucla.sspace.evaluation.NormedWordPrimingReport;
import edu.ucla.sspace.evaluation.NormedWordPrimingTest;
import java.util.ArrayList;
import java.util.Set;

public abstract class AbstractNormedWordPrimingTest
implements NormedWordPrimingTest {
    protected final Set<NormedPrimingQuestion> normedWordQuestions;

    public AbstractNormedWordPrimingTest(Set<NormedPrimingQuestion> set) {
        this.normedWordQuestions = set;
    }

    @Override
    public NormedWordPrimingReport evaluate(SemanticSpace semanticSpace) {
        Set<String> set = semanticSpace.getWords();
        int n = this.normedWordQuestions.size();
        int n2 = 0;
        double d = 0.0;
        for (NormedPrimingQuestion normedPrimingQuestion : this.normedWordQuestions) {
            if (set.contains(normedPrimingQuestion.getCue())) {
                Double d2 = this.answerQuestion(semanticSpace, set, normedPrimingQuestion);
                if (d2 == null) {
                    ++n2;
                    continue;
                }
                d += d2.doubleValue();
                continue;
            }
            ++n2;
        }
        double d3 = d / (double)(n - n2);
        return new SimpleNormedWordPrimingReport(n, n2, d3);
    }

    private Double answerQuestion(SemanticSpace semanticSpace, Set<String> set, NormedPrimingQuestion normedPrimingQuestion) {
        Object object;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        String string = normedPrimingQuestion.getCue();
        for (int i = 0; i < normedPrimingQuestion.numberOfTargets(); ++i) {
            object = normedPrimingQuestion.getTarget(i);
            double d = normedPrimingQuestion.getStrength(i);
            if (!set.contains(object)) continue;
            arrayList.add(d);
            arrayList2.add(this.computeStrength(semanticSpace, string, (String)object));
        }
        if (arrayList.size() < 2) {
            return null;
        }
        double[] dArray = new double[arrayList.size()];
        object = new double[arrayList.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)arrayList.get(i);
            object[i] = (Double)arrayList2.get(i);
        }
        return Similarity.spearmanRankCorrelationCoefficient(dArray, (double[])object);
    }

    protected abstract double computeStrength(SemanticSpace var1, String var2, String var3);

    public class SimpleNormedWordPrimingReport
    implements NormedWordPrimingReport {
        private int numberOfCues;
        private int numberOfUnanswerableCues;
        private double averageCorrelation;

        public SimpleNormedWordPrimingReport(int n, int n2, double d) {
            this.numberOfCues = n;
            this.numberOfUnanswerableCues = n2;
            this.averageCorrelation = d;
        }

        @Override
        public double averageCorrelation() {
            return this.averageCorrelation;
        }

        @Override
        public int numberOfCues() {
            return this.numberOfCues;
        }

        @Override
        public int numberOfUnanswerableCues() {
            return this.numberOfUnanswerableCues;
        }

        public String toString() {
            return String.format("Primed cues: %s\nUnanswered cues: %s\nAverage Correlation: %f\n", this.numberOfCues, this.numberOfUnanswerableCues, this.averageCorrelation);
        }
    }
}

