/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dependency;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyRelation;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.util.CombinedIterator;
import java.util.Collections;
import java.util.Iterator;

class ExtendedPathView
implements DependencyPath {
    private final DependencyPath original;
    private final DependencyRelation extension;
    private final int length;

    public ExtendedPathView(DependencyPath dependencyPath, DependencyRelation dependencyRelation) {
        this.original = dependencyPath;
        this.extension = dependencyRelation;
        this.length = dependencyPath.length() + 1;
    }

    @Override
    public DependencyTreeNode first() {
        return this.original.first();
    }

    @Override
    public DependencyRelation firstRelation() {
        return this.original.firstRelation();
    }

    private DependencyTreeNode getNextNode(DependencyRelation dependencyRelation, DependencyRelation dependencyRelation2) {
        return dependencyRelation.headNode() == dependencyRelation2.headNode() || dependencyRelation.dependentNode() == dependencyRelation2.headNode() ? dependencyRelation2.dependentNode() : dependencyRelation2.headNode();
    }

    @Override
    public DependencyTreeNode getNode(int n) {
        if (n < this.length - 1) {
            return this.original.getNode(n);
        }
        if (n > this.length) {
            throw new IllegalArgumentException("invalid node: " + n);
        }
        return this.last();
    }

    @Override
    public String getRelation(int n) {
        if (n < this.length - 1) {
            return this.original.getRelation(n);
        }
        if (n >= this.length) {
            throw new IllegalArgumentException("invalid relation: " + n);
        }
        return this.extension.relation();
    }

    @Override
    public Iterator<DependencyRelation> iterator() {
        CombinedIterator<DependencyRelation> combinedIterator = new CombinedIterator<DependencyRelation>(this.original.iterator(), Collections.singleton(this.extension).iterator());
        return combinedIterator;
    }

    @Override
    public DependencyTreeNode last() {
        return this.getNextNode(this.original.lastRelation(), this.extension);
    }

    @Override
    public DependencyRelation lastRelation() {
        return this.extension;
    }

    @Override
    public int length() {
        return this.length;
    }

    public String toString() {
        int n = this.length() + 1;
        StringBuilder stringBuilder = new StringBuilder(8 * n);
        stringBuilder.append('[');
        stringBuilder.append(this.getNode(0).word());
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(' ').append(this.getRelation(i - 1)).append(' ').append(this.getNode(i).word());
        }
        return stringBuilder.append(']').toString();
    }
}

