/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dependency;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyRelation;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dependency.ExtendedPathView;
import edu.ucla.sspace.dependency.SimpleDependencyPath;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;

public class BreadthFirstPathIterator
implements Iterator<DependencyPath> {
    protected final Queue<DependencyPath> frontier = new ArrayDeque<DependencyPath>();

    public BreadthFirstPathIterator(DependencyTreeNode dependencyTreeNode) {
        for (DependencyRelation dependencyRelation : dependencyTreeNode.neighbors()) {
            SimpleDependencyPath simpleDependencyPath = new SimpleDependencyPath(Collections.singletonList(dependencyRelation), dependencyRelation.headNode().equals(dependencyTreeNode));
            this.frontier.offer(simpleDependencyPath);
        }
    }

    void advance(DependencyPath dependencyPath) {
        DependencyTreeNode dependencyTreeNode = dependencyPath.last();
        DependencyRelation dependencyRelation = dependencyPath.lastRelation();
        for (DependencyRelation dependencyRelation2 : dependencyTreeNode.neighbors()) {
            if (dependencyRelation.equals(dependencyRelation2)) continue;
            ExtendedPathView extendedPathView = new ExtendedPathView(dependencyPath, dependencyRelation2);
            this.frontier.offer(extendedPathView);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.frontier.isEmpty();
    }

    @Override
    public DependencyPath next() {
        DependencyPath dependencyPath = this.frontier.remove();
        this.advance(dependencyPath);
        return dependencyPath;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal is not possible");
    }
}

