/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.util.BoundedSortedMultiMap;
import edu.ucla.sspace.util.MultiMap;
import edu.ucla.sspace.util.SortedMultiMap;
import edu.ucla.sspace.util.WorkerThread;
import edu.ucla.sspace.vector.Vector;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

public class WordComparator {
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();

    public WordComparator() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public WordComparator(int n) {
        for (int i = 0; i < n; ++i) {
            new WorkerThread(this.workQueue, 10).start();
        }
    }

    public SortedMultiMap<Double, String> getMostSimilar(String string, SemanticSpace semanticSpace, int n, Similarity.SimType simType) {
        BoundedSortedMultiMap<Double, String> boundedSortedMultiMap;
        block4: {
            Vector vector = semanticSpace.getVector(string);
            if (vector == null) {
                return null;
            }
            Vector vector2 = vector;
            Set<String> set = semanticSpace.getWords();
            boundedSortedMultiMap = new BoundedSortedMultiMap<Double, String>(n, false);
            Semaphore semaphore = new Semaphore(0 - (set.size() - 2));
            boolean bl = false;
            for (String string2 : set) {
                String string3 = string2;
                if (string.equals(string3)) continue;
                this.workQueue.offer(new Comparison(semaphore, semanticSpace, vector2, string3, simType, boundedSortedMultiMap));
            }
            try {
                semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                if (semaphore.availablePermits() >= 1) break block4;
                throw new IllegalStateException("interrupted while waiting for word comparisons to finish", interruptedException);
            }
        }
        return boundedSortedMultiMap;
    }

    private static class Comparison
    implements Runnable {
        private final Semaphore semaphore;
        SemanticSpace sspace;
        Vector vector;
        String other;
        Similarity.SimType similarityMeasure;
        MultiMap<Double, String> mostSimilar;

        public Comparison(Semaphore semaphore, SemanticSpace semanticSpace, Vector vector, String string, Similarity.SimType simType, MultiMap<Double, String> multiMap) {
            this.semaphore = semaphore;
            this.sspace = semanticSpace;
            this.vector = vector;
            this.other = string;
            this.similarityMeasure = simType;
            this.mostSimilar = multiMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Vector vector = this.sspace.getVector(this.other);
                Double d = Similarity.getSimilarity(this.similarityMeasure, this.vector, vector);
                MultiMap<Double, String> multiMap = this.mostSimilar;
                synchronized (multiMap) {
                    this.mostSimilar.put(d, this.other);
                }
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
            finally {
                this.semaphore.release();
            }
        }
    }
}

