/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.util.IntegerMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class Statistics {
    private Statistics() {
    }

    public static double entropy(int[] nArray) {
        IntegerMap<Integer> integerMap = new IntegerMap<Integer>();
        for (int n : nArray) {
            Integer n2 = (Integer)integerMap.get((Object)n);
            integerMap.put(n, Integer.valueOf(n2 == null ? 1 : 1 + n2));
        }
        double d = 0.0;
        double d2 = nArray.length;
        for (Integer n : integerMap.values()) {
            double d3 = (double)n.intValue() / d2;
            d -= d3 * Statistics.log2(d3);
        }
        return d;
    }

    public static double entropy(double[] dArray) {
        HashMap<Double, Integer> hashMap = new HashMap<Double, Integer>();
        for (double d : dArray) {
            Integer n = (Integer)hashMap.get(d);
            hashMap.put(d, n == null ? 1 : 1 + n);
        }
        double d = 0.0;
        double d2 = dArray.length;
        for (Integer n : hashMap.values()) {
            double d3 = (double)n.intValue() / d2;
            d -= d3 * Statistics.log2(d3);
        }
        return d;
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static double log2_1p(double d) {
        return Math.log1p(d) / Math.log(2.0);
    }

    public static double mean(Collection<? extends Number> collection) {
        double d = 0.0;
        for (Number number : collection) {
            d += number.doubleValue();
        }
        return d / (double)collection.size();
    }

    public static double mean(int[] nArray) {
        double d = 0.0;
        for (int n : nArray) {
            d += (double)n;
        }
        return d / (double)nArray.length;
    }

    public static double mean(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d / (double)dArray.length;
    }

    public static <T extends Number> T median(Collection<T> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("No median in an empty collection");
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        Collections.sort(arrayList);
        return (T)((Number)arrayList.get(arrayList.size() / 2));
    }

    public static double median(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("No median in an empty array");
        }
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Arrays.sort(nArray2);
        return nArray2[nArray2.length / 2];
    }

    public static double median(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException("No median in an empty array");
        }
        double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
        Arrays.sort(dArray2);
        return dArray2[dArray2.length / 2];
    }

    public static BitSet randomDistribution(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException("too many values for range");
        }
        BitSet bitSet = new BitSet(n2);
        if (n < n2 / 2) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = (int)(Math.random() * (double)n2);
                if (bitSet.get(n4)) continue;
                bitSet.set(n4, true);
                ++n3;
            }
        } else {
            bitSet.set(0, n2, true);
            int n5 = n2;
            while (n5 > n) {
                int n6 = (int)(Math.random() * (double)n2);
                if (!bitSet.get(n6)) continue;
                bitSet.set(n6, false);
                --n5;
            }
        }
        return bitSet;
    }

    public static double stddev(Collection<? extends Number> collection) {
        double d = Statistics.mean(collection);
        double d2 = 0.0;
        for (Number number : collection) {
            double d3 = number.doubleValue() - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)collection.size());
    }

    public static double stderr(Collection<? extends Number> collection) {
        return Statistics.sampleStddev(collection) / Math.sqrt(collection.size());
    }

    public static double stderr(int[] nArray) {
        return Statistics.sampleStddev(nArray) / Math.sqrt(nArray.length);
    }

    public static double stderr(double[] dArray) {
        return Statistics.sampleStddev(dArray) / Math.sqrt(dArray.length);
    }

    public static double stddev(int[] nArray) {
        double d = Statistics.mean(nArray);
        double d2 = 0.0;
        for (int n : nArray) {
            double d3 = (double)n - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)nArray.length);
    }

    public static double stddev(double[] dArray) {
        double d = Statistics.mean(dArray);
        double d2 = 0.0;
        for (double d3 : dArray) {
            double d4 = d3 - d;
            d2 += d4 * d4;
        }
        return Math.sqrt(d2 / (double)dArray.length);
    }

    public static double sampleStddev(Collection<? extends Number> collection) {
        if (collection.size() < 2) {
            throw new IllegalArgumentException("Must have at least two values");
        }
        double d = Statistics.mean(collection);
        double d2 = 0.0;
        for (Number number : collection) {
            double d3 = number.doubleValue() - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)(collection.size() - 1));
    }

    public static double sampleStddev(int[] nArray) {
        if (nArray.length < 2) {
            throw new IllegalArgumentException("Must have at least two values");
        }
        double d = Statistics.mean(nArray);
        double d2 = 0.0;
        for (int n : nArray) {
            double d3 = (double)n - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)(nArray.length - 1));
    }

    public static double sampleStddev(double[] dArray) {
        if (dArray.length < 2) {
            throw new IllegalArgumentException("Must have at least two values");
        }
        double d = Statistics.mean(dArray);
        double d2 = 0.0;
        for (double d3 : dArray) {
            double d4 = d3 - d;
            d2 += d4 * d4;
        }
        return Math.sqrt(d2 / (double)(dArray.length - 1));
    }
}

