/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DocumentVectorBuilder {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.common.DocumentVectorBuilder";
    public static final String USE_TERM_FREQUENCIES_PROPERTY = "edu.ucla.sspace.common.DocumentVectorBuilder.usetf";
    private final SemanticSpace sspace;
    private final boolean useTermFreq;

    public DocumentVectorBuilder(SemanticSpace semanticSpace) {
        this(semanticSpace, System.getProperties());
    }

    public DocumentVectorBuilder(SemanticSpace semanticSpace, Properties properties) {
        this.sspace = semanticSpace;
        this.useTermFreq = properties.getProperty(USE_TERM_FREQUENCIES_PROPERTY) != null;
    }

    public DoubleVector buildVector(BufferedReader bufferedReader, DoubleVector doubleVector) {
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        Iterator<String> iterator = IteratorFactory.tokenize(bufferedReader);
        while (iterator.hasNext()) {
            Object object;
            Integer object2 = (Integer)hashMap.get(object = iterator.next());
            hashMap.put(object, object2 == null || !this.useTermFreq ? 1 : object2 + 1);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Vector vector = this.sspace.getVector((String)entry.getKey());
            if (vector == null) continue;
            this.add(doubleVector, vector, (Integer)entry.getValue());
        }
        return doubleVector;
    }

    public void add(DoubleVector doubleVector, Vector vector, int n) {
        if (vector instanceof SparseVector) {
            int[] nArray;
            for (int n2 : nArray = ((SparseVector)vector).getNonZeroIndices()) {
                doubleVector.add(n2, vector.getValue(n2).doubleValue());
            }
        } else {
            for (int i = 0; i < vector.length(); ++i) {
                doubleVector.add(i, vector.getValue(i).doubleValue());
            }
        }
    }
}

