/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering.criterion;

import edu.ucla.sspace.clustering.criterion.BaseFunction;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DenseDynamicMagnitudeVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.VectorMath;
import java.util.List;

public class G1Function
extends BaseFunction {
    private DoubleVector completeCentroid;
    private double[] simToComplete;

    public G1Function() {
    }

    G1Function(List<DoubleVector> list, DoubleVector[] doubleVectorArray, double[] dArray, int[] nArray, int[] nArray2, DoubleVector doubleVector, double[] dArray2) {
        super(list, doubleVectorArray, dArray, nArray, nArray2);
        this.completeCentroid = doubleVector;
        this.simToComplete = dArray2;
    }

    @Override
    protected void subSetup(Matrix matrix) {
        this.completeCentroid = new DenseDynamicMagnitudeVector(matrix.columns());
        for (DoubleVector doubleVector : this.matrix) {
            VectorMath.add(this.completeCentroid, doubleVector);
        }
        this.simToComplete = new double[this.centroids.length];
        for (int i = 0; i < this.centroids.length; ++i) {
            this.simToComplete[i] = VectorMath.dotProduct(this.completeCentroid, this.centroids[i]);
        }
    }

    @Override
    protected double getOldCentroidScore(DoubleVector doubleVector, int n, int n2) {
        double d = this.simToComplete[n];
        d -= VectorMath.dotProduct(this.completeCentroid, doubleVector);
        return d /= G1Function.subtractedMagnitudeSqrd(this.centroids[n], doubleVector);
    }

    @Override
    protected double getNewCentroidScore(int n, DoubleVector doubleVector) {
        double d = this.simToComplete[n];
        d += VectorMath.dotProduct(this.completeCentroid, doubleVector);
        return d /= G1Function.modifiedMagnitudeSqrd(this.centroids[n], doubleVector);
    }

    @Override
    public boolean isMaximize() {
        return false;
    }

    @Override
    protected void updateScores(int n, int n2, DoubleVector doubleVector) {
        int n3 = n;
        this.simToComplete[n3] = this.simToComplete[n3] + VectorMath.dotProduct(this.completeCentroid, doubleVector);
        int n4 = n2;
        this.simToComplete[n4] = this.simToComplete[n4] - VectorMath.dotProduct(this.completeCentroid, doubleVector);
    }
}

