/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignment;
import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.clustering.HardAssignment;
import edu.ucla.sspace.clustering.Merge;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.OnDiskMatrix;
import edu.ucla.sspace.util.WorkQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HierarchicalAgglomerativeClustering
implements Clustering {
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.clustering.HierarchicalAgglomerativeClustering";
    public static final String MIN_CLUSTER_SIMILARITY_PROPERTY = "edu.ucla.sspace.clustering.HierarchicalAgglomerativeClustering.clusterThreshold";
    public static final String CLUSTER_LINKAGE_PROPERTY = "edu.ucla.sspace.clustering.HierarchicalAgglomerativeClustering.clusterLinkage";
    public static final String SIMILARITY_FUNCTION_PROPERTY = "edu.ucla.sspace.clustering.HierarchicalAgglomerativeClustering.simFunc";
    public static final String NUM_CLUSTERS_PROPERTY = "edu.ucla.sspace.clustering.HierarchicalAgglomerativeClustering.numClusters";
    private static final String DEFAULT_MIN_CLUSTER_SIMILARITY_PROPERTY = "-1";
    public static final String DEFAULT_CLUSTER_LINKAGE_PROPERTY = "COMPLETE_LINKAGE";
    private static final String DEFAULT_SIMILARITY_FUNCTION_PROPERTY = "COSINE";
    private static final Logger LOGGER = Logger.getLogger(HierarchicalAgglomerativeClustering.class.getName());
    private static final WorkQueue WORK_QUEUE = new WorkQueue();

    @Override
    public Assignments cluster(Matrix matrix, Properties properties) {
        String string = properties.getProperty(MIN_CLUSTER_SIMILARITY_PROPERTY);
        String string2 = properties.getProperty(NUM_CLUSTERS_PROPERTY);
        String string3 = properties.getProperty(SIMILARITY_FUNCTION_PROPERTY);
        String string4 = properties.getProperty(CLUSTER_LINKAGE_PROPERTY);
        Similarity.SimType simType = Similarity.SimType.valueOf(string3 == null ? DEFAULT_SIMILARITY_FUNCTION_PROPERTY : string3);
        ClusterLinkage clusterLinkage = ClusterLinkage.valueOf(string4 == null ? DEFAULT_CLUSTER_LINKAGE_PROPERTY : string4);
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("This class requires either a specified number of clusters or a minimum cluster similarity threshold in order to partition throw rows of the input.  Either needs to be provided as a property");
        }
        if (string != null && string2 != null) {
            throw new IllegalArgumentException("Cannot specify both a fixed number of clusters AND a minimum cluster similarity as input properties");
        }
        if (string != null) {
            try {
                double d = Double.parseDouble(string);
                return HierarchicalAgglomerativeClustering.toAssignments(HierarchicalAgglomerativeClustering.cluster(matrix, d, clusterLinkage, simType, -1), matrix, -1);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Cluster similarity threshold was not a valid double: " + string);
            }
        }
        return this.cluster(matrix, -1, properties);
    }

    @Override
    public Assignments cluster(Matrix matrix, int n, Properties properties) {
        double d = Double.parseDouble(properties.getProperty(MIN_CLUSTER_SIMILARITY_PROPERTY, DEFAULT_MIN_CLUSTER_SIMILARITY_PROPERTY));
        ClusterLinkage clusterLinkage = ClusterLinkage.valueOf(properties.getProperty(CLUSTER_LINKAGE_PROPERTY, DEFAULT_CLUSTER_LINKAGE_PROPERTY));
        Similarity.SimType simType = Similarity.SimType.valueOf(properties.getProperty(SIMILARITY_FUNCTION_PROPERTY, DEFAULT_SIMILARITY_FUNCTION_PROPERTY));
        return HierarchicalAgglomerativeClustering.toAssignments(HierarchicalAgglomerativeClustering.cluster(matrix, d, clusterLinkage, simType, n), matrix, n);
    }

    public static int[] partitionRows(Matrix matrix, int n, ClusterLinkage clusterLinkage, Similarity.SimType simType) {
        return HierarchicalAgglomerativeClustering.cluster(matrix, -1.0, clusterLinkage, simType, n);
    }

    public static int[] clusterRows(Matrix matrix, double d, ClusterLinkage clusterLinkage, Similarity.SimType simType) {
        return HierarchicalAgglomerativeClustering.cluster(matrix, d, clusterLinkage, simType, -1);
    }

    private static int[] cluster(Matrix matrix, double d, ClusterLinkage clusterLinkage, Similarity.SimType simType, int n) {
        int n2 = matrix.rows();
        LOGGER.info("Generating similarity matrix for " + n2 + " data points");
        Matrix matrix2 = HierarchicalAgglomerativeClustering.computeSimilarityMatrix(matrix, simType);
        Map<Integer, Set<Integer>> map = HierarchicalAgglomerativeClustering.generateInitialAssignment(n2);
        LOGGER.info("Calculating initial inter-cluster similarity using " + (Object)((Object)clusterLinkage));
        HashMap<Integer, Pairing> hashMap = new HashMap<Integer, Pairing>();
        for (Integer n3 : map.keySet()) {
            hashMap.put(n3, HierarchicalAgglomerativeClustering.findMostSimilar(map, n3, clusterLinkage, matrix2));
        }
        LOGGER.info("Assigning clusters");
        int n4 = n2;
        while (map.size() > n) {
            Object object;
            int n5 = 0;
            int n6 = 0;
            double d2 = -1.0;
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (Pairing)entry.getValue();
                Integer n3 = (Integer)entry.getKey();
                Integer n7 = ((Pairing)object).pairedIndex;
                if (!(((Pairing)object).similarity > d2)) continue;
                n5 = n3;
                n6 = n7;
                d2 = ((Pairing)object).similarity;
            }
            if (n < 1 && d2 < d) break;
            int n9 = n4++;
            Set<Integer> object22 = map.get(n5);
            object = map.get(n6);
            LOGGER.log(Level.FINE, "Merged cluster {0} with {1}", new Object[]{object22, object});
            object22.addAll((Collection<Integer>)object);
            map.put(n9, object22);
            map.remove(n5);
            map.remove(n6);
            hashMap.remove(n5);
            hashMap.remove(n6);
            double d3 = -1.0;
            Integer n8 = null;
            if (hashMap.isEmpty()) break;
            for (Map.Entry entry : hashMap.entrySet()) {
                Integer n10 = (Integer)entry.getKey();
                double d4 = HierarchicalAgglomerativeClustering.getSimilarity(matrix2, object22, map.get(n10), clusterLinkage);
                if (d4 > d3) {
                    d3 = d4;
                    n8 = n10;
                }
                Pairing pairing = (Pairing)entry.getValue();
                if (pairing.pairedIndex != n5 && pairing.pairedIndex != n6) continue;
                entry.setValue(HierarchicalAgglomerativeClustering.findMostSimilar(map, n10, clusterLinkage, matrix2));
            }
            hashMap.put(n9, new Pairing(d3, n8));
        }
        return HierarchicalAgglomerativeClustering.toAssignArray(map, n2);
    }

    public List<Merge> buildDendogram(Matrix matrix, ClusterLinkage clusterLinkage, Similarity.SimType simType) {
        int n = matrix.rows();
        LOGGER.finer("Generating similarity matrix for " + n + " data points");
        Matrix matrix2 = HierarchicalAgglomerativeClustering.computeSimilarityMatrix(matrix, simType);
        return this.buildDendrogram(matrix2, clusterLinkage);
    }

    public List<Merge> buildDendrogram(Matrix matrix, ClusterLinkage clusterLinkage) {
        if (matrix.rows() != matrix.columns()) {
            throw new IllegalArgumentException("Similarity matrix must be square");
        }
        if (!(matrix instanceof OnDiskMatrix)) {
            LOGGER.fine("Similarity matrix supports fast multi-threaded access; switching to multi-threaded clustering");
            return this.buildDendogramMultithreaded(matrix, clusterLinkage);
        }
        int n = matrix.rows();
        Map<Integer, Set<Integer>> map = HierarchicalAgglomerativeClustering.generateInitialAssignment(n);
        LOGGER.finer("Calculating initial inter-cluster similarity using " + (Object)((Object)clusterLinkage));
        HashMap<Integer, Pairing> hashMap = new HashMap<Integer, Pairing>();
        for (Integer n2 : map.keySet()) {
            hashMap.put(n2, HierarchicalAgglomerativeClustering.findMostSimilar(map, n2, clusterLinkage, matrix));
        }
        LOGGER.finer("Assigning clusters");
        ArrayList arrayList = new ArrayList(n - 1);
        for (int i = 0; i < n - 1; ++i) {
            Object object;
            LOGGER.finer("Computing dendogram merge" + i + "/" + (n - 1));
            int n3 = 0;
            int n4 = 0;
            double d = -1.0;
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (Pairing)entry.getValue();
                Integer n2 = (Integer)entry.getKey();
                Integer n5 = ((Pairing)object).pairedIndex;
                if (!(((Pairing)object).similarity > d)) continue;
                n3 = n2;
                n4 = n5;
                d = ((Pairing)object).similarity;
            }
            if (n3 > n4) {
                int n7 = n4;
                n4 = n3;
                n3 = n7;
            }
            Merge merge = new Merge(n3, n4, d);
            arrayList.add(merge);
            Set<Integer> object22 = map.get(n3);
            object = map.get(n4);
            LOGGER.log(Level.FINER, "Merged cluster {0} with {1}, similarity {2}", new Object[]{n3, n4, d});
            object22.addAll((Collection<Integer>)object);
            map.remove(n4);
            hashMap.remove(n4);
            if (map.size() == 1) break;
            double d2 = -1.0;
            Integer n6 = null;
            for (Map.Entry entry : hashMap.entrySet()) {
                Integer n7 = (Integer)entry.getKey();
                if (n7 == n3) continue;
                double d3 = HierarchicalAgglomerativeClustering.getSimilarity(matrix, object22, map.get(n7), clusterLinkage);
                if (d3 > d2) {
                    d2 = d3;
                    n6 = n7;
                }
                Pairing pairing = (Pairing)entry.getValue();
                if (pairing.pairedIndex != n3 && pairing.pairedIndex != n4) continue;
                entry.setValue(HierarchicalAgglomerativeClustering.findMostSimilar(map, n7, clusterLinkage, matrix));
            }
            hashMap.put(n3, new Pairing(d2, n6));
        }
        return arrayList;
    }

    private List<Merge> buildDendogramMultithreaded(final Matrix matrix, final ClusterLinkage clusterLinkage) {
        int n = matrix.rows();
        final Map<Integer, Set<Integer>> map = HierarchicalAgglomerativeClustering.generateInitialAssignment(n);
        LOGGER.finer("Calculating initial inter-cluster similarity using " + (Object)((Object)clusterLinkage));
        final ConcurrentHashMap<Integer, Pairing> concurrentHashMap = new ConcurrentHashMap<Integer, Pairing>(map.size());
        Object object = WORK_QUEUE.registerTaskGroup(map.size());
        Object object2 = map.keySet().iterator();
        while (object2.hasNext()) {
            Integer n2;
            final Integer n3 = n2 = object2.next();
            WORK_QUEUE.add(object, new Runnable(){

                @Override
                public void run() {
                    concurrentHashMap.put(n3, HierarchicalAgglomerativeClustering.findMostSimilar(map, n3, clusterLinkage, matrix));
                }
            });
        }
        WORK_QUEUE.await(object);
        LOGGER.finer("Assigning clusters");
        object2 = new ArrayList(n - 1);
        for (int i = 0; i < n - 1; ++i) {
            Map.Entry entry;
            Serializable serializable;
            Object object3;
            LOGGER.finer("Computing dendogram merge " + i);
            System.out.println("Computing dendogram merge " + i + "/" + (n - 1));
            int n4 = 0;
            int n5 = 0;
            double d = -1.0;
            for (Map.Entry entry2 : concurrentHashMap.entrySet()) {
                object3 = (Pairing)entry2.getValue();
                serializable = (Integer)entry2.getKey();
                entry = ((Pairing)object3).pairedIndex;
                if (!(((Pairing)object3).similarity > d)) continue;
                n4 = (Integer)serializable;
                n5 = (Integer)((Object)entry);
                d = ((Pairing)object3).similarity;
            }
            if (n4 > n5) {
                int n6 = n5;
                n5 = n4;
                n4 = n6;
            }
            Merge merge = new Merge(n4, n5, d);
            object2.add(merge);
            final Set<Integer> object42 = map.get(n4);
            object3 = map.get(n5);
            LOGGER.log(Level.FINER, "Merged cluster {0} with {1}, similarity {2}", new Object[]{n4, n5, d});
            object42.addAll((Collection<Integer>)object3);
            map.remove(n5);
            concurrentHashMap.remove(n5);
            if (map.size() == 1) break;
            serializable = new ConcurrentSkipListMap();
            object = WORK_QUEUE.registerTaskGroup(concurrentHashMap.size() - 1);
            entry = concurrentHashMap.entrySet().iterator();
            while (entry.hasNext()) {
                Map.Entry entry3;
                final Map.Entry entry4 = entry3 = (Map.Entry)entry.next();
                final Integer n2 = (Integer)entry4.getKey();
                final Pairing pairing = (Pairing)entry4.getValue();
                final int n3 = n4;
                final int n6 = n5;
                if (n2 == n3) continue;
                WORK_QUEUE.add(object, new Runnable((ConcurrentNavigableMap)((Object)serializable)){
                    final /* synthetic */ ConcurrentNavigableMap val$mostSimilarMap;
                    {
                        this.val$mostSimilarMap = concurrentNavigableMap;
                    }

                    @Override
                    public void run() {
                        double d = -1.0;
                        Integer n = null;
                        double d2 = HierarchicalAgglomerativeClustering.getSimilarity(matrix, object42, (Set)map.get(n2), clusterLinkage);
                        if (d2 > d) {
                            d = d2;
                            n = n2;
                        }
                        if (pairing.pairedIndex == n3 || pairing.pairedIndex == n6) {
                            entry4.setValue(HierarchicalAgglomerativeClustering.findMostSimilar(map, n2, clusterLinkage, matrix));
                        }
                        this.val$mostSimilarMap.put(d, n);
                    }
                });
            }
            WORK_QUEUE.await(object);
            entry = serializable.lastEntry();
            concurrentHashMap.put(n4, new Pairing((Double)entry.getKey(), (Integer)entry.getValue()));
        }
        return object2;
    }

    private static Pairing findMostSimilar(Map<Integer, Set<Integer>> map, int n, ClusterLinkage clusterLinkage, Matrix matrix) {
        double d = -1.0;
        Integer n2 = -1;
        for (Map.Entry<Integer, Set<Integer>> entry : map.entrySet()) {
            double d2;
            Integer n3 = entry.getKey();
            if (n3.equals(n) || !((d2 = HierarchicalAgglomerativeClustering.getSimilarity(matrix, map.get(n), entry.getValue(), clusterLinkage)) > d)) continue;
            d = d2;
            n2 = n3;
        }
        return new Pairing(d, n2);
    }

    private static int[] toAssignArray(Map<Integer, Set<Integer>> map, int n) {
        int n2;
        int[] nArray = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = -1;
        }
        n2 = 0;
        for (Set<Integer> set : map.values()) {
            int n3 = set.iterator().next();
            if (nArray[n3] != -1) continue;
            for (int n4 : set) {
                nArray[n4] = n2;
            }
            ++n2;
        }
        LOGGER.info("total number of clusters: " + n2);
        return nArray;
    }

    private static Assignments toAssignments(int[] nArray, Matrix matrix, int n) {
        int n2;
        if (n == -1) {
            int[] objectArray = nArray;
            n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = objectArray[i];
                n = Math.max(n, n3 + 1);
            }
        }
        Assignment[] assignmentArray = new Assignment[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            assignmentArray[n2] = new HardAssignment(nArray[n2]);
        }
        return new Assignments(n, assignmentArray, matrix);
    }

    private static Map<Integer, Set<Integer>> generateInitialAssignment(int n) {
        HashMap<Integer, Set<Integer>> hashMap = new HashMap<Integer, Set<Integer>>(n);
        for (int i = 0; i < n; ++i) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(i);
            hashMap.put(i, hashSet);
        }
        return hashMap;
    }

    private static Matrix computeSimilarityMatrix(Matrix matrix, Similarity.SimType simType) {
        Matrix matrix2 = Matrices.create(matrix.rows(), matrix.rows(), Matrix.Type.DENSE_ON_DISK);
        for (int i = 0; i < matrix.rows(); ++i) {
            for (int j = i + 1; j < matrix.rows(); ++j) {
                double d = Similarity.getSimilarity(simType, matrix.getRowVector(i), matrix.getRowVector(j));
                matrix2.set(i, j, d);
                matrix2.set(j, i, d);
            }
        }
        return matrix2;
    }

    private static double getSimilarity(Matrix matrix, Set<Integer> set, Set<Integer> set2, ClusterLinkage clusterLinkage) {
        double d = -1.0;
        switch (clusterLinkage) {
            case SINGLE_LINKAGE: {
                double d2 = -1.0;
                for (int n : set) {
                    for (int n2 : set2) {
                        double d3 = matrix.get(n, n2);
                        if (!(d3 > d2)) continue;
                        d2 = d3;
                    }
                }
                d = d2;
                break;
            }
            case COMPLETE_LINKAGE: {
                double d4 = 1.0;
                for (int n : set) {
                    for (int n3 : set2) {
                        double d5 = matrix.get(n, n3);
                        if (!(d5 < d4)) continue;
                        d4 = d5;
                    }
                }
                d = d4;
                break;
            }
            case MEAN_LINKAGE: {
                double d6 = 0.0;
                for (int n : set) {
                    for (int n4 : set2) {
                        d6 += matrix.get(n, n4);
                    }
                }
                d = d6 / (double)(set.size() * set2.size());
                break;
            }
            case MEDIAN_LINKAGE: {
                double[] dArray = new double[set.size() * set2.size()];
                int n = 0;
                for (int n5 : set) {
                    for (int n6 : set2) {
                        dArray[n++] = matrix.get(n5, n6);
                    }
                }
                Arrays.sort(dArray);
                d = dArray[dArray.length / 2];
                break;
            }
            default: {
                assert (false) : "unknown linkage method";
                break;
            }
        }
        return d;
    }

    private static class Pairing
    implements Comparable<Pairing> {
        public final double similarity;
        public final int pairedIndex;

        public Pairing(double d, int n) {
            this.similarity = d;
            this.pairedIndex = n;
        }

        @Override
        public int compareTo(Pairing pairing) {
            return (int)((pairing.similarity - this.similarity) * 2.147483647E9);
        }

        public boolean equals(Object object) {
            return object instanceof Pairing && ((Pairing)object).pairedIndex == this.pairedIndex;
        }

        public int hashCode() {
            return this.pairedIndex;
        }
    }

    public static enum ClusterLinkage {
        SINGLE_LINKAGE,
        COMPLETE_LINKAGE,
        MEAN_LINKAGE,
        MEDIAN_LINKAGE;

    }
}

