/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.clustering.ClutoWrapper;
import edu.ucla.sspace.matrix.Matrix;
import java.io.IOError;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class ClutoClustering
implements Clustering {
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.clustering.ClutoClustering";
    public static final String CLUSTER_METHOD = "edu.ucla.sspace.clustering.ClutoClustering.clusterSimilarity";
    public static final String CLUSTER_CRITERION = "edu.ucla.sspace.clustering.ClutoClustering.clusterCriterion";
    private static Method DEFAULT_CLUSTER_METHOD = Method.AGGLOMERATIVE;
    private static Criterion DEFAULT_CRITERION = Criterion.UPGMA;
    private static final Logger LOGGER = Logger.getLogger(ClutoClustering.class.getName());

    @Override
    public Assignments cluster(Matrix matrix, Properties properties) {
        throw new UnsupportedOperationException("CLUTO requires the number of clusters to be specified and therefore cannot be invoked using this method.");
    }

    @Override
    public Assignments cluster(Matrix matrix, int n, Properties properties) {
        Method method = DEFAULT_CLUSTER_METHOD;
        String string = properties.getProperty(CLUSTER_METHOD);
        if (string != null) {
            method = Method.valueOf(string);
        }
        Criterion criterion = DEFAULT_CRITERION;
        String string2 = properties.getProperty(CLUSTER_CRITERION);
        if (string2 != null) {
            criterion = Criterion.valueOf(string2);
        }
        return this.cluster(matrix, n, method, criterion);
    }

    public Assignments cluster(Matrix matrix, int n, Method method, Criterion criterion) {
        try {
            String string = method.getClutoName();
            String string2 = criterion.getClutoName();
            return ClutoWrapper.cluster(matrix, string, string2, n);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public static enum Criterion {
        I1("i1"),
        I2("i2"),
        E1("e1"),
        G1("g1"),
        G1P("g1p"),
        H1("h1"),
        H2("h2"),
        SLINK("slink"),
        WSLINK("wslink"),
        CLINK("clink"),
        WCLINK("wclink"),
        UPGMA("upgma"),
        WUPGMA("wupgma");

        private final String name;

        private Criterion(String string2) {
            this.name = string2;
        }

        String getClutoName() {
            return this.name;
        }
    }

    public static enum Method {
        REPEATED_BISECTIONS_REPEATED("rbr"),
        KMEANS("direct"),
        AGGLOMERATIVE("agglo"),
        NEAREST_NEIGHBOOR("graph"),
        BAGGLO("bagglo");

        private final String name;

        private Method(String string2) {
            this.name = string2;
        }

        String getClutoName() {
            return this.name;
        }
    }
}

