/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder.gui;

import edu.unc.epidoc.transcoder.TransCoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class Tester
extends JFrame {
    private JButton transform;
    private JSeparator jSeparator2;
    private JMenu jMenuFonts;
    private JScrollPane jScrollPane1;
    private JFileChooser jFileChooser;
    private JTextArea conversionArea;
    private JButton clear;
    private JMenu jMenuDisplay;
    private JMenuItem jMenuItemSaveAs;
    private JMenuItem jMenuItemSave;
    private JMenu jMenuEncodings;
    private JMenu jMenuResult;
    private JMenuItem jMenuItemSetResult;
    private JSeparator jSeparator1;
    private JPanel jPanel1;
    private JMenu jMenuSource;
    private JMenuItem jMenuItemSetSource;
    private JMenuItem jMenuItemOpen;
    private JMenu jMenuFile;
    private JMenu jMenuFontSize;
    private JMenuItem jMenuItemExit;
    private JMenuBar jMenuBar1;
    private TransCoder tc;
    private ArrayList<FontMenuItem> fontItems;
    private int fontSize = 12;
    private int[] fontSizes = new int[]{10, 12, 14, 16};
    private File source;
    private File result;
    private File saveTo;

    public Tester() {
        int i;
        this.initComponents();
        this.tc = new TransCoder();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        this.fontItems = new ArrayList();
        JMenu menu = this.jMenuFonts;
        int i2 = 0;
        int j = 0;
        while (i2 < fonts.length) {
            FontMenuItem fontItem = new FontMenuItem(fonts[i2]);
            this.fontItems.add(fontItem);
            if (j >= 20) {
                JMenu temp = new JMenu("more");
                menu.add(temp);
                menu = temp;
                j = 0;
            }
            menu.add(fontItem);
            ++i2;
            ++j;
        }
        String[] parsers = this.tc.getParsers();
        for (int i3 = 0; i3 < parsers.length; ++i3) {
            this.jMenuSource.add(new EncodingMenuItem(parsers[i3]));
        }
        String[] converters = this.tc.getConverters();
        for (i = 0; i < converters.length; ++i) {
            this.jMenuResult.add(new EncodingMenuItem(converters[i]));
        }
        for (i = 0; i < this.fontSizes.length; ++i) {
            this.jMenuFontSize.add(new FontSizeMenuItem(this.fontSizes[i]));
        }
    }

    private void initComponents() {
        this.jFileChooser = new JFileChooser();
        this.jPanel1 = new JPanel();
        this.clear = new JButton();
        this.transform = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.conversionArea = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemSetSource = new JMenuItem();
        this.jMenuItemSetResult = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItemOpen = new JMenuItem();
        this.jMenuItemSave = new JMenuItem();
        this.jMenuItemSaveAs = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuEncodings = new JMenu();
        this.jMenuSource = new JMenu();
        this.jMenuResult = new JMenu();
        this.jMenuDisplay = new JMenu();
        this.jMenuFonts = new JMenu();
        this.jMenuFontSize = new JMenu();
        this.setTitle("TransCoder Test Form");
        this.setFont(new Font("Arial", 0, 12));
        this.setName("testerFrame");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Tester.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.clear.setText("Clear");
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tester.this.clearActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 330, 0, 0);
        this.jPanel1.add((Component)this.clear, gridBagConstraints);
        this.transform.setText("Transform");
        this.transform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tester.this.transformActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.transform, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jScrollPane1.setPreferredSize(new Dimension(400, 400));
        this.conversionArea.setColumns(20);
        this.conversionArea.setRows(100);
        this.jScrollPane1.setViewportView(this.conversionArea);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jMenuFile.setText("File");
        this.jMenuItemSetSource.setText("Set Source File...");
        this.jMenuItemSetSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tester.this.jMenuItemSetSourceActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSetSource);
        this.jMenuItemSetResult.setText("Set Result File...");
        this.jMenuItemSetResult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tester.this.jMenuItemSetResultActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSetResult);
        this.jMenuFile.add(this.jSeparator2);
        this.jMenuItemOpen.setText("Open...");
        this.jMenuItemOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tester.this.jMenuItemOpenActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpen);
        this.jMenuItemSave.setText("Save...");
        this.jMenuItemSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tester.this.jMenuItemSaveActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSave);
        this.jMenuItemSaveAs.setText("Save As...");
        this.jMenuItemSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tester.this.jMenuItemSaveAsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveAs);
        this.jMenuFile.add(this.jSeparator1);
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tester.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuEncodings.setText("Encodings");
        this.jMenuEncodings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tester.this.jMenuEncodingsActionPerformed(evt);
            }
        });
        this.jMenuSource.setText("Source");
        this.jMenuSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tester.this.jMenuSourceActionPerformed(evt);
            }
        });
        this.jMenuEncodings.add(this.jMenuSource);
        this.jMenuResult.setText("Result");
        this.jMenuEncodings.add(this.jMenuResult);
        this.jMenuBar1.add(this.jMenuEncodings);
        this.jMenuDisplay.setText("Display");
        this.jMenuFonts.setText("Fonts");
        this.jMenuDisplay.add(this.jMenuFonts);
        this.jMenuFontSize.setText("Font Sizes");
        this.jMenuDisplay.add(this.jMenuFontSize);
        this.jMenuBar1.add(this.jMenuDisplay);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void clearActionPerformed(ActionEvent evt) {
        this.conversionArea.setText("");
    }

    private void jMenuItemOpenActionPerformed(ActionEvent evt) {
        try {
            int returnVal = this.jFileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                String enc = "UTF8";
                if (this.tc.getParser() != null) {
                    enc = this.tc.getParser().getEncoding();
                }
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(this.jFileChooser.getSelectedFile()), enc);
                StringBuffer text = new StringBuffer();
                while (in.ready()) {
                    text.append((char)in.read());
                }
                this.conversionArea.setText(text.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jMenuItemSaveActionPerformed(ActionEvent evt) {
        if (this.saveTo != null) {
            try {
                int returnVal = this.jFileChooser.showSaveDialog(this);
                if (returnVal == 0) {
                    this.saveTo = this.jFileChooser.getSelectedFile();
                    if (!this.saveTo.exists()) {
                        this.saveTo.createNewFile();
                    }
                    FileOutputStream fos = new FileOutputStream(this.saveTo);
                    fos.write(this.conversionArea.getText().getBytes(this.tc.getConverter().getEncoding()));
                    fos.flush();
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.jMenuItemSaveAsActionPerformed(evt);
        }
    }

    private void jMenuItemSaveAsActionPerformed(ActionEvent evt) {
        try {
            int returnVal = this.jFileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.saveTo = this.jFileChooser.getSelectedFile();
                if (!this.saveTo.exists()) {
                    this.saveTo.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(this.saveTo);
                fos.write(this.conversionArea.getText().getBytes(this.tc.getConverter().getEncoding()));
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jMenuItemSetResultActionPerformed(ActionEvent evt) {
        int returnVal = this.jFileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            this.result = this.jFileChooser.getSelectedFile();
        }
    }

    private void jMenuItemSetSourceActionPerformed(ActionEvent evt) {
        int returnVal = this.jFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.source = this.jFileChooser.getSelectedFile();
        }
    }

    private void jMenuSourceActionPerformed(ActionEvent evt) {
    }

    private void jMenuEncodingsActionPerformed(ActionEvent evt) {
    }

    private void transformActionPerformed(ActionEvent evt) {
        try {
            if (this.source == null && this.result == null) {
                this.conversionArea.setText(this.tc.getString(this.conversionArea.getText()));
            } else if (this.result != null) {
                if (!this.result.exists()) {
                    this.result.createNewFile();
                }
                FileOutputStream fos = null;
                File tmp = null;
                if (this.source.equals(this.result)) {
                    tmp = File.createTempFile("trc", "tmp");
                    fos = new FileOutputStream(tmp);
                } else {
                    fos = new FileOutputStream(this.result);
                }
                if (this.source != null) {
                    if (this.source.getName().endsWith(".xml")) {
                        this.convert(this.source, fos);
                    } else {
                        this.tc.write(new FileInputStream(this.source), fos);
                    }
                } else {
                    String s = this.tc.getString(this.conversionArea.getText());
                    fos.write(s.getBytes(this.tc.getConverter().getEncoding()));
                    fos.flush();
                    fos.close();
                    this.conversionArea.setText(s);
                }
                if (tmp != null) {
                    tmp.renameTo(this.result);
                }
            } else {
                this.conversionArea.setText(this.tc.getString(this.source));
            }
            this.source = null;
            this.result = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void convert(File in, OutputStream out) throws TransformerException, TransformerConfigurationException, SAXException, IOException, Exception {
        this.tc.writeXML(in, out);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        Tester test = new Tester();
        test.setLocation(100, 100);
        test.setVisible(true);
    }

    private class EncodingMenuItem
    extends JRadioButtonMenuItem {
        public EncodingMenuItem(String name) {
            this.setText(name);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    EncodingMenuItem.this.itemSelected(evt);
                }
            });
        }

        private void itemSelected(ActionEvent evt) {
            JPopupMenu parent = (JPopupMenu)this.getParent();
            Component[] items = parent.getComponents();
            for (int i = 0; i < items.length; ++i) {
                EncodingMenuItem emi = (EncodingMenuItem)items[i];
                emi.deselect();
            }
            this.select();
            try {
                if (parent.getInvoker().equals(Tester.this.jMenuSource)) {
                    Tester.this.tc.setParser(this.getText());
                }
                if (parent.getInvoker().equals(Tester.this.jMenuResult)) {
                    Tester.this.tc.setConverter(this.getText());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void select() {
            this.setSelected(true);
        }

        private void deselect() {
            this.setSelected(false);
        }
    }

    private class FontSizeMenuItem
    extends JRadioButtonMenuItem {
        int size;

        public FontSizeMenuItem(int name) {
            this.setText(Integer.toString(name));
            this.size = name;
            if (this.size == Tester.this.fontSize) {
                this.select();
            }
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FontSizeMenuItem.this.itemSelected(evt);
                }
            });
        }

        private void itemSelected(ActionEvent evt) {
            JPopupMenu parent = (JPopupMenu)this.getParent();
            Component[] items = parent.getComponents();
            for (int i = 0; i < items.length; ++i) {
                FontSizeMenuItem fmi = (FontSizeMenuItem)items[i];
                fmi.deselect();
            }
            this.select();
            Tester.this.fontSize = this.size;
            Tester.this.conversionArea.setFont(new Font(Tester.this.conversionArea.getFont().getName(), 0, Tester.this.fontSize));
        }

        private void select() {
            this.setSelected(true);
        }

        private void deselect() {
            this.setSelected(false);
        }
    }

    private class FontMenuItem
    extends JMenuItem {
        public FontMenuItem(String name) {
            this.setText(name);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FontMenuItem.this.itemSelected(evt);
                }
            });
        }

        private void itemSelected(ActionEvent evt) {
            for (FontMenuItem fmi : Tester.this.fontItems) {
                fmi.deselect();
            }
            this.select();
            Tester.this.conversionArea.setFont(new Font(this.getText(), 0, Tester.this.fontSize));
        }

        public void select() {
            this.setBackground(Color.darkGray);
            this.setForeground(Color.white);
        }

        public void deselect() {
            this.setBackground(Color.lightGray);
            this.setForeground(Color.black);
        }
    }
}

