/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.AbstractGreekConverter;
import edu.unc.epidoc.transcoder.Parser;
import java.util.Properties;

public class UnicodeCConverter
extends AbstractGreekConverter {
    protected Properties unfcc = new Properties();
    protected Properties unfdc = new Properties();

    public UnicodeCConverter() {
        try {
            Class<?> c = this.getClass();
            this.unfcc.load(c.getResourceAsStream("UnicodeCConverter.properties"));
            this.unfdc.load(c.getResourceAsStream("UnicodeDConverter.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String convertToCharacterEntities(Parser in) {
        StringBuffer result = new StringBuffer();
        char[] chars = this.convertToString(in).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch > '\u007f') {
                result.append("&#x" + Integer.toHexString(ch) + ";");
                continue;
            }
            result.append(chars[i]);
        }
        return result.toString();
    }

    public String convertToString(Parser in) {
        StringBuffer result = new StringBuffer();
        while (in.hasNext()) {
            String convert = in.next();
            if (convert.length() > 1) {
                if (this.unfcc.getProperty(convert) != null) {
                    result.append(this.unfcc.getProperty(convert));
                    continue;
                }
                if (convert.indexOf(95) > 0 && convert.length() > 1) {
                    String[] elements = this.split(convert);
                    for (int i = 0; i < elements.length; ++i) {
                        result.append(this.unfdc.getProperty(elements[i], this.unrec));
                    }
                    continue;
                }
                if (convert.length() > 1) {
                    result.append(this.unfdc.getProperty(convert, this.unrec));
                    continue;
                }
                result.append(this.unfdc.getProperty(convert, convert));
                continue;
            }
            result.append(this.unfcc.getProperty(convert, convert));
        }
        return result.toString();
    }
}

