/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.Converter;
import edu.unc.epidoc.transcoder.Parser;
import edu.unc.epidoc.transcoder.gui.Tester;
import edu.unc.epidoc.transcoder.xml.sax.Serializer;
import edu.unc.epidoc.transcoder.xml.sax.TranscodingContentHandler;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransCoder {
    private Parser p;
    private Converter conv;
    private Properties parsers;
    private Properties converters;
    private String[] ps;
    private String[] cv;

    public TransCoder() {
        this.init();
    }

    public TransCoder(String from, String to) throws Exception {
        this.init();
        this.setParser(from);
        this.setConverter(to);
    }

    private void init() {
        Class<?> c = this.getClass();
        this.parsers = new Properties();
        this.converters = new Properties();
        try {
            this.parsers.load(c.getResourceAsStream("parsers.properties"));
            this.converters.load(c.getResourceAsStream("converters.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Parser getParser() {
        return this.p;
    }

    public void setParser(String from) throws Exception {
        String className = this.parsers.containsKey(from) ? (String)this.parsers.get(from) : (from.indexOf(46) > 0 ? from : "edu.unc.epidoc.transcoder." + from + "Parser");
        Class<?> c = Class.forName(className);
        this.p = (Parser)c.newInstance();
    }

    public Converter getConverter() {
        return this.conv;
    }

    public void setConverter(String to) throws Exception {
        String className = this.converters.containsKey(to) ? (String)this.converters.get(to) : (to.indexOf(46) > 0 ? to : "edu.unc.epidoc.transcoder." + to + "Converter");
        Class<?> c = Class.forName(className);
        this.conv = (Converter)c.newInstance();
    }

    public void addParser(String name, String className) {
        try {
            if (!this.parsers.containsValue(className)) {
                this.parsers.put(name, className);
                this.parsers.store(new FileOutputStream(this.getClass().getResource("parsers.properties").getPath()), "Parsers");
                this.ps = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getParsers() {
        if (this.ps == null) {
            this.ps = new String[this.parsers.size()];
            Enumeration<Object> e = this.parsers.keys();
            for (int i = 0; i < this.ps.length; ++i) {
                this.ps[i] = (String)e.nextElement();
            }
        }
        return this.ps;
    }

    public void addConverter(String name, String className) {
        try {
            if (!this.converters.containsValue(className)) {
                this.converters.put(name, className);
                this.converters.store(new FileOutputStream(this.getClass().getResource("converters.properties").getPath()), "Converters");
                this.cv = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getConverters() {
        if (this.cv == null) {
            this.cv = new String[this.converters.size()];
            Enumeration<Object> e = this.converters.keys();
            for (int i = 0; i < this.cv.length; ++i) {
                this.cv[i] = (String)e.nextElement();
            }
        }
        return this.cv;
    }

    public String getString(String in) throws UnsupportedEncodingException {
        this.p.setString(in);
        return this.conv.convertToString(this.p);
    }

    public String getString(File in) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        InputStreamReader isw = new InputStreamReader((InputStream)new FileInputStream(in), this.p.getEncoding());
        StringBuffer strb = new StringBuffer();
        int chr = isw.read();
        while (chr > 0) {
            strb.append((char)chr);
            chr = isw.read();
        }
        isw.close();
        this.p.setString(strb.toString());
        return this.conv.convertToString(this.p);
    }

    public String getString(StringBuffer in, int start, int length) {
        this.p.setStringBuffer(in, start, length);
        return this.conv.convertToString(this.p);
    }

    public void write(InputStream in, OutputStream out) throws IOException, UnsupportedEncodingException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, this.p.getEncoding()));
        PrintStream output = new PrintStream(new BufferedOutputStream(out));
        String line = br.readLine();
        while (line != null) {
            this.p.setString(line);
            output.write(this.conv.convertToString(this.p).getBytes(this.conv.getEncoding()));
            line = br.readLine();
            if (line == null) continue;
            output.println();
        }
        output.flush();
        output.close();
    }

    public void writeXML(File source, OutputStream out) throws Exception {
        TranscodingContentHandler handler = new TranscodingContentHandler();
        Serializer serializer = new Serializer();
        serializer.setOutput(out, "UTF-8");
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(handler);
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        reader.setFeature("http://xml.org/sax/features/validation", false);
        handler.setup(serializer, serializer, this);
        InputSource is = new InputSource(new FileInputStream(source));
        is.setSystemId(source.getAbsoluteFile().getParentFile().getAbsolutePath() + "/");
        reader.parse(is);
    }

    public String getCharacterEntities(String in) throws UnsupportedEncodingException {
        this.p.setString(in);
        return this.conv.convertToCharacterEntities(this.p);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            Tester.main(null);
            return;
        }
        TransCoder tc = new TransCoder();
        File tmpSource = null;
        File result = null;
        boolean xmlMode = false;
        boolean textMode = !xmlMode;
        String filter = null;
        boolean recurse = false;
        boolean verbose = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-s")) {
                    tmpSource = new File(args[++i]);
                }
                if (args[i].equals("-o")) {
                    result = new File(args[++i]);
                }
                if (args[i].equals("-se")) {
                    tc.setParser(args[++i]);
                }
                if (args[i].equals("-oe")) {
                    tc.setConverter(args[++i]);
                }
                if (args[i].equals("-x")) {
                    xmlMode = true;
                    textMode = false;
                }
                if (args[i].equals("-t")) {
                    textMode = true;
                    xmlMode = false;
                }
                if (args[i].equals("-f")) {
                    filter = "." + args[++i];
                }
                if (args[i].equals("-r")) {
                    recurse = true;
                }
                if (args[i].equals("-v")) {
                    verbose = true;
                }
                if (!args[i].equals("--help")) continue;
                System.out.println("The transcoder can be invoked with arguments denoting the source and result files or directories and the source and result encodings.");
                System.out.println("Arguments:");
                System.out.println("-s   The source file or directory.");
                System.out.println("-o   The output file or directory.  If the source is a directory, the result must also be one.");
                System.out.println("-se  The source encoding (default BetaCode).");
                System.out.println("-oe  The output encoding (default UnicodeC).");
                System.out.println("-x   Use XML mode.  Treat the source and result files as XML.  Not needed if the files have a .xml suffix.");
                System.out.println("-t   Use text mode. Treat all files as plain text, regardless of their extension.");
                System.out.println("-f   A filter to be used in determining what files to process, e.g. 'xml' for files ending with '.xml'.");
                System.out.println("-r   Recursively process the input folder.  '-o' is ignored if this flag is used.");
                System.out.println("-v   Verbose output.");
                System.out.println();
                System.out.println("Valid encodings are: BetaCode, PerseusBetaCode (Beta Code using lowercase ASCII), Unicode (input only) UnicodeC (output only), UnicodeD (output only), GreekKeys, SGreek, SPIonic, GreekXLit (output only).");
                System.exit(0);
            }
            if (tc.getParser() == null) {
                tc.setParser("BetaCode");
            }
            if (tc.getConverter() == null) {
                tc.setConverter("UnicodeC");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        final File source = tmpSource;
        if (!source.exists()) {
            System.out.println(source.getAbsolutePath() + " does not exist.");
        }
        if (source.isDirectory()) {
            File[] files = null;
            if (recurse) {
                files = TransCoder.recursiveFileList(source);
            } else if (!result.isDirectory()) {
                System.out.println("If the source is a directory, the result must also be a directory.");
                System.exit(1);
            } else {
                files = source.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        File tmp;
                        return dir.equals(source) && !(tmp = new File(dir, name)).isHidden() && !tmp.isDirectory();
                    }
                });
            }
            for (int i = 0; i < files.length; ++i) {
                if (filter != null && !files[i].getName().endsWith(filter)) continue;
                File out = recurse ? files[i] : new File(result, files[i].getName());
                try {
                    File tmp = File.createTempFile("trc", "tmp");
                    FileOutputStream fos = new FileOutputStream(tmp);
                    if (files[i].getName().endsWith(".xml") && !textMode || xmlMode) {
                        tc.writeXML(files[i], fos);
                    } else {
                        tc.write(new FileInputStream(files[i]), fos);
                    }
                    tmp.renameTo(out);
                    if (!verbose) continue;
                    System.out.println(out);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Can't write to " + out.getAbsolutePath());
                }
            }
            return;
        } else {
            try {
                FileOutputStream fos = null;
                File tmp = null;
                if (source.equals(result)) {
                    tmp = File.createTempFile("trc", "tmp");
                    fos = new FileOutputStream(tmp);
                } else {
                    fos = new FileOutputStream(result);
                }
                if (source.getName().endsWith(".xml") && !textMode || xmlMode) {
                    tc.writeXML(source, fos);
                } else {
                    tc.write(new FileInputStream(source), fos);
                }
                if (tmp != null) {
                    tmp.renameTo(result);
                }
                if (!verbose) return;
                System.out.println(result);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Can't write to " + result.getAbsolutePath());
                System.exit(1);
            }
        }
    }

    private static File[] recursiveFileList(File in) {
        if (!in.isDirectory()) {
            return new File[]{in};
        }
        File[] files = in.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return !f.isDirectory() && !f.isHidden();
            }
        });
        for (File f : in.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isHidden() && file.isDirectory();
            }
        })) {
            File[] list = TransCoder.recursiveFileList(f);
            File[] tmpFiles = new File[files.length + list.length];
            System.arraycopy(files, 0, tmpFiles, 0, files.length);
            System.arraycopy(list, 0, tmpFiles, files.length, list.length);
            files = tmpFiles;
        }
        return files;
    }
}

