/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.AbstractGreekParser;
import java.util.Properties;
import java.util.TreeMap;

public class SGreekParser
extends AbstractGreekParser {
    private Properties bcp;
    private Properties ga;
    private StringBuffer strb = new StringBuffer();
    private TreeMap<String, String> map = new TreeMap();

    public SGreekParser() {
        this.encoding = "ISO8859_1";
        this.bcp = new Properties();
        this.ga = new Properties();
        try {
            Class<?> c = this.getClass();
            this.bcp.load(c.getResourceAsStream("SGreekParser.properties"));
            this.ga.load(c.getResourceAsStream("GreekAccents.properties"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public String next() {
        this.strb.delete(0, this.strb.length());
        if (this.in != null) {
            char ch = this.chArray[this.index];
            ++this.index;
            this.map.clear();
            this.strb.append(this.lookup(ch));
            while (this.hasNext() && this.isSGreekDiacritical(this.chArray[this.index])) {
                this.map.put(this.lookupAccent(this.chArray[this.index]), this.lookup(this.chArray[this.index]));
                ++this.index;
            }
            while (this.map.size() > 0) {
                String str = this.map.remove(this.map.firstKey());
                this.strb.append("_" + str);
            }
        }
        return this.strb.toString();
    }

    private String lookup(char ch) {
        String key = String.valueOf(ch);
        return this.bcp.getProperty(key, key);
    }

    private String lookupAccent(char ch) {
        return this.ga.getProperty(this.lookup(ch));
    }

    private boolean isSGreekDiacritical(char ch) {
        switch (ch) {
            case '(': 
            case ')': 
            case '/': 
            case '=': 
            case '\\': {
                return true;
            }
        }
        return false;
    }
}

