/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.AbstractGreekConverter;
import edu.unc.epidoc.transcoder.Parser;
import java.util.Properties;

public class GreekXLitConverter
extends AbstractGreekConverter {
    private Properties sgp;

    public GreekXLitConverter() {
        this.encoding = "US-ASCII";
        this.unrecognizedChar = "";
        this.sgp = new Properties();
        try {
            Class<?> c = this.getClass();
            this.sgp.load(c.getResourceAsStream("GreekXLitConverter.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String convertToCharacterEntities(Parser in) {
        StringBuffer result = new StringBuffer();
        char[] chars = this.convertToString(in).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch > '\u007f') {
                result.append("&#x" + Integer.toHexString(ch) + ";");
                continue;
            }
            result.append(chars[i]);
        }
        return result.toString();
    }

    public String convertToString(Parser in) {
        StringBuffer result = new StringBuffer();
        String last = "";
        while (in.hasNext()) {
            String convert = in.next();
            if (convert.indexOf(95) > 0 && convert.length() > 1) {
                String[] elements = this.split(convert);
                if (elements[1].equals("asper")) {
                    if (this.isDiphthong(last, elements[0]) && convert.indexOf("diaer") < 0) {
                        if (Character.isUpperCase(elements[0].charAt(0))) {
                            result.insert(result.length() - 1, "H");
                            result.append(this.sgp.getProperty(elements[0], "").toLowerCase());
                        } else {
                            result.insert(result.length() - 1, "h");
                            result.append(this.sgp.getProperty(elements[0], ""));
                        }
                    } else if ("rho".equals(elements[0].toLowerCase())) {
                        result.append(this.sgp.getProperty(elements[0], ""));
                        result.append("h");
                    } else if (Character.isUpperCase(elements[0].charAt(0))) {
                        result.append("H");
                        result.append(this.sgp.getProperty(elements[0], "").toLowerCase());
                    } else {
                        result.append("h");
                        result.append(this.sgp.getProperty(elements[0], ""));
                    }
                } else {
                    result.append(this.sgp.getProperty(elements[0], ""));
                }
            } else if (convert.length() > 1) {
                result.append(this.sgp.getProperty(convert, ""));
            } else {
                result.append(this.sgp.getProperty(convert, convert));
            }
            last = convert;
        }
        return result.toString();
    }

    private boolean isDiphthong(String first, String second) {
        if ("iota".equalsIgnoreCase(second)) {
            if ("alpha".equalsIgnoreCase(first)) {
                return true;
            }
            if ("epsilon".equalsIgnoreCase(first)) {
                return true;
            }
            if ("omicron".equalsIgnoreCase(first)) {
                return true;
            }
            if ("upsilon".equalsIgnoreCase(first)) {
                return true;
            }
        }
        if ("upsilon".equalsIgnoreCase(second)) {
            if ("alpha".equalsIgnoreCase(first)) {
                return true;
            }
            if ("epsilon".equalsIgnoreCase(first)) {
                return true;
            }
            if ("omicron".equalsIgnoreCase(first)) {
                return true;
            }
            if ("eta".equalsIgnoreCase(first)) {
                return true;
            }
        }
        return false;
    }
}

