/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.Parser;
import java.io.UnsupportedEncodingException;

public abstract class AbstractParser
implements Parser {
    protected String encoding = "UTF8";
    protected String[] languages;
    protected char[] chArray;
    protected int index;
    protected int length;
    protected String in;

    public String getEncoding() {
        return new String(this.encoding);
    }

    public Object getProperty(String name) {
        if ("supported-languages".equals(name)) {
            return this.languages;
        }
        return null;
    }

    public boolean hasNext() {
        return this.index < this.length;
    }

    public abstract String next();

    public void setProperty(String name, Object value) {
        if ("supported-languages".equals(name) && value instanceof String[]) {
            this.languages = (String[])value;
        }
    }

    public void setString(String in) throws UnsupportedEncodingException {
        this.in = new String(in.getBytes(), this.encoding);
        this.chArray = in.toCharArray();
        this.index = 0;
        this.length = this.chArray.length;
    }

    public void setStringBuffer(StringBuffer in, int start, int len) {
        this.in = in.toString();
        this.chArray = this.in.toCharArray();
        this.index = start;
        this.length = len + start;
    }

    public boolean supportsLanguage(String lang) {
        for (int i = 0; i < this.languages.length; ++i) {
            if (!this.languages[i].equalsIgnoreCase(lang)) continue;
            return true;
        }
        return false;
    }
}

