/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.proc.parsers;

import fr.cnrs.liris.drim.grt.modele.Passage;

/**
 *
 * @author sgesche
 */
public class PassageType {
    public final static int PASSAGE_BIBLIQUE = 0;
    public final static int PASSAGE_PATRISTIQUE = 1;
    public final static int PASSAGE_PHILON = 2;
    
    private final Passage passage;
    private final int type;

    public PassageType(Passage passage, int type) {
        this.passage = passage;
        this.type = type;
    }

    public Passage getPassage() {
        return passage;
    }

    public int getType() {
        return type;
    }
}
