/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.proc.exceptions;

/**
 * This exception is thrown when an attempt to parse a XML document into a
 * Document fails.
 *
 * @author Samuel Gesche
 *
 */
public class DOMCreationFailureException
    extends Exception{

  /**
   * Creates an exception with no message an no cause.
   * @since Towntology 1.0
   */
  public DOMCreationFailureException(){
  }

  /**
   * Creates an exception with a detailed message.
   * @param message the message of the exception.
   * @since Towntology 1.0
   */
  public DOMCreationFailureException(String message){
    super(message);
  }

  /**
   * Creates an exception with a detailed message and a cause.
   * @param message the message of the exception.
   * @param cause the cause of the exception.
   */
  public DOMCreationFailureException(String message, Throwable cause){
    super(message, cause);
  }

  /**
   * Creates an exception with a cause.
   * @param cause the cause of the exception.
   */
  public DOMCreationFailureException(Throwable cause){
    super(cause);
  }
}

