/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.proc.base;

/**
 *
 * @author Sam
 */
public class Bases {
    private static String url = "";
    private static String nomBaseLexis = "";
    private static String nomBaseBiblindex = "";
    private static String loginLexis = "";
    private static String motDePasseLexis = "";
    private static String loginBiblindex = "";
    private static String motDePasseBiblindex = "";
    private static boolean basesPresentes = false;
    private static BaseDeDonnees baseLexis = null;
    private static BaseDeDonnees baseBiblindex = null;
    
    public static void setSansBase() {
        url = "";
        nomBaseLexis = "";
        nomBaseBiblindex = "";
        loginLexis = "";
        motDePasseLexis = "";
        loginBiblindex = "";
        motDePasseBiblindex = "";
        basesPresentes = false;
        baseLexis = null;
        baseBiblindex = null;
    }
    
    public static void setInfosLexis(String urlBase, String nom, String login, String motDePasse) {
        url = urlBase;
        nomBaseLexis = nom;
        loginLexis = login;
        motDePasseLexis = motDePasse;
        basesPresentes = true;
        baseLexis = null;
    }
    
    public static void setInfosBiblindex(String urlBase, String nom, String login, String motDePasse) {
        url = urlBase;
        nomBaseBiblindex = nom;
        loginBiblindex = login;
        motDePasseBiblindex = motDePasse;
        basesPresentes = true;
        baseBiblindex = null;
    }
    
    public static boolean utiliseBases() {
        return basesPresentes;
    }
    
    public static BaseDeDonnees getBaseLexis() {
        if(basesPresentes && baseLexis == null) {
            baseLexis = new BaseDeDonnees(url, nomBaseLexis, loginLexis, motDePasseLexis);
        }
        return baseLexis;
    }
    
    public static BaseDeDonnees getBaseBiblindex() {
        if(basesPresentes && baseBiblindex == null) {
            baseBiblindex = new BaseDeDonnees(url, nomBaseBiblindex, loginBiblindex, motDePasseBiblindex);
        }
        return baseBiblindex;
    }
}
