/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.proc;

import fr.cnrs.liris.drim.grt.modele.Reference;

/**
 * Ces objets encapsulent des doublets de références (citeur/cité). Les 
 * références en question ne deviendront une vraie citation qu'une fois 
 * projetées sur des documents (@see Citation).
 * 
 * @author sgesche
 */
public class ReferencesDeCitation {
    private Reference cite;
    private Reference citeur;
    
    public ReferencesDeCitation(Reference citeur, Reference cite) {
        this.citeur = citeur;
        this.cite = cite;
    }

    public Reference getCite() {
        return cite;
    }

    public Reference getCiteur() {
        return citeur;
    }
    
    @Override
    public String toString() {
        return citeur+" cite "+cite;
    }
}
