/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.listes;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Set;
import fr.cnrs.liris.drim.grt.modele.Terme;
import fr.cnrs.liris.drim.grt.ihm.GestionnaireErreurs;

/**
 *
 * @author Sam
 */
public class NomsPropres implements Liste {
    private final static NomsPropres instance = new NomsPropres();

    private Set<Terme> liste;
    
    private NomsPropres() {
        liste = new HashSet<>();
        getListe();
    }
    
    public static NomsPropres getInstance() {
        return instance;
    }
    
    public Terme[] getListe() {
        if(liste.isEmpty()) {
            // chargement du fichier
            File fichier = new File("nomsPropres.txt");
            if(fichier.exists()) {
                try {
                    BufferedReader lecteur = new BufferedReader(new InputStreamReader(new FileInputStream(fichier), "UTF-8"));
                    while(lecteur.ready()) {
                        String ligne = lecteur.readLine().trim();
                        addNomPropre(Terme.cree(ligne));
                    }
                } catch (IOException ex) {
                    GestionnaireErreurs.getInstance().affiche("Erreur d'application", 
                            "<html><p>Le fichier nomsPropres.txt est présent mais illisible.</p>"
                            + "<ul><li>Choix 1 : veuillez corriger la situation si vous savez comment ;</li>"
                            + "<li>Choix 2 : veuillez le supprimer, et recréer la liste des noms propres.</li></ul>"
                            + "<p>Pour information, l'erreur est</p>"
                            + "<p>"+ex.getClass()+" : "+ex.getMessage()+"</p></html>");
                }
            } else {
                // pas de fichier ? Pas grave, on en crée un vide
                try {
                    fichier.createNewFile();
                } catch (IOException ex) {
                    GestionnaireErreurs.getInstance().affiche("Erreur d'application", 
                            "<html><p>Nous n'avons pas trouvé le fichier nomsPropres.txt qui contient la liste des noms propres.</p>"
                            + "<p>Nous avons essayé de le créer, sans succès.</p>"
                            + "<p>Nous vous recommandons de nous permettre d'écrire un tel fichier avant de continuer.</p>"
                            + "<p>Pour information, l'erreur est</p>"
                            + "<p>"+ex.getClass()+" : "+ex.getMessage()+"</p></html>");
                }
            }
        }
        Terme[] resultat = new Terme[liste.size()];
        liste.toArray(resultat);
        return resultat;
    }
    
    public void addNomPropre(Terme nomPropre) {
        liste.add(nomPropre);
    }
    
    public boolean contient(Terme mot) {
        return liste.contains(mot);
    }
    
    public boolean contientNomComplet(Terme abreviation) {
        // Une abréviation finit par un point
        if(!abreviation.getExpression().endsWith(".")) {
            return contient(abreviation);
        }
        // Récupération des trois premiers caractères
        String abv;
        try {
            abv = abreviation.getExpression().substring(0, 2);
        } catch(IndexOutOfBoundsException ex) {
            abv = abreviation.getExpression().replaceAll("\\.", "");
        }
        for(Terme t: liste) {
            if(t.getExpression().startsWith(abv)) {
                return true;
            }
        }
        return false;
    }
    
    @Override
    public void archive() {
        sauvegarde();
    }
    
    private void sauvegarde() {
        File fichier = new File("nomsPropres.txt");
        if(!(fichier.exists())) {
            // pas de fichier ? Pas grave, on en crée un vide
            try {
                fichier.createNewFile();
            } catch (IOException ex) {
                GestionnaireErreurs.getInstance().affiche("Erreur d'application", 
                            "<html><p>Nous n'avons pas trouvé le fichier nomsPropres.txt qui contient la liste des noms propres.</p>"
                            + "<p>Nous avons essayé de le créer, sans succès.</p>"
                            + "<p>Nous vous recommandons de nous permettre d'écrire un tel fichier avant de continuer.</p>"
                            + "<p>Pour information, l'erreur est</p>"
                            + "<p>"+ex.getClass()+" : "+ex.getMessage()+"</p></html>");
            }
        }
        try {
            BufferedWriter lecteur = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fichier), "UTF-8"));
            for(Terme terme: liste) {
                lecteur.write(terme.getExpression() + "\r\n");
            }
            lecteur.flush();
        } catch (IOException ex) {
            GestionnaireErreurs.getInstance().affiche("Erreur d'application", 
                            "<html><p>Le fichier nomsPropres.txt est présent mais nous en pouvons pas l'alimenter.</p>"
                            + "<p>Veuillez corriger la situation si vous savez comment.</p>"
                            + "<p>Pour information, l'erreur est</p>"
                            + "<p>"+ex.getClass()+" : "+ex.getMessage()+"</p></html>");
        }
    }
}
