/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.listes;

import java.util.Arrays;
import java.util.HashSet;
import fr.cnrs.liris.drim.grt.modele.Passage;
import fr.cnrs.liris.drim.grt.proc.Texte;
/**
 *
 * @author Sam
 */
public class ExpressionsUsuelles {
    private final static String[] liste = new String[]{
        "ὡς ἄγγελος τοῦ θεοῦ καὶ",
        "εἰς τὴν βασιλείαν τῶν οὐρανῶν",
        "εἰς τοὺς αἰῶνας τῶν αἰώνων",
        "ὁ υἱὸς τοῦ θεοῦ",
        "καὶ ἐν τῷ τέλει",
        "εἰσελθεῖν εἰς τὴν βασιλείαν",
        "τὴν βασιλείαν τῶν οὐρανῶν",
        "τὴν ἐντολὴν τοῦ θεοῦ",
        "τῆς βασιλείας τῶν οὐρανῶν",
        "τὸ θέλημα τοῦ πατρός",
        "υἱὸς τοῦ θεοῦ",
        "χρυσὸν καὶ ἄργυρον",
        "εἰς τὴν βασιλείαν",
        "τὴν βασιλείαν τῶν",
        "κατὰ τὴν ἐντολὴν",
        "τὴν ἐντολὴν τοῦ",
        "καὶ οἱ μαθηταὶ",
        "τῆς βασιλείας τῶν",
        "καὶ τὰ ἔργα",
        "τὸ θέλημα τοῦ",
        "καὶ πάσαις ταῖς ἐντολαῖς τοῦ",
        "εἰσελθεῖν εἰς τὴν βασιλείαν τῶν",
        "εἰσελθεῖν εἰς τὴν βασιλείαν τῶν οὐρανῶν",
        "τό ἀγαπήσεις τὸν πλησίον σου ὡς σεαυτόν"
    };
    private final static HashSet<String> ensemble = new HashSet(Arrays.asList(liste));
    
    public static String[] getListe() {
        return liste;
    }
    
    public static HashSet<String> getEnsemble() {
        return ensemble;
    }
    
    public static boolean contientTexte(Passage texte) {
        return ensemble.contains(new Texte(texte).getTexte().trim());
    }
}
