/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.listes;

import java.util.Arrays;
import java.util.HashSet;
import fr.cnrs.liris.drim.grt.modele.Passage;
import fr.cnrs.liris.drim.grt.proc.Texte;
/**
 *
 * @author Sam
 */
public class ExpressionsRecurrentes {
    private final static String[] liste = new String[]{
        "δὲ καὶ ἡ",
        "καὶ ἡ εὐχὴ",
        "ἡμέρας τοῦ βίου",
        "ταῖς ἐντολαῖς τοῦ",
        "γὰρ ἦν ἡ",
        "τὰ τοῦ νόμου",
        "τῆς ἐλπίδος τῆς",
        "τὰ δόγματα τὰ",
        "τῆς ψυχῆς τὴν",
        "κατὰ τὰς ὁδοὺς",
        "ὁ υἱὸς τοῦ",
        "αὐτὴν καὶ τὴν",
        "γὰρ ἐγένοντο καὶ",
        "τίς γὰρ ἂν",
        "καὶ τὰ μὲν",
        "καὶ μετὰ τῆς",
        "ὑπὸ τοῦ θεοῦ",
        "ἐν ἑαυτῷ καὶ",
        "τοῦτον τὸν τρόπον",
        "καὶ τὰ κτήματαv",
        "τῶν παθῶν καὶ",
        "καὶ τὸν λογισμὸν",
        "τῆς κακίας τὴν",
        "καὶ τὴν τῶν",
        "δὲ ἦν τὰ",
        "ὁ μὲν γὰρ",
        "γὰρ ἔχων κτήματα",
        "ἀπ' αὐτῶν εἰς",
        "καὶ εἰδὼς ὅτι",
        "τῆς κτήσεως αὐτῶν",
        "ἐν τῇ ψυχῇ",
        "τι καὶ καλὸν",
        "ὁ δὲ ἐν",
        "ἐν τῇ καρδίᾳ",
        "δὲ ἐν τῇ",
        "ἐν τῇ ψυχῇ τὸν πλοῦτον ϕέρων καὶ ἀντὶ θεοῦ πνεύματος ἐν τῇ καρδίᾳ",
        "καὶ τὴν κτῆσιν",
        "καὶ τοῖς τοῦ",
        "τὸν πλοῦτον καὶ",
        "πλοῦτον καὶ τὸν",
        "καὶ ὁ μέν",
        "οὐ γὰρ οὕτως",
        "οὐδὲ ἐπὶ τοῖς",
        "ἀλλ' ὁ μὲν",
        "δέ τις καὶ",
        "ἡ ψυχὴ καὶ",
        "πλὴν ἐν τῇ",
        "καὶ τὴν ζωὴν",
        "καὶ ἐν τῷ",
        "τὸν αὐτὸν τρόπον",
        "τῇ ψυχῇ σου",
        "εἰσελθεῖν εἰς τὴν",
        "σὺ δὲ τὸν",
        "οἱ μὲν γὰρ",
        "τῆς τοῦ κυρίου",
        "ὁ αὐτὸς καὶ",
        "τῷ κόσμῳ καὶ",
        "γὰρ ἦν μὴ",
        "καὶ ὡς ἂν",
        "ὑπὸ τοῦ κυρίου",
        "τοῦ κυρίου καὶ",
        "γὰρ ἦσαν καὶ",
        "εἰ καὶ ὁ",
        "καὶ ὁ τῶν",
        "ἐὰν δὲ γένηται",
        "μὲν γὰρ ταῖς",
        "γὰρ ὁ θεὸς",
        "ὁ θεὸς τὰ",
        "τὴν ψυχὴν καὶ",
        "ὁ θεὸς τοῖς",
        "σοῦ πρὸς τὸν",
        "καὶ τὸν σὸν",
        "ὑπ' αὐτῶν καὶ",
        "καὶ τὰ ἄλλα",
        "ἐν δὲ τῷ",
        "τοῦ θεοῦ τοῦ",
        "εἰ γὰρ διὰ",
        "καὶ γὰρ καὶ",
        "τῶν λογίων τοῦ",
        "κυρίου διότι οὐκ",
        "τῆς τοῦ θεοῦ",
        "δὲ αὐτῷ καὶ",
        "καὶ οὐκ εἰς",
        "παρὰ τῷ πατρί",
        "μὲν οὖν καὶ",
        "δὲ ὁ λόγος",
        "ὅτι διὰ τὴν",
        "γὰρ οὐ μόνον",
        "τίς οὗτός ἐστιν",
        "οὗτός ἐστιν ὁ",
        "ἀλλὰ καὶ τοῖς",
        "ἐκ δὲ τοῦ",
        "τοῖς τοῦ θεοῦ",
        "ὁ πατὴρ καὶ",
        "θεοῦ πατρὸς καὶ",
        "καὶ τῇ ψυχῇ",
        "δι' οὓς καὶ",
        "οὓς ὁ λόγος",
        "δι' ὃ καὶ",
        "καὶ τὸ μὲν",
        "τὸ δὲ εἰς",
        "διὰ τοῦτο καὶ",
        "τοῦτο καὶ αὐτὸς",
        "τίς δέ ἐστιν",
        "τὴν ψυχὴν τὴν",
        "τὰ τοῦ κόσμου",
        "εἰ καὶ τὸν",
        "ὅπου γε καὶ",
        "καὶ τὰ σωτήρια",
        "πρὸς τὴν τῆς",
        "ἡμᾶς ἐν τοῖς",
        "καὶ παρ' ἕκαστα",
        "κατὰ τὸν βίον",
        "τὸν ἀεὶ χρόνον",
        "γὰρ ἀπὸ τῆς",
        "πρὸς θεὸν καὶ",
        "τὸν πατέρα οὐ",
        "τοῖς τέκνοις αὐτοῦ",
        "ἄγγελος τοῦ θεοῦ καὶ",
        "ἄγγελος τοῦ θεοῦ",
        "τοῦ θεοῦ καὶ",
        "ἀπὸ τῆς ἐκκλησίας",
        "ἐλθὼν δὲ εἰς",
        "δὲ εἰς τὸ",
        "ἐπὶ τὸν ἄρχοντα",
        "αὐτῷ παρὰ τοῦ",
        "ἐπὶ τὴν ἐκκλησίαν",
        "τὸν ἄγγελον τῆς",
        "εἰ δέ τις",
        "τῆς αἰωνίου ζωῆς",
        "καὶ ἐπὶ τὰ",
        "τῶν ἐθνῶν ὅπου",
        "καὶ εἰς τοὺς",
        "εἰς τοὺς αἰῶνας",
        "καὶ νῦν καὶ",
        "νῦν καὶ εἰς",
        "εἰς γενεὰς γενεῶν",
        "γενεὰς γενεῶν καὶ",
        "τῶν ὑπὸ τοῦ",
        "καὶ ἐπί τινα",
        "καὶ τὴν ὄψιν",
        "τῆς ἐκκλησίας καὶ",
        "καὶ τοῦ Χριστοῦ",
        "καὶ μετὰ τοῦτο",
        "καὶ πρῶτον μὲν",
        "καὶ ὁ Χριστός",
        "ἐγώ τε καὶ ὁ",
        "τὴν ψυχὴν τοῦ",
        "καὶ τὴν ψυχὴν",
        "τὴν αὐτὴν τῆς",
        "πρὸς τοὺς μαθητὰς",
        "καὶ γὰρ τὰ",
        "αὐτοῦ τοῦ κυρίου",
        "ἔτι καὶ νῦν ἀλλὰ πλείονος ἔτι καὶ νῦν",
        "καὶ νῦν ἀλλὰ",
        "δὲ καὶ τὰ",
        "καὶ διὰ τοῦτο",
        "δὲ τὸ τέλος",
        "ἐπ' αὐτὸ τὸ",
        "αὐτὸ τὸ πνεῦμα",
        "τὸ πνεῦμα τοῦ",
        "καὶ τὸ τῆς",
        "ὁ λόγος περὶ",
        "ἀπὸ τῆς ἀρχῆς",
        "καὶ τὰ ὄντα",
        "ἐξ οὗ καὶ",
        "ἐστιν ἡ δὲ",
        "ἡ μὲν γὰρ",
        "ἐκεῖνον καὶ τὴν",
        "καὶ ἡ ἀλήθεια",
        "εἴ τις ἐν",
        "αἰτεῖ παρὰ τοῦ",
        "καὶ πρὸς μὲν",
        "τὸ τὴν ψυχὴν αὐτὴν καὶ τὴν",
        "τὰ αὐτὰ διδόναι τε καὶ",
        "ἔχων ἐν ἑαυτῷ καὶ τὸ",
        "ὁ κύριος καὶ τὴν τῶν",
        "τῶν πλουσίων τῶν καὶ τῆς",
        "τῶν καὶ τῆς δυνάμεως τοῦ",
        "καὶ χρῆσθαι τῷ κόσμῳ καὶ",
        "ἐν τούτῳ δὲ τὴν πρὸς",
        "ἐστὶ τούτου ὁ τοῦ κυρίου",
        "καὶ τίς οὗτός ἐστιν ὁ",
        "τῷ σῷ πλούτῳ καὶ τῷ",
        "καὶ τῷ σώματι καὶ τῇ",
        "καὶ τῷ σώματι καὶ τῇ ψυχῇ",
        "τῷ σώματι καὶ τῇ ψυχῇ",
        "σοῦ πρὸς τὸν κύριον τῶν",
        "τοῦ πατρός δι' ὃ καὶ τὰ",
        "ἡμῶν ὑπὲρ σοῦ τὴν ψυχὴν",
        "καὶ εἰς τοὺς αἰῶνας τῶν",
        "καὶ εἰς τοὺς αἰῶνας τῶν αἰώνων",
        "εἰς τοὺς αἰῶνας τῶν αἰώνων",
        "καὶ εἰς γενεὰς γενεῶν καὶ εἰς",
        "γενεὰς γενεῶν καὶ εἰς τοὺς",
        "γενεὰς γενεῶν καὶ εἰς τοὺς αἰῶνας τῶν",
        "τῆς ἐκκλησίας καὶ τοῦ Χριστοῦ",
        "γὰρ τὰ ὑπ' αὐτοῦ τοῦ",
        "ἐπ' αὐτὸ τὸ πνεῦμα τοῦ",
        "ὁ κύριος ἡμῶν καὶ σωτὴρ",
        "οὗ καὶ τὸ εἶναι τοῖς",
        "καὶ νῦν καὶ εἰς"
    };
    private final static HashSet<String> ensemble = new HashSet(Arrays.asList(liste));
    
    public static String[] getListe() {
        return liste;
    }
    
    public static HashSet<String> getEnsemble() {
        return ensemble;
    }
    
    public static boolean contientTexte(Passage texte) {
        return ensemble.contains(new Texte(texte).getTexte().trim());
    }
}
