/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.convertisseurs;

import org.apache.commons.lang.StringUtils;

/**
 *
 * @author sgesche
 */
public class ConvertisseurUnicodeVersFormeNormale {
    public static String conversion(String s) {
        String s0 = ConvertisseurUnicodeVersSansAccentNiEsprit.conversion(s);
        
        s0 = StringUtils.replace(s0, ""+(char)913, ""+(char)945); //Α
        s0 = StringUtils.replace(s0, ""+(char)914, ""+(char)946); //Β
        s0 = StringUtils.replace(s0, ""+(char)915, ""+(char)947); //Γ
        s0 = StringUtils.replace(s0, ""+(char)916, ""+(char)948); //Δ
        s0 = StringUtils.replace(s0, ""+(char)917, ""+(char)949); //Ε
        s0 = StringUtils.replace(s0, ""+(char)918, ""+(char)950); //Ζ
        s0 = StringUtils.replace(s0, ""+(char)919, ""+(char)951); //Η
        s0 = StringUtils.replace(s0, ""+(char)920, ""+(char)952); //Θ
        s0 = StringUtils.replace(s0, ""+(char)921, ""+(char)953); //Ι
        s0 = StringUtils.replace(s0, ""+(char)922, ""+(char)954); //Κ
        s0 = StringUtils.replace(s0, ""+(char)923, ""+(char)955); //Λ
        s0 = StringUtils.replace(s0, ""+(char)924, ""+(char)956); //Μ
        s0 = StringUtils.replace(s0, ""+(char)925, ""+(char)957); //Ν
        s0 = StringUtils.replace(s0, ""+(char)926, ""+(char)958); //Ξ
        s0 = StringUtils.replace(s0, ""+(char)927, ""+(char)959); //Ο
        s0 = StringUtils.replace(s0, ""+(char)928, ""+(char)960); //Π
        s0 = StringUtils.replace(s0, ""+(char)929, ""+(char)961); //Ρ
        s0 = StringUtils.replace(s0, ""+(char)930, ""+(char)962); //Σ
        s0 = StringUtils.replace(s0, ""+(char)931, ""+(char)963); //Σ
        s0 = StringUtils.replace(s0, ""+(char)932, ""+(char)964); //Τ
        s0 = StringUtils.replace(s0, ""+(char)933, ""+(char)965); //Υ
        s0 = StringUtils.replace(s0, ""+(char)934, ""+(char)966); //Φ
        s0 = StringUtils.replace(s0, ""+(char)935, ""+(char)967); //Χ
        s0 = StringUtils.replace(s0, ""+(char)936, ""+(char)968); //Ψ
        s0 = StringUtils.replace(s0, ""+(char)937, ""+(char)969); //Ω
        
        return s0;
    }
}
