/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.convertisseurs;

import org.apache.commons.lang.StringUtils;

/**
 *
 * @author sgesche
 */
public class ConvertisseurUnicodeVersBibleWorks {
    
    public static String conversion(String s) {
        String s0 = s;
        
        // Tri des motifs par taille, pour éviter de remplacer des motifs 
        // courts qui sont en fait longs
        
        // Ponctuation
        s0 = StringUtils.replace(s0, ";\"", "ȹ");
        s0 = StringUtils.replace(s0, "+", "!");
        s0 = StringUtils.replace(s0, "[", "@");
        s0 = StringUtils.replace(s0, "]", "#");
        s0 = StringUtils.replace(s0, "(", "$");
        s0 = StringUtils.replace(s0, ")", "%");
        s0 = StringUtils.replace(s0, ";", "*");
        s0 = StringUtils.replace(s0, "*", "^");
        s0 = StringUtils.replace(s0, ",", "(");
        s0 = StringUtils.replace(s0, ".", ")");
        s0 = StringUtils.replace(s0, "·", "\\");
        s0 = StringUtils.replace(s0, "\"", "Ź");
        
        // Majuscules
        s0 = StringUtils.replace(s0, ""+(char)7944, "VA"); //Ἀ
        s0 = StringUtils.replace(s0, ""+(char)7945, "~A"); //Ἁ
        s0 = StringUtils.replace(s0, ""+(char)7946, "\"A"); //Ἂ
        s0 = StringUtils.replace(s0, ""+(char)7947, "}A"); //Ἃ
        s0 = StringUtils.replace(s0, ""+(char)7948, ":A"); //Ἄ
        s0 = StringUtils.replace(s0, ""+(char)7949, "{A"); //Ἅ
        s0 = StringUtils.replace(s0, ""+(char)7950, "+A"); //Ἆ
        s0 = StringUtils.replace(s0, ""+(char)7951, "_A"); //Ἇ
        s0 = StringUtils.replace(s0, ""+(char)913, "A"); //Α
        s0 = StringUtils.replace(s0, ""+(char)7960, "VE"); //Ἐ
        s0 = StringUtils.replace(s0, ""+(char)7961, "~E"); //Ἑ
        s0 = StringUtils.replace(s0, ""+(char)7962, "\"E"); //Ἒ
        s0 = StringUtils.replace(s0, ""+(char)7963, "}E"); //Ἓ
        s0 = StringUtils.replace(s0, ""+(char)7964, ":E"); //Ἔ
        s0 = StringUtils.replace(s0, ""+(char)7965, "{E"); //Ἕ
        s0 = StringUtils.replace(s0, ""+(char)917, "E"); //Ε
        s0 = StringUtils.replace(s0, ""+(char)7976, "VH"); //Ἠ
        s0 = StringUtils.replace(s0, ""+(char)7977, "~H"); //Ἡ
        s0 = StringUtils.replace(s0, ""+(char)7978, "\"H"); //Ἢ
        s0 = StringUtils.replace(s0, ""+(char)7979, "}H"); //Ἣ
        s0 = StringUtils.replace(s0, ""+(char)7980, ":H"); //Ἤ
        s0 = StringUtils.replace(s0, ""+(char)7981, "{H"); //Ἥ
        s0 = StringUtils.replace(s0, ""+(char)7982, "+H"); //Ἦ
        s0 = StringUtils.replace(s0, ""+(char)7983, "_H"); //Ἧ
        s0 = StringUtils.replace(s0, ""+(char)919, "H"); //Η
        s0 = StringUtils.replace(s0, ""+(char)7992, "VI"); //Ἰ
        s0 = StringUtils.replace(s0, ""+(char)7993, "~I"); //Ἱ
        s0 = StringUtils.replace(s0, ""+(char)7994, "\"I"); //Ἲ
        s0 = StringUtils.replace(s0, ""+(char)7995, "}I"); //Ἳ
        s0 = StringUtils.replace(s0, ""+(char)7996, ":I"); //Ἴ
        s0 = StringUtils.replace(s0, ""+(char)7997, "{I"); //Ἵ
        s0 = StringUtils.replace(s0, ""+(char)7998, "+I"); //Ἶ
        s0 = StringUtils.replace(s0, ""+(char)7999, "_I"); //Ἷ
        s0 = StringUtils.replace(s0, ""+(char)921, "I"); //Ι
        s0 = StringUtils.replace(s0, ""+(char)8008, "VO"); //Ὀ
        s0 = StringUtils.replace(s0, ""+(char)8009, "~O"); //Ὁ
        s0 = StringUtils.replace(s0, ""+(char)8010, "\"O"); //Ὂ
        s0 = StringUtils.replace(s0, ""+(char)8011, "}O"); //Ὃ
        s0 = StringUtils.replace(s0, ""+(char)8012, ":O"); //Ὄ
        s0 = StringUtils.replace(s0, ""+(char)8013, "{O"); //Ὅ
        s0 = StringUtils.replace(s0, ""+(char)927, "O"); //Ο
        s0 = StringUtils.replace(s0, ""+(char)8025, "~U"); //Ὑ
        s0 = StringUtils.replace(s0, ""+(char)8027, "}U"); //Ὓ
        s0 = StringUtils.replace(s0, ""+(char)8029, "{U"); //Ὕ
        s0 = StringUtils.replace(s0, ""+(char)8031, "_U"); //Ὗ
        s0 = StringUtils.replace(s0, ""+(char)933, "U"); //Υ
        s0 = StringUtils.replace(s0, ""+(char)8040, "VW"); //Ὠ
        s0 = StringUtils.replace(s0, ""+(char)8041, "~W"); //Ὡ
        s0 = StringUtils.replace(s0, ""+(char)8042, "\"W"); //Ὢ
        s0 = StringUtils.replace(s0, ""+(char)8043, "}W"); //Ὣ
        s0 = StringUtils.replace(s0, ""+(char)8044, ":W"); //Ὤ
        s0 = StringUtils.replace(s0, ""+(char)8045, "{W"); //Ὥ
        s0 = StringUtils.replace(s0, ""+(char)8046, "+W"); //Ὦ
        s0 = StringUtils.replace(s0, ""+(char)8047, "_W"); //Ὧ
        s0 = StringUtils.replace(s0, ""+(char)937, "W"); //Ω
        s0 = StringUtils.replace(s0, ""+(char)8172, "~R"); //Ῥ // pas le bon, mais pas d'ambiguité
        s0 = StringUtils.replace(s0, ""+(char)929, "R"); //Ρ
        
        s0 = StringUtils.replace(s0, ""+(char)914, "B"); //Β
        s0 = StringUtils.replace(s0, ""+(char)915, "G"); //Γ
        s0 = StringUtils.replace(s0, ""+(char)916, "D"); //Δ
        s0 = StringUtils.replace(s0, ""+(char)918, "Z"); //Ζ
        s0 = StringUtils.replace(s0, ""+(char)920, "Q"); //Θ
        s0 = StringUtils.replace(s0, ""+(char)922, "K"); //Κ
        s0 = StringUtils.replace(s0, ""+(char)923, "L"); //Λ
        s0 = StringUtils.replace(s0, ""+(char)924, "M"); //Μ
        s0 = StringUtils.replace(s0, ""+(char)925, "N"); //Ν
        s0 = StringUtils.replace(s0, ""+(char)926, "X"); //Ξ
        s0 = StringUtils.replace(s0, ""+(char)928, "P"); //Π
        s0 = StringUtils.replace(s0, ""+(char)931, "S"); //Σ
        s0 = StringUtils.replace(s0, ""+(char)932, "T"); //Τ
        s0 = StringUtils.replace(s0, ""+(char)934, "F"); //Φ
        s0 = StringUtils.replace(s0, ""+(char)935, "C"); //Χ
        s0 = StringUtils.replace(s0, ""+(char)936, "Y"); //Ψ
        
        // Minuscules
        s0 = StringUtils.replace(s0, ""+(char)8064, "av|"); //ᾀ
        s0 = StringUtils.replace(s0, ""+(char)7936, "av"); //ἀ
        s0 = StringUtils.replace(s0, ""+(char)8065, "a`|"); //ᾁ
        s0 = StringUtils.replace(s0, ""+(char)7937, "a`"); //ἁ
        s0 = StringUtils.replace(s0, ""+(char)8066, "a'|"); //ᾂ
        s0 = StringUtils.replace(s0, ""+(char)7938, "a'"); //ἂ
        s0 = StringUtils.replace(s0, ""+(char)8067, "a]|"); //ᾃ
        s0 = StringUtils.replace(s0, ""+(char)7939, "a]"); //ἃ
        s0 = StringUtils.replace(s0, ""+(char)8068, "a;|"); //ᾄ
        s0 = StringUtils.replace(s0, ""+(char)7940, "a;"); //ἄ
        s0 = StringUtils.replace(s0, ""+(char)8069, "a[|"); //ᾅ
        s0 = StringUtils.replace(s0, ""+(char)7941, "a["); //ἅ
        s0 = StringUtils.replace(s0, ""+(char)8070, "a=|"); //ᾆ
        s0 = StringUtils.replace(s0, ""+(char)7942, "a="); //ἆ
        s0 = StringUtils.replace(s0, ""+(char)8071, "a_|"); //ᾇ
        s0 = StringUtils.replace(s0, ""+(char)7943, "a_"); //ἇ
        s0 = StringUtils.replace(s0, ""+(char)8114, "a.|"); //ᾲ
        s0 = StringUtils.replace(s0, ""+(char)8048, "a."); //ὰ
        s0 = StringUtils.replace(s0, ""+(char)8116, "a,|"); //ᾴ
        s0 = StringUtils.replace(s0, ""+(char)8049, "a,"); //ά
        s0 = StringUtils.replace(s0, ""+(char)8119, "a/|"); //ᾷ
        s0 = StringUtils.replace(s0, ""+(char)8118, "a/"); //ᾶ
        s0 = StringUtils.replace(s0, ""+(char)8115, "a|"); //ᾳ
        s0 = StringUtils.replace(s0, ""+(char)945, "a"); //α
        
        s0 = StringUtils.replace(s0, ""+(char)946, "b"); //β
        s0 = StringUtils.replace(s0, ""+(char)947, "g"); //γ
        s0 = StringUtils.replace(s0, ""+(char)948, "d"); //δ
        
        s0 = StringUtils.replace(s0, ""+(char)7952, "ev"); //ἐ
        s0 = StringUtils.replace(s0, ""+(char)7953, "e`"); //ἑ
        s0 = StringUtils.replace(s0, ""+(char)7954, "e'"); //ἒ
        s0 = StringUtils.replace(s0, ""+(char)7955, "e]"); //ἓ
        s0 = StringUtils.replace(s0, ""+(char)7956, "e;"); //ἔ
        s0 = StringUtils.replace(s0, ""+(char)7957, "e["); //ἕ
        s0 = StringUtils.replace(s0, ""+(char)8050, "e."); //ὲ
        s0 = StringUtils.replace(s0, ""+(char)8051, "e,"); //έ
        s0 = StringUtils.replace(s0, ""+(char)949, "e"); //ε
        
        s0 = StringUtils.replace(s0, ""+(char)950, "z"); //ζ
        
        s0 = StringUtils.replace(s0, ""+(char)8080, "hv|"); //ᾐ
        s0 = StringUtils.replace(s0, ""+(char)7968, "hv"); //ἠ
        s0 = StringUtils.replace(s0, ""+(char)8081, "h`|"); //ᾑ
        s0 = StringUtils.replace(s0, ""+(char)7969, "h`"); //ἡ
        s0 = StringUtils.replace(s0, ""+(char)8082, "h'|"); //ᾒ
        s0 = StringUtils.replace(s0, ""+(char)7970, "h'"); //ἢ
        s0 = StringUtils.replace(s0, ""+(char)8083, "h]|"); //ᾓ
        s0 = StringUtils.replace(s0, ""+(char)7971, "h]"); //ἣ
        s0 = StringUtils.replace(s0, ""+(char)8084, "h;|"); //ᾔ
        s0 = StringUtils.replace(s0, ""+(char)7972, "h;"); //ἤ
        s0 = StringUtils.replace(s0, ""+(char)8085, "h[|"); //ᾕ
        s0 = StringUtils.replace(s0, ""+(char)7973, "h["); //ἥ
        s0 = StringUtils.replace(s0, ""+(char)8086, "h=|"); //ᾖ
        s0 = StringUtils.replace(s0, ""+(char)7974, "h="); //ἦ
        s0 = StringUtils.replace(s0, ""+(char)8087, "h_|"); //ᾗ
        s0 = StringUtils.replace(s0, ""+(char)7975, "h_"); //ἧ
        s0 = StringUtils.replace(s0, ""+(char)8130, "h.|"); //ῂ
        s0 = StringUtils.replace(s0, ""+(char)8052, "h."); //ὴ
        s0 = StringUtils.replace(s0, ""+(char)8132, "h,|"); //ῄ
        s0 = StringUtils.replace(s0, ""+(char)8053, "h,"); //ή
        s0 = StringUtils.replace(s0, ""+(char)8135, "h/|"); //ῇ
        s0 = StringUtils.replace(s0, ""+(char)8134, "h/"); //ῆ
        s0 = StringUtils.replace(s0, ""+(char)8131, "h|"); //ῃ
        s0 = StringUtils.replace(s0, ""+(char)951, "h"); //η
        
        s0 = StringUtils.replace(s0, ""+(char)952, "q"); //θ
        
        s0 = StringUtils.replace(s0, ""+(char)7984, "iv"); //ἰ
        s0 = StringUtils.replace(s0, ""+(char)7985, "i`"); //ἱ
        s0 = StringUtils.replace(s0, ""+(char)7986, "i'"); //ἲ
        s0 = StringUtils.replace(s0, ""+(char)7987, "i]"); //ἳ
        s0 = StringUtils.replace(s0, ""+(char)7988, "i;"); //ἴ
        s0 = StringUtils.replace(s0, ""+(char)7989, "i["); //ἵ
        s0 = StringUtils.replace(s0, ""+(char)7990, "i="); //ἶ
        s0 = StringUtils.replace(s0, ""+(char)7991, "i_"); //ἷ
        s0 = StringUtils.replace(s0, ""+(char)8146, "i>"); //ῒ
        s0 = StringUtils.replace(s0, ""+(char)8147, "i<"); //ΐ
        s0 = StringUtils.replace(s0, ""+(char)8054, "i."); //ὶ
        s0 = StringUtils.replace(s0, ""+(char)8055, "i,"); //ί
        s0 = StringUtils.replace(s0, ""+(char)8150, "i/"); //ῖ
        s0 = StringUtils.replace(s0, ""+(char)970, "i?"); //ϊ
        s0 = StringUtils.replace(s0, ""+(char)953, "i"); //ι
        
        s0 = StringUtils.replace(s0, ""+(char)954, "k"); //κ
        s0 = StringUtils.replace(s0, ""+(char)955, "l"); //λ
        s0 = StringUtils.replace(s0, ""+(char)956, "m"); //μ
        s0 = StringUtils.replace(s0, ""+(char)957, "n"); //ν
        s0 = StringUtils.replace(s0, ""+(char)958, "x"); //ξ
        
        s0 = StringUtils.replace(s0, ""+(char)8000, "ov"); //ὀ
        s0 = StringUtils.replace(s0, ""+(char)8001, "o`"); //ὁ
        s0 = StringUtils.replace(s0, ""+(char)8002, "o'"); //ὂ
        s0 = StringUtils.replace(s0, ""+(char)8003, "o]"); //ὃ
        s0 = StringUtils.replace(s0, ""+(char)8004, "o;"); //ὄ
        s0 = StringUtils.replace(s0, ""+(char)8005, "o["); //ὅ
        s0 = StringUtils.replace(s0, ""+(char)8056, "o."); //ὸ
        s0 = StringUtils.replace(s0, ""+(char)8057, "o,"); //ό
        s0 = StringUtils.replace(s0, ""+(char)959, "o"); //ο
        
        s0 = StringUtils.replace(s0, ""+(char)960, "p"); //π
        
        s0 = StringUtils.replace(s0, ""+(char)8165, "r`"); //ῥ
        s0 = StringUtils.replace(s0, ""+(char)961, "r"); //ρ
        
        s0 = StringUtils.replace(s0, ""+(char)962, "j"); //ς
        s0 = StringUtils.replace(s0, ""+(char)963, "s"); //σ
        s0 = StringUtils.replace(s0, ""+(char)964, "t"); //τ
        
        s0 = StringUtils.replace(s0, ""+(char)8016, "uv"); //ὐ
        s0 = StringUtils.replace(s0, ""+(char)8017, "u`"); //ὑ
        s0 = StringUtils.replace(s0, ""+(char)8018, "u'"); //ὒ
        s0 = StringUtils.replace(s0, ""+(char)8019, "u]"); //ὓ
        s0 = StringUtils.replace(s0, ""+(char)8020, "u;"); //ὔ
        s0 = StringUtils.replace(s0, ""+(char)8021, "u["); //ὕ
        s0 = StringUtils.replace(s0, ""+(char)8022, "u="); //ὖ
        s0 = StringUtils.replace(s0, ""+(char)8023, "u_"); //ὗ
        s0 = StringUtils.replace(s0, ""+(char)8162, "u>"); //ῢ
        s0 = StringUtils.replace(s0, ""+(char)8163, "u<"); //ΰ
        s0 = StringUtils.replace(s0, ""+(char)8058, "u."); //ὺ
        s0 = StringUtils.replace(s0, ""+(char)8059, "u,"); //ύ
        s0 = StringUtils.replace(s0, ""+(char)8166, "u/"); //ῦ
        s0 = StringUtils.replace(s0, ""+(char)971, "u?"); //ϋ
        s0 = StringUtils.replace(s0, ""+(char)965, "u"); //υ
        
        s0 = StringUtils.replace(s0, ""+(char)966, "f"); //φ
        s0 = StringUtils.replace(s0, ""+(char)967, "c"); //χ
        s0 = StringUtils.replace(s0, ""+(char)968, "y"); //ψ
        
        s0 = StringUtils.replace(s0, ""+(char)8096, "wv|"); //ᾠ
        s0 = StringUtils.replace(s0, ""+(char)8032, "wv"); //ὠ
        s0 = StringUtils.replace(s0, ""+(char)8097, "w`|"); //ᾡ
        s0 = StringUtils.replace(s0, ""+(char)8033, "w`"); //ὡ
        s0 = StringUtils.replace(s0, ""+(char)8098, "w'|"); //ᾢ
        s0 = StringUtils.replace(s0, ""+(char)8034, "w'"); //ὢ
        s0 = StringUtils.replace(s0, ""+(char)8099, "w]|"); //ᾣ
        s0 = StringUtils.replace(s0, ""+(char)8035, "w]"); //ὣ
        s0 = StringUtils.replace(s0, ""+(char)8100, "w;|"); //ᾤ
        s0 = StringUtils.replace(s0, ""+(char)8036, "w;"); //ὤ
        s0 = StringUtils.replace(s0, ""+(char)8101, "w[|"); //ᾥ
        s0 = StringUtils.replace(s0, ""+(char)8037, "w["); //ὥ
        s0 = StringUtils.replace(s0, ""+(char)8102, "w=|"); //ᾦ
        s0 = StringUtils.replace(s0, ""+(char)8038, "w="); //ὦ
        s0 = StringUtils.replace(s0, ""+(char)8103, "w_|"); //ᾧ
        s0 = StringUtils.replace(s0, ""+(char)8039, "w_"); //ὧ
        s0 = StringUtils.replace(s0, ""+(char)8178, "w.|"); //ῲ
        s0 = StringUtils.replace(s0, ""+(char)8060, "w."); //ὼ
        s0 = StringUtils.replace(s0, ""+(char)8180, "w,|"); //ῴ
        s0 = StringUtils.replace(s0, ""+(char)8061, "w,"); //ώ
        s0 = StringUtils.replace(s0, ""+(char)8183, "w/|"); //ῷ
        s0 = StringUtils.replace(s0, ""+(char)8182, "w/"); //ῶ
        s0 = StringUtils.replace(s0, ""+(char)8179, "w|"); //ῳ
        s0 = StringUtils.replace(s0, ""+(char)969, "w"); //ω
        
        s0 = StringUtils.replace(s0, "'", "V"); // apostrophe
        s0 = StringUtils.replace(s0, "'", "v"); // apostrophe aussi
        
        // Tirets : à conserver uniquement au milieu des mots
        s0 = StringUtils.replace(s0, "-", "&");
        
        return s0;
    }
}
