/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/


package fr.cnrs.liris.drim.grt.modele.convertisseurs;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author sgesche
 */
public class ConvertisseurNomLivresBible {
    
    private final static Map<String, String> ENFR = new HashMap<>();
    static {
        ENFR.put("Gen", "Gn");
        ENFR.put("Exo", "Ex");
        ENFR.put("Lev", "Lv");
        ENFR.put("Num", "Nb");
        ENFR.put("Deu", "Dt");
        ENFR.put("Jsa", "Josa");
        ENFR.put("Jos", "Jos");
        ENFR.put("Jda", "Jga");
        ENFR.put("Jdg", "Jg");
        ENFR.put("Rut", "Rt");
        ENFR.put("1Sa", "1Sa");
        ENFR.put("2Sa", "2Sa");
        ENFR.put("1Ki", "1Rg");
        ENFR.put("2Ki", "2Rg");
        ENFR.put("1Ch", "1Par");
        ENFR.put("2Ch", "2Par");
        ENFR.put("1Es", "1Esd");
        // Attention : Ezr et Neh sont tous deux contenus dans Ἔσδρας βʹ
        ENFR.put("Ezr", "2Esd");
        ENFR.put("Neh", "Nh");
        ENFR.put("Est", "Est");
        ENFR.put("Jdt", "Jdt");
        ENFR.put("Tob", "Tb");
        // Attention : Tbs n'est pas dans l'index grec
        ENFR.put("Tbs", "Tbs");
        ENFR.put("1Ma", "1M");
        ENFR.put("2Ma", "2M");
        ENFR.put("3Ma", "3M");
        ENFR.put("4Ma", "4M");
        ENFR.put("Psa", "Ps");
        ENFR.put("Ode", "Od");
        ENFR.put("Pro", "Pr");
        ENFR.put("Ecc", "Qo");
        ENFR.put("Sol", "Ct");
        ENFR.put("Job", "Jb");
        ENFR.put("Wis", "Sa");
        // Attention : Sip et Sir sont tous deux contenus dans Σοφία Σιράχ
        ENFR.put("Sip", "Sip");
        ENFR.put("Sir", "Si");
        ENFR.put("Pss", "Pss");
        ENFR.put("Hos", "Os");
        ENFR.put("Amo", "Am");
        ENFR.put("Mic", "Mi");
        ENFR.put("Joe", "Jl");
        ENFR.put("Oba", "Ab");
        ENFR.put("Jon", "Jon");
        ENFR.put("Nah", "Na");
        ENFR.put("Hab", "Ha");
        ENFR.put("Zep", "So");
        ENFR.put("Hag", "Ag");
        ENFR.put("Zec", "Za");
        ENFR.put("Mal", "Ml");
        ENFR.put("Isa", "Is");
        ENFR.put("Jer", "Jr");
        ENFR.put("Bar", "Ba");
        ENFR.put("Lam", "Lm");
        ENFR.put("Epj", "Ep.Jr");
        ENFR.put("Eze", "Ez");
        ENFR.put("Sus", "Su");
        ENFR.put("Sut", "Sut");
        ENFR.put("Dan", "Dn");
        ENFR.put("Dat", "Dnt");
        ENFR.put("Bel", "Bl");
        ENFR.put("Bet", "Blt");
        ENFR.put("Mat", "Mt");
        ENFR.put("Mar", "Mc");
        ENFR.put("Luk", "Lc");
        ENFR.put("Joh", "Jn");
        ENFR.put("Act", "Ac");
        ENFR.put("Rom", "Rm");
        ENFR.put("1Co", "1Co");
        ENFR.put("2Co", "2Co");
        ENFR.put("Gal", "Ga");
        ENFR.put("Eph", "Ep");
        ENFR.put("Phi", "Phi");
        ENFR.put("Col", "Col");
        ENFR.put("1Th", "1Th");
        ENFR.put("2Th", "2Th");
        ENFR.put("1Ti", "1Ti");
        ENFR.put("2Ti", "2Ti");
        ENFR.put("Tit", "Ti");
        ENFR.put("Phm", "Phm");
        ENFR.put("Heb", "Hb");
        ENFR.put("Jam", "Jq");
        ENFR.put("1Pe", "1Pi");
        ENFR.put("2Pe", "2Pi");
        ENFR.put("1Jo", "1Jn");
        ENFR.put("2Jo", "2Jn");
        ENFR.put("3Jo", "3Jn");
        ENFR.put("Jud", "Jud");
        ENFR.put("Rev", "Ap");
    }
    
    public static String convertisENversFR(String nomLivre) {
        return ENFR.get(nomLivre);
    }
}
