/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.ihm;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.text.StyledEditorKit;
import fr.cnrs.liris.drim.grt.proc.parsers.ExportFichier;
import fr.cnrs.liris.drim.grt.proc.parsers.ImportFichier;
import fr.cnrs.liris.drim.grt.proc.parsers.Temps;

/**
 *
 * @author sgesche
 */
public class FenetreRemarques extends javax.swing.JFrame {

    /**
     * Creates new form FenetreRemarques
     */
    public FenetreRemarques() {
        initComponents();
        
        Font grec = new Font("GFS DidotClassic", Font.PLAIN, 16);
        try {
            grec = Font.createFont(Font.TRUETYPE_FONT, new File("GFSDidot-Regular.ttf")).deriveFont(Font.PLAIN, 16f);
        } catch (FontFormatException | IOException ex) {
            
        }
        //remarques.setEditorKit(new StyledEditorKit());
        remarques.setFont(grec);
        remarques.setContentType("text/plain");
        
        setSize(400,600);
        
        chargeRemarques();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        bSave = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        remarques = new javax.swing.JEditorPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Mes remarques");

        bSave.setText("Sauvegarder");
        bSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bSaveActionPerformed(evt);
            }
        });
        jPanel1.add(bSave);

        getContentPane().add(jPanel1, java.awt.BorderLayout.PAGE_END);

        jScrollPane2.setViewportView(remarques);

        getContentPane().add(jScrollPane2, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void bSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bSaveActionPerformed
        // TODO add your handling code here:
        saveRemarques();
        setVisible(false);
    }//GEN-LAST:event_bSaveActionPerformed

    private void saveRemarques() {
        try {
            ExportFichier.exporteRemarques(new File("Remarques.txt"), remarques.getText());
        } catch(IOException ioe) {
            JOptionPane.showMessageDialog(this, "Impossible de sauvegarder les remarques, pour la raison suivante : " + ioe.getMessage());
        }
    }
    
    private void chargeRemarques() {
        try {
            String s = ImportFichier.importeRemarques(new File("Remarques.txt"));
            s += Temps.getDateCouranteEnBonFrancais() + "\n";
            remarques.setText(s);
        } catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Impossible de charger les remarques, pour la raison suivante : " + ioe.getMessage());
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bSave;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JEditorPane remarques;
    // End of variables declaration//GEN-END:variables
}
