/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.ihm;

import fr.cnrs.liris.drim.grt.ihm.exceptions.InteractionRefuseeException;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.rtf.RTFEditorKit;
import fr.cnrs.liris.drim.grt.modele.Citation;
import fr.cnrs.liris.drim.grt.modele.Corpus;
import fr.cnrs.liris.drim.grt.modele.Lemme;
import fr.cnrs.liris.drim.grt.modele.OrdreStrict;
import fr.cnrs.liris.drim.grt.modele.Passage;
import fr.cnrs.liris.drim.grt.modele.Terme;
import fr.cnrs.liris.drim.grt.modele.convertisseurs.ConvertisseurTexteUnicodeVersUnicode;
import fr.cnrs.liris.drim.grt.modele.exceptions.ListeStatistiqueNonInitialiseeException;
import fr.cnrs.liris.drim.grt.modele.listes.Lemmatiseurs;
import fr.cnrs.liris.drim.grt.modele.lemmatiseurs.BibleWorks;
import fr.cnrs.liris.drim.grt.modele.lemmatiseurs.Perseus;
import fr.cnrs.liris.drim.grt.proc.similarite.AnalyseurSpectral;
import fr.cnrs.liris.drim.grt.proc.ComparateurCitations;
import fr.cnrs.liris.drim.grt.proc.ReferencesDeCitation;
import fr.cnrs.liris.drim.grt.modele.lemmatiseurs.SourcesChretiennes;
import fr.cnrs.liris.drim.grt.proc.Texte;
import fr.cnrs.liris.drim.grt.modele.lemmatiseurs.Archimedes;
import fr.cnrs.liris.drim.grt.modele.listes.Frequences;
import fr.cnrs.liris.drim.grt.modele.listes.LemmesStatistiquementVides;
import fr.cnrs.liris.drim.grt.proc.exceptions.DOMCreationFailureException;
import fr.cnrs.liris.drim.grt.proc.parsers.CorrespondanceCADPTLG;
import fr.cnrs.liris.drim.grt.proc.parsers.CorrespondanceJERLXX;
import fr.cnrs.liris.drim.grt.proc.parsers.ExportFichier;
import fr.cnrs.liris.drim.grt.proc.parsers.ImportFichier;
import fr.cnrs.liris.drim.grt.proc.parsers.LecteurGrec;
import fr.cnrs.liris.drim.grt.proc.parsers.References;
import fr.cnrs.liris.drim.grt.proc.parsers.Temps;
import fr.cnrs.liris.drim.grt.proc.recherche.Experiences;
import fr.cnrs.liris.drim.grt.proc.recherche.Outils;
import fr.cnrs.liris.drim.grt.proc.parsers.PassageType;
import fr.cnrs.liris.drim.grt.proc.recherche.Recherche;
import fr.cnrs.liris.drim.grt.proc.recherche.RechercheNLexes;
import fr.cnrs.liris.drim.grt.proc.recherche.RechercheParVoisinage;
import fr.cnrs.liris.drim.grt.proc.similarite.AnalyseurSSpace;
import fr.cnrs.liris.drim.grt.proc.similarite.AuditAnalyseurSpectral;

/**
 *
 * @author sgesche
 */
public class FenetreDeveloppement extends javax.swing.JFrame {
    private Passage docActuel;
    private Corpus corpus;
    private Passage citeur;
    private Passage source;
    
    private PassageType xpBible;
    private PassageType xpQuisDives;
    private ReferencesDeCitation[] xpRefs;
    private Citation[] xpCitations;
    private ReferencesDeCitation[] xpRefsSA;
    private Citation[] xpCitationsSA;
    
    private Passage testSrc;
    private Passage testCit;
    private ReferencesDeCitation[] testRefs;
    private Citation[] testCitations;
    private ReferencesDeCitation[] testRefsSA;
    private Citation[] testCitationsSA;
    
    private long maxUsedMemory = 0;
    private ActionListener timer = new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent ae) {
            maxUsedMemory = Math.max(maxUsedMemory, 
                    Runtime.getRuntime().totalMemory() - 
                    Runtime.getRuntime().freeMemory());
            lMemoire.setText("Mémoire utilisée : " + 
                    ((Runtime.getRuntime().totalMemory()/1024/1024) - 
                    (Runtime.getRuntime().freeMemory()/1024/1024)) +
                    "Mo (max "+maxUsedMemory/1024/1024+
                    "Mo) - Mémoire disponible : "+
                    (Runtime.getRuntime().freeMemory()/1024/1024)+"Mo / "+
                    (Runtime.getRuntime().totalMemory()/1024/1024)+"Mo (max "+
                    (Runtime.getRuntime().maxMemory()/1024/1024)+"Mo)");
        }
    };
    private Timer memoire = new Timer(250, timer);
    
    /**
     * Creates new form FenetreDeveloppement
     */
    public FenetreDeveloppement() {
        initComponents();
        /*try {
            tTexte.setFont(Font.createFont(Font.TRUETYPE_FONT, new File("GFSDidot_Classic.ttf")).deriveFont(12));
            } catch (FontFormatException | IOException ex) {
            tTexte.setText(ex.getClass() + " : " + ex.getMessage());
            System.out.println(ex.getClass() + " : " + ex.getMessage());
        }*/
        this.setTitle("GreekReader");
        Font grec = new Font("GFS DidotClassic", Font.PLAIN, 16);
        try {
            grec = Font.createFont(Font.TRUETYPE_FONT, new File("GFSDidot-Regular.ttf")).deriveFont(Font.PLAIN, 16f);
        } catch (FontFormatException | IOException ex) {
            lStatut.setText(ex.getClass() + " : " + ex.getMessage());
        }
        tTexte.setFont(grec);
        tResultatRechercheCitations.setFont(grec);
        tTrouve.setFont(grec);
        tCaracteresLus.setFont(grec);
        tTFIDF.setFont(grec);
        tMotsALemmatiser.setFont(grec);
        tReponseLemmatisation.setFont(grec);
        tCitationsTemoin.setFont(grec);
        tCitationsLitteral.setFont(grec);
        tCpteRenduToutesXP.setFont(grec);
        tTexte.setContentType("text/plain");
        tResultatRechercheCitations.setContentType("text/plain");
        tReponseLemmatisation.setContentType("text/plain");
        tCitationsTemoin.setContentType("text/plain");
        tCitationsTemoin.setText("Veuillez charger la base d'expériences");
        tCitationsLitteral.setContentType("text/plain");
        tCpteRenduToutesXP.setContentType("text/plain");
        memoire.start();
        docActuel = null;
        corpus = new Corpus();
        tXPPrefixe.setText("XP_" + Temps.getDateCourante() + "_");
        
        // test des différents caractères de la police utilisée
        /*ArrayList<Character> test = new ArrayList<>();
        for(int i=0; i<65535; i++) {
            test.add(new Character((char)i));
        }
        char[] test2 = new char[test.size()];
        for(int i=0; i<test.size(); i++) {
            test2[i] = test.get(i).charValue();
        }
        tTexte.setText(new String(test2));*/
        GestionnaireErreurs.getInstance().setContexteAffichage(getContentPane());
        
        tLemmesStockes.setText("Archimedes : \n\n" + 
                Archimedes.getInstance().getStats() + 
                "\n\n\nPerseus : \n\n" + 
                Perseus.getInstance().getStats() + 
                "\n\n\nBibleWorks : \n\n" + 
                BibleWorks.getInstance().getStats() + 
                "\n\n\nSources Chrétiennes : \n\n" + 
                SourcesChretiennes.getInstance().getStats());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        boutonsTraitement = new javax.swing.ButtonGroup();
        boutonsTolerance = new javax.swing.ButtonGroup();
        boutonsVTraitement = new javax.swing.ButtonGroup();
        pStatut = new javax.swing.JPanel();
        lMemoire = new javax.swing.JLabel();
        pMenu = new javax.swing.JTabbedPane();
        pTabLecture = new javax.swing.JPanel();
        pMenuLecture = new javax.swing.JPanel();
        bChargerCSV = new javax.swing.JButton();
        bChargerRTF = new javax.swing.JButton();
        bChargerBibleTXT = new javax.swing.JButton();
        bChargerTXT = new javax.swing.JButton();
        bChargerTest = new javax.swing.JButton();
        bChargerXML = new javax.swing.JButton();
        bAjoutTest = new javax.swing.JButton();
        bChargerRTFMasse = new javax.swing.JButton();
        bSaveXML = new javax.swing.JButton();
        bEditionLemmatisee = new javax.swing.JButton();
        bChargeCADPTLG = new javax.swing.JButton();
        bChargeJERLXX = new javax.swing.JButton();
        bLemmatiserBibleWorks = new javax.swing.JButton();
        bCopieBWDansSC = new javax.swing.JButton();
        bLemmatiserFichier = new javax.swing.JButton();
        bListerNomsPropres = new javax.swing.JButton();
        bClustering = new javax.swing.JButton();
        bTableCorrespondance = new javax.swing.JButton();
        bListeTermesFrq = new javax.swing.JButton();
        bDedoublonnerLemmes = new javax.swing.JButton();
        bLemmeDeLemmeEstLemme = new javax.swing.JButton();
        bFrequencesTermes = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        bBlocsMots = new javax.swing.JButton();
        generationNLexes = new javax.swing.JButton();
        bLemmesParFrequence = new javax.swing.JButton();
        bStatsLemmatiseurs = new javax.swing.JButton();
        bGenereBase = new javax.swing.JButton();
        pMain = new javax.swing.JPanel();
        lStatut = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        tTexte = new javax.swing.JEditorPane();
        jPanel1 = new javax.swing.JPanel();
        bTrouve = new javax.swing.JButton();
        tTrouve = new javax.swing.JTextField();
        lTrouve = new javax.swing.JLabel();
        pTabStats = new javax.swing.JPanel();
        pCaracteres = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        tCaracteresLus = new javax.swing.JTextArea();
        pStatsLemmatiseurs = new javax.swing.JPanel();
        jLabel8 = new javax.swing.JLabel();
        jScrollPane6 = new javax.swing.JScrollPane();
        tLemmesStockes = new javax.swing.JTextArea();
        jPanel2 = new javax.swing.JPanel();
        bListerLemmesNonTrouves = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        jScrollPane7 = new javax.swing.JScrollPane();
        tTFIDF = new javax.swing.JEditorPane();
        jPanel13 = new javax.swing.JPanel();
        bLancerTFIDF = new javax.swing.JButton();
        pLemmatisation = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        tMotsALemmatiser = new javax.swing.JTextField();
        bLemmatiser = new javax.swing.JButton();
        jPanel8 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jScrollPane4 = new javax.swing.JScrollPane();
        tReponseLemmatisation = new javax.swing.JEditorPane();
        pExperiences = new javax.swing.JPanel();
        pListeExperiences = new javax.swing.JTabbedPane();
        pXpToutLancer = new javax.swing.JPanel();
        jPanel11 = new javax.swing.JPanel();
        jLabel22 = new javax.swing.JLabel();
        cbXPCorpus = new javax.swing.JComboBox();
        jLabel14 = new javax.swing.JLabel();
        tXPPrefixe = new javax.swing.JTextField();
        bXpToutLancer = new javax.swing.JButton();
        lXpToutRapport = new javax.swing.JLabel();
        jScrollPane11 = new javax.swing.JScrollPane();
        tCpteRenduToutesXP = new javax.swing.JEditorPane();
        pXpTemoin = new javax.swing.JPanel();
        jPanel14 = new javax.swing.JPanel();
        bChargerExperience = new javax.swing.JButton();
        bStatsBaseXP = new javax.swing.JButton();
        jScrollPane8 = new javax.swing.JScrollPane();
        tCitationsTemoin = new javax.swing.JEditorPane();
        pXpLitteral = new javax.swing.JPanel();
        pXpLitteralEval = new javax.swing.JPanel();
        pXpLitteralParams = new javax.swing.JPanel();
        jPanel15 = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        tXpLitteralParamN = new javax.swing.JFormattedTextField();
        jPanel16 = new javax.swing.JPanel();
        cXpOrdre = new javax.swing.JCheckBox();
        cXpMotsVides = new javax.swing.JCheckBox();
        jPanel17 = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        cXpTrAucun = new javax.swing.JRadioButton();
        cXpTrNorm = new javax.swing.JRadioButton();
        cXpTrLemm = new javax.swing.JRadioButton();
        jPanel18 = new javax.swing.JPanel();
        jLabel16 = new javax.swing.JLabel();
        cXpTolExact = new javax.swing.JRadioButton();
        cXpTolSeuil1 = new javax.swing.JRadioButton();
        cXpTolSeuil2 = new javax.swing.JRadioButton();
        jPanel19 = new javax.swing.JPanel();
        jLabel17 = new javax.swing.JLabel();
        tXpLitteralSeuil = new javax.swing.JFormattedTextField();
        bXpLitteralLancer = new javax.swing.JButton();
        lXpLitteralRapport = new javax.swing.JLabel();
        jScrollPane9 = new javax.swing.JScrollPane();
        tXpLitteralCpteRendu = new javax.swing.JTextArea();
        jScrollPane10 = new javax.swing.JScrollPane();
        tCitationsLitteral = new javax.swing.JEditorPane();
        pXpVoisinage = new javax.swing.JPanel();
        pXpVoisinageEval = new javax.swing.JPanel();
        pXpVoisinageParams = new javax.swing.JPanel();
        jPanel20 = new javax.swing.JPanel();
        jLabel12 = new javax.swing.JLabel();
        tXpVoisinageParamN = new javax.swing.JFormattedTextField();
        jPanel21 = new javax.swing.JPanel();
        cXpVMotsVides = new javax.swing.JCheckBox();
        cXpVMulticitation = new javax.swing.JCheckBox();
        jPanel22 = new javax.swing.JPanel();
        jLabel13 = new javax.swing.JLabel();
        cXpVTrAucun = new javax.swing.JRadioButton();
        cXpVTrNorm = new javax.swing.JRadioButton();
        cXpVTrLemm = new javax.swing.JRadioButton();
        bXpVoisinageLancer = new javax.swing.JButton();
        lXpVoisinageRapport = new javax.swing.JLabel();
        jScrollPane12 = new javax.swing.JScrollPane();
        tXpVoisinageCpteRendu = new javax.swing.JTextArea();
        jScrollPane13 = new javax.swing.JScrollPane();
        tCitationsVoisinage = new javax.swing.JEditorPane();
        jPanel12 = new javax.swing.JPanel();
        jPanel23 = new javax.swing.JPanel();
        jLabel15 = new javax.swing.JLabel();
        spAuditNbTermes = new javax.swing.JSpinner();
        jLabel18 = new javax.swing.JLabel();
        cbAuditTraitement = new javax.swing.JComboBox();
        jLabel19 = new javax.swing.JLabel();
        cbAuditTermesChoisis = new javax.swing.JComboBox();
        jLabel20 = new javax.swing.JLabel();
        tfAuditSeuil = new javax.swing.JFormattedTextField();
        jLabel21 = new javax.swing.JLabel();
        bcAuditDistance = new javax.swing.JComboBox();
        bAuditLancer = new javax.swing.JButton();
        lAuditStatut = new javax.swing.JLabel();
        jScrollPane14 = new javax.swing.JScrollPane();
        tAuditResultat = new javax.swing.JEditorPane();
        pRechercheCitations = new javax.swing.JSplitPane();
        jPanel3 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        lCorpus = new javax.swing.JList();
        jPanel4 = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        bChoixTexteCite = new javax.swing.JButton();
        lChoixTexteCite = new javax.swing.JLabel();
        jPanel9 = new javax.swing.JPanel();
        bChoixTexteCiteur = new javax.swing.JButton();
        lChoixTexteCiteur = new javax.swing.JLabel();
        jPanel10 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        tFenetreLitteral = new javax.swing.JFormattedTextField();
        bLancerRechercheLitterale = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        tFenetreVoisinage = new javax.swing.JFormattedTextField();
        bLancerRechercheVoisinage = new javax.swing.JButton();
        jLabel7 = new javax.swing.JLabel();
        tFenetreVoisinage2 = new javax.swing.JFormattedTextField();
        bLancerRechercheVoisinage2 = new javax.swing.JButton();
        jScrollPane5 = new javax.swing.JScrollPane();
        tResultatRechercheCitations = new javax.swing.JEditorPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Greek Reuse Toolkit - Développement");

        pStatut.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        lMemoire.setText("Mémoire disponible : ???");
        pStatut.add(lMemoire);

        getContentPane().add(pStatut, java.awt.BorderLayout.NORTH);

        pTabLecture.setLayout(new java.awt.BorderLayout());

        pMenuLecture.setLayout(new java.awt.GridLayout(7, 4));

        bChargerCSV.setText("<html>Charger un fichier biblique CSV");
        bChargerCSV.setEnabled(false);
        bChargerCSV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChargerCSVActionPerformed(evt);
            }
        });
        pMenuLecture.add(bChargerCSV);

        bChargerRTF.setText("Charger un fichier RTF");
        bChargerRTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChargerRTFActionPerformed(evt);
            }
        });
        pMenuLecture.add(bChargerRTF);

        bChargerBibleTXT.setText("<html>Charger un fichier biblique en TXT<br><i>(LXX ou NTG, texte ou morpho)</i></html>");
        bChargerBibleTXT.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChargerBibleTXTActionPerformed(evt);
            }
        });
        pMenuLecture.add(bChargerBibleTXT);

        bChargerTXT.setText("<html>Charger un fichier quelconque en TXT<br><i>(LXX ou NTG, texte ou morpho)</i></html>");
        bChargerTXT.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChargerTXTActionPerformed(evt);
            }
        });
        pMenuLecture.add(bChargerTXT);

        bChargerTest.setText("Charger un fichier de test TXT");
        bChargerTest.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChargerTestActionPerformed(evt);
            }
        });
        pMenuLecture.add(bChargerTest);

        bChargerXML.setText("<html>Charger un fichier XML exporté<br>");
        bChargerXML.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChargerXMLActionPerformed(evt);
            }
        });
        pMenuLecture.add(bChargerXML);

        bAjoutTest.setText("Ajouter ce document au corpus");
        bAjoutTest.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bAjoutTestActionPerformed(evt);
            }
        });
        pMenuLecture.add(bAjoutTest);

        bChargerRTFMasse.setText("Charger un corpus RTF de test");
        bChargerRTFMasse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChargerRTFMasseActionPerformed(evt);
            }
        });
        pMenuLecture.add(bChargerRTFMasse);

        bSaveXML.setText("<html>Exporter ce texte en XML");
        bSaveXML.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bSaveXMLActionPerformed(evt);
            }
        });
        pMenuLecture.add(bSaveXML);

        bEditionLemmatisee.setText("Editer ce texte avec sa version lemmatisée");
        bEditionLemmatisee.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bEditionLemmatiseeActionPerformed(evt);
            }
        });
        pMenuLecture.add(bEditionLemmatisee);

        bChargeCADPTLG.setText("Charger les correspondances entre CADP et TLG");
        bChargeCADPTLG.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChargeCADPTLGActionPerformed(evt);
            }
        });
        pMenuLecture.add(bChargeCADPTLG);

        bChargeJERLXX.setText("Charger les correspondances entre JER et LXX");
        bChargeJERLXX.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChargeJERLXXActionPerformed(evt);
            }
        });
        pMenuLecture.add(bChargeJERLXX);

        bLemmatiserBibleWorks.setText("Lemmatiser des textes de BibleWorks");
        bLemmatiserBibleWorks.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLemmatiserBibleWorksActionPerformed(evt);
            }
        });
        pMenuLecture.add(bLemmatiserBibleWorks);

        bCopieBWDansSC.setText("Copier les lemmes BibleWorks dans SourcesChretiennes");
        bCopieBWDansSC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bCopieBWDansSCActionPerformed(evt);
            }
        });
        pMenuLecture.add(bCopieBWDansSC);

        bLemmatiserFichier.setText("<html>Entrer un fichier de lemmes txt<br/><i>(terme [lemme])</i>");
        bLemmatiserFichier.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLemmatiserFichierActionPerformed(evt);
            }
        });
        pMenuLecture.add(bLemmatiserFichier);

        bListerNomsPropres.setText("Former une liste de noms propres");
        bListerNomsPropres.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bListerNomsPropresActionPerformed(evt);
            }
        });
        pMenuLecture.add(bListerNomsPropres);

        bClustering.setText("Lancer le clustering du corpus");
        bClustering.setEnabled(false);
        bClustering.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bClusteringActionPerformed(evt);
            }
        });
        pMenuLecture.add(bClustering);

        bTableCorrespondance.setText("Générer une table de correspondance biblique");
        bTableCorrespondance.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bTableCorrespondanceActionPerformed(evt);
            }
        });
        pMenuLecture.add(bTableCorrespondance);

        bListeTermesFrq.setText("Lister les suites de lemmes les plus fréquentes");
        bListeTermesFrq.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bListeTermesFrqActionPerformed(evt);
            }
        });
        pMenuLecture.add(bListeTermesFrq);

        bDedoublonnerLemmes.setText("Dédoublonner la liste des lemmes multi-sources");
        bDedoublonnerLemmes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bDedoublonnerLemmesActionPerformed(evt);
            }
        });
        pMenuLecture.add(bDedoublonnerLemmes);

        bLemmeDeLemmeEstLemme.setText("Entrer chaque lemme comme son propre lemme");
        bLemmeDeLemmeEstLemme.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLemmeDeLemmeEstLemmeActionPerformed(evt);
            }
        });
        pMenuLecture.add(bLemmeDeLemmeEstLemme);

        bFrequencesTermes.setText("Alimenter la base des fréquences des termes");
        bFrequencesTermes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bFrequencesTermesActionPerformed(evt);
            }
        });
        pMenuLecture.add(bFrequencesTermes);

        jButton1.setText("<html>Générer la liste des lemmes Perseus<br>à partir d'une liste en BetaCode");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        pMenuLecture.add(jButton1);

        bBlocsMots.setText("Ajouter des blocs de mots pour la distance sémantique");
        bBlocsMots.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bBlocsMotsActionPerformed(evt);
            }
        });
        pMenuLecture.add(bBlocsMots);

        generationNLexes.setText("<html>Générer les n-grams des textes<br/>de la base d'expérience");
        generationNLexes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                generationNLexesActionPerformed(evt);
            }
        });
        pMenuLecture.add(generationNLexes);

        bLemmesParFrequence.setText("Générer la liste des lemmes par fréquence documentaire");
        bLemmesParFrequence.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLemmesParFrequenceActionPerformed(evt);
            }
        });
        pMenuLecture.add(bLemmesParFrequence);

        bStatsLemmatiseurs.setText("Générer les statistiques sur les lemmatiseurs");
        bStatsLemmatiseurs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bStatsLemmatiseursActionPerformed(evt);
            }
        });
        pMenuLecture.add(bStatsLemmatiseurs);

        bGenereBase.setText("Générer le contenu de la base");
        bGenereBase.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bGenereBaseActionPerformed(evt);
            }
        });
        pMenuLecture.add(bGenereBase);

        pTabLecture.add(pMenuLecture, java.awt.BorderLayout.PAGE_START);

        pMain.setLayout(new java.awt.BorderLayout());

        lStatut.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lStatut.setText("Le texte lu :");
        pMain.add(lStatut, java.awt.BorderLayout.PAGE_START);

        tTexte.setEditable(false);
        jScrollPane2.setViewportView(tTexte);

        pMain.add(jScrollPane2, java.awt.BorderLayout.CENTER);

        bTrouve.setText("Retrouver le texte : ");
        bTrouve.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bTrouveActionPerformed(evt);
            }
        });
        jPanel1.add(bTrouve);

        tTrouve.setColumns(30);
        jPanel1.add(tTrouve);

        lTrouve.setText("Ce texte n'a pas été retrouvé.");
        jPanel1.add(lTrouve);

        pMain.add(jPanel1, java.awt.BorderLayout.PAGE_END);

        pTabLecture.add(pMain, java.awt.BorderLayout.CENTER);

        pMenu.addTab("Lecture", pTabLecture);

        pTabStats.setLayout(new java.awt.GridLayout(3, 1));

        pCaracteres.setLayout(new java.awt.BorderLayout());

        jLabel1.setText("Caractères lus : ");
        pCaracteres.add(jLabel1, java.awt.BorderLayout.WEST);

        tCaracteresLus.setEditable(false);
        tCaracteresLus.setColumns(35);
        tCaracteresLus.setRows(60);
        jScrollPane3.setViewportView(tCaracteresLus);

        pCaracteres.add(jScrollPane3, java.awt.BorderLayout.CENTER);

        pTabStats.add(pCaracteres);

        pStatsLemmatiseurs.setLayout(new java.awt.BorderLayout());

        jLabel8.setText("Qualité des lemmes :");
        pStatsLemmatiseurs.add(jLabel8, java.awt.BorderLayout.WEST);

        tLemmesStockes.setEditable(false);
        tLemmesStockes.setColumns(20);
        tLemmesStockes.setRows(5);
        jScrollPane6.setViewportView(tLemmesStockes);

        pStatsLemmatiseurs.add(jScrollPane6, java.awt.BorderLayout.CENTER);

        bListerLemmesNonTrouves.setText("Editer la liste des lemmes non trouvés");
        bListerLemmesNonTrouves.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bListerLemmesNonTrouvesActionPerformed(evt);
            }
        });
        jPanel2.add(bListerLemmesNonTrouves);

        pStatsLemmatiseurs.add(jPanel2, java.awt.BorderLayout.LINE_END);

        pTabStats.add(pStatsLemmatiseurs);

        jPanel6.setLayout(new java.awt.BorderLayout());

        jLabel9.setText("Tri des termes par fréquence : ");
        jPanel6.add(jLabel9, java.awt.BorderLayout.LINE_START);

        tTFIDF.setEditable(false);
        jScrollPane7.setViewportView(tTFIDF);

        jPanel6.add(jScrollPane7, java.awt.BorderLayout.CENTER);

        bLancerTFIDF.setText("Calculer");
        bLancerTFIDF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLancerTFIDFActionPerformed(evt);
            }
        });
        jPanel13.add(bLancerTFIDF);

        jPanel6.add(jPanel13, java.awt.BorderLayout.LINE_END);

        pTabStats.add(jPanel6);

        pMenu.addTab("Stats", pTabStats);

        pLemmatisation.setLayout(new java.awt.BorderLayout());

        jPanel7.setLayout(new java.awt.BorderLayout());

        jLabel4.setText("Entrez des mots à lemmatiser (séparés par des espaces) :");
        jPanel7.add(jLabel4, java.awt.BorderLayout.WEST);

        tMotsALemmatiser.setColumns(100);
        jPanel7.add(tMotsALemmatiser, java.awt.BorderLayout.CENTER);

        bLemmatiser.setText("Lemmatiser !");
        bLemmatiser.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLemmatiserActionPerformed(evt);
            }
        });
        jPanel7.add(bLemmatiser, java.awt.BorderLayout.EAST);

        pLemmatisation.add(jPanel7, java.awt.BorderLayout.NORTH);

        jPanel8.setLayout(new java.awt.BorderLayout());

        jLabel5.setText("La réponse : ");
        jPanel8.add(jLabel5, java.awt.BorderLayout.WEST);

        jScrollPane4.setViewportView(tReponseLemmatisation);

        jPanel8.add(jScrollPane4, java.awt.BorderLayout.CENTER);

        pLemmatisation.add(jPanel8, java.awt.BorderLayout.CENTER);

        pMenu.addTab("Lemmatisation", pLemmatisation);

        pExperiences.setLayout(new java.awt.BorderLayout());

        pXpToutLancer.setLayout(new java.awt.BorderLayout());

        jLabel22.setText("Corpus : ");
        jPanel11.add(jLabel22);

        cbXPCorpus.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Philon", "Quis Dives" }));
        jPanel11.add(cbXPCorpus);

        jLabel14.setText("Préfixe pour les fichiers de rapport : ");
        jPanel11.add(jLabel14);

        tXPPrefixe.setColumns(20);
        tXPPrefixe.setText("Expérience");
        jPanel11.add(tXPPrefixe);

        bXpToutLancer.setText("Tout lancer");
        bXpToutLancer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bXpToutLancerActionPerformed(evt);
            }
        });
        jPanel11.add(bXpToutLancer);
        jPanel11.add(lXpToutRapport);

        pXpToutLancer.add(jPanel11, java.awt.BorderLayout.PAGE_START);

        jScrollPane11.setViewportView(tCpteRenduToutesXP);

        pXpToutLancer.add(jScrollPane11, java.awt.BorderLayout.CENTER);

        pListeExperiences.addTab("Nuit blanche", pXpToutLancer);

        pXpTemoin.setLayout(new java.awt.BorderLayout());

        bChargerExperience.setText("Charger la base d'expérience");
        bChargerExperience.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChargerExperienceActionPerformed(evt);
            }
        });
        jPanel14.add(bChargerExperience);

        bStatsBaseXP.setText("En exporter les statistiques");
        bStatsBaseXP.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bStatsBaseXPActionPerformed(evt);
            }
        });
        jPanel14.add(bStatsBaseXP);

        pXpTemoin.add(jPanel14, java.awt.BorderLayout.PAGE_START);

        tCitationsTemoin.setEditable(false);
        jScrollPane8.setViewportView(tCitationsTemoin);

        pXpTemoin.add(jScrollPane8, java.awt.BorderLayout.CENTER);

        pListeExperiences.addTab("Témoin", pXpTemoin);

        pXpLitteral.setLayout(new java.awt.BorderLayout());

        pXpLitteralParams.setLayout(new java.awt.GridLayout(5, 0));

        jLabel10.setText("Taille des n-lexes : ");
        jPanel15.add(jLabel10);

        tXpLitteralParamN.setColumns(3);
        tXpLitteralParamN.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(java.text.NumberFormat.getIntegerInstance())));
        tXpLitteralParamN.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tXpLitteralParamN.setText("5");
        jPanel15.add(tXpLitteralParamN);

        pXpLitteralParams.add(jPanel15);

        cXpOrdre.setSelected(true);
        cXpOrdre.setText("L'ordre des mots compte");
        cXpOrdre.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cXpOrdreActionPerformed(evt);
            }
        });
        jPanel16.add(cXpOrdre);

        cXpMotsVides.setText("Filtrer les mots vides");
        jPanel16.add(cXpMotsVides);

        pXpLitteralParams.add(jPanel16);

        jLabel11.setText("Traitement : ");
        jPanel17.add(jLabel11);

        boutonsTraitement.add(cXpTrAucun);
        cXpTrAucun.setText("Aucun");
        jPanel17.add(cXpTrAucun);

        boutonsTraitement.add(cXpTrNorm);
        cXpTrNorm.setText("Normalisation");
        jPanel17.add(cXpTrNorm);

        boutonsTraitement.add(cXpTrLemm);
        cXpTrLemm.setText("Lemmatisation");
        jPanel17.add(cXpTrLemm);

        pXpLitteralParams.add(jPanel17);

        jLabel16.setText("Tolérance : ");
        jPanel18.add(jLabel16);

        boutonsTolerance.add(cXpTolExact);
        cXpTolExact.setText("Exactitude");
        jPanel18.add(cXpTolExact);

        boutonsTolerance.add(cXpTolSeuil1);
        cXpTolSeuil1.setText("Seuil");
        jPanel18.add(cXpTolSeuil1);

        boutonsTolerance.add(cXpTolSeuil2);
        cXpTolSeuil2.setText("Seuil (%)");
        jPanel18.add(cXpTolSeuil2);

        pXpLitteralParams.add(jPanel18);

        jLabel17.setText("Seuil : ");
        jPanel19.add(jLabel17);

        tXpLitteralSeuil.setColumns(3);
        tXpLitteralSeuil.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(java.text.NumberFormat.getIntegerInstance())));
        tXpLitteralSeuil.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tXpLitteralSeuil.setText("0");
        tXpLitteralSeuil.setToolTipText("");
        jPanel19.add(tXpLitteralSeuil);

        pXpLitteralParams.add(jPanel19);

        pXpLitteralEval.add(pXpLitteralParams);

        bXpLitteralLancer.setText("Lancer");
        bXpLitteralLancer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bXpLitteralLancerActionPerformed(evt);
            }
        });
        pXpLitteralEval.add(bXpLitteralLancer);

        lXpLitteralRapport.setText("Expérience effectuée à 0%");
        pXpLitteralEval.add(lXpLitteralRapport);

        tXpLitteralCpteRendu.setEditable(false);
        tXpLitteralCpteRendu.setColumns(20);
        tXpLitteralCpteRendu.setRows(5);
        tXpLitteralCpteRendu.setText("Compte-rendu");
        jScrollPane9.setViewportView(tXpLitteralCpteRendu);

        pXpLitteralEval.add(jScrollPane9);

        pXpLitteral.add(pXpLitteralEval, java.awt.BorderLayout.PAGE_START);

        tCitationsLitteral.setEditable(false);
        jScrollPane10.setViewportView(tCitationsLitteral);

        pXpLitteral.add(jScrollPane10, java.awt.BorderLayout.CENTER);

        pListeExperiences.addTab("Recherche par n-lexes", pXpLitteral);

        pXpVoisinage.setLayout(new java.awt.BorderLayout());

        pXpVoisinageParams.setLayout(new java.awt.GridLayout(5, 0));

        jLabel12.setText("Taille des fenêtres chevauchantes : ");
        jPanel20.add(jLabel12);

        tXpVoisinageParamN.setColumns(3);
        tXpVoisinageParamN.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(java.text.NumberFormat.getIntegerInstance())));
        tXpVoisinageParamN.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tXpVoisinageParamN.setText("5");
        jPanel20.add(tXpVoisinageParamN);

        pXpVoisinageParams.add(jPanel20);

        cXpVMotsVides.setText("Filtrer les mots vides");
        jPanel21.add(cXpVMotsVides);

        cXpVMulticitation.setText("Une citation peut citer plusieurs sources");
        jPanel21.add(cXpVMulticitation);

        pXpVoisinageParams.add(jPanel21);

        jLabel13.setText("Traitement : ");
        jPanel22.add(jLabel13);

        boutonsVTraitement.add(cXpVTrAucun);
        cXpVTrAucun.setSelected(true);
        cXpVTrAucun.setText("Aucun");
        jPanel22.add(cXpVTrAucun);

        boutonsVTraitement.add(cXpVTrNorm);
        cXpVTrNorm.setText("Normalisation");
        jPanel22.add(cXpVTrNorm);

        boutonsVTraitement.add(cXpVTrLemm);
        cXpVTrLemm.setText("Lemmatisation");
        jPanel22.add(cXpVTrLemm);

        pXpVoisinageParams.add(jPanel22);

        pXpVoisinageEval.add(pXpVoisinageParams);

        bXpVoisinageLancer.setText("Lancer");
        bXpVoisinageLancer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bXpVoisinageLancerActionPerformed(evt);
            }
        });
        pXpVoisinageEval.add(bXpVoisinageLancer);

        lXpVoisinageRapport.setText("Expérience effectuée à 0%");
        pXpVoisinageEval.add(lXpVoisinageRapport);

        tXpVoisinageCpteRendu.setEditable(false);
        tXpVoisinageCpteRendu.setColumns(20);
        tXpVoisinageCpteRendu.setRows(5);
        tXpVoisinageCpteRendu.setText("Compte-rendu");
        jScrollPane12.setViewportView(tXpVoisinageCpteRendu);

        pXpVoisinageEval.add(jScrollPane12);

        pXpVoisinage.add(pXpVoisinageEval, java.awt.BorderLayout.PAGE_START);

        tCitationsVoisinage.setEditable(false);
        jScrollPane13.setViewportView(tCitationsVoisinage);

        pXpVoisinage.add(jScrollPane13, java.awt.BorderLayout.CENTER);

        pListeExperiences.addTab("Recherche par voisinage", pXpVoisinage);

        jPanel12.setLayout(new java.awt.BorderLayout());

        jLabel15.setText("Nombre de termes fréquents : ");
        jPanel23.add(jLabel15);

        spAuditNbTermes.setPreferredSize(new java.awt.Dimension(40, 20));
        jPanel23.add(spAuditNbTermes);

        jLabel18.setText("Traitement : ");
        jPanel23.add(jLabel18);

        cbAuditTraitement.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "aucun", "normalisation", "lemmatisation" }));
        jPanel23.add(cbAuditTraitement);

        jLabel19.setText("Termes utilisés : ");
        jPanel23.add(jLabel19);

        cbAuditTermesChoisis.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "tous sauf mots vides", "lemmes récurrents uniquement" }));
        jPanel23.add(cbAuditTermesChoisis);

        jLabel20.setText("Seuil de similarité : ");
        jPanel23.add(jLabel20);

        tfAuditSeuil.setColumns(5);
        tfAuditSeuil.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter()));
        tfAuditSeuil.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tfAuditSeuil.setValue(0.80);
        tfAuditSeuil.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tfAuditSeuilActionPerformed(evt);
            }
        });
        jPanel23.add(tfAuditSeuil);

        jLabel21.setText("Distance : ");
        jPanel23.add(jLabel21);

        bcAuditDistance.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "euclidienne", "Manhattan" }));
        jPanel23.add(bcAuditDistance);

        bAuditLancer.setText("Lancer l'audit");
        bAuditLancer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bAuditLancerActionPerformed(evt);
            }
        });
        jPanel23.add(bAuditLancer);
        jPanel23.add(lAuditStatut);

        jPanel12.add(jPanel23, java.awt.BorderLayout.PAGE_START);

        jScrollPane14.setViewportView(tAuditResultat);

        jPanel12.add(jScrollPane14, java.awt.BorderLayout.CENTER);

        pListeExperiences.addTab("Audit d'analyse spectrale", jPanel12);

        pExperiences.add(pListeExperiences, java.awt.BorderLayout.CENTER);

        pMenu.addTab("Expériences", pExperiences);

        jPanel3.setLayout(new java.awt.BorderLayout());

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setText("Liste des documents");
        jPanel3.add(jLabel2, java.awt.BorderLayout.NORTH);

        jScrollPane1.setViewportView(lCorpus);

        jPanel3.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        pRechercheCitations.setLeftComponent(jPanel3);

        jPanel4.setLayout(new java.awt.BorderLayout());

        jPanel5.setLayout(new java.awt.GridLayout(5, 3));

        bChoixTexteCite.setText("Choisir comme texte source");
        bChoixTexteCite.setEnabled(false);
        bChoixTexteCite.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChoixTexteCiteActionPerformed(evt);
            }
        });
        jPanel5.add(bChoixTexteCite);

        lChoixTexteCite.setText("Recherche de citations de : ");
        jPanel5.add(lChoixTexteCite);
        jPanel5.add(jPanel9);

        bChoixTexteCiteur.setText("Choisir comme texte citeur");
        bChoixTexteCiteur.setEnabled(false);
        bChoixTexteCiteur.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bChoixTexteCiteurActionPerformed(evt);
            }
        });
        jPanel5.add(bChoixTexteCiteur);

        lChoixTexteCiteur.setText("dans : ");
        jPanel5.add(lChoixTexteCiteur);
        jPanel5.add(jPanel10);

        jLabel3.setText("Recherche littérale avec une fenêtre de : ");
        jPanel5.add(jLabel3);

        tFenetreLitteral.setColumns(2);
        tFenetreLitteral.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        tFenetreLitteral.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tFenetreLitteral.setText("4");
        jPanel5.add(tFenetreLitteral);

        bLancerRechercheLitterale.setText("C'est parti !");
        bLancerRechercheLitterale.setEnabled(false);
        bLancerRechercheLitterale.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLancerRechercheLitteraleActionPerformed(evt);
            }
        });
        jPanel5.add(bLancerRechercheLitterale);

        jLabel6.setText("Recherche par voisinage (avec lemmatisation) avec une fenêtre de : ");
        jPanel5.add(jLabel6);

        tFenetreVoisinage.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        tFenetreVoisinage.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tFenetreVoisinage.setText("5");
        jPanel5.add(tFenetreVoisinage);

        bLancerRechercheVoisinage.setText("C'est parti !");
        bLancerRechercheVoisinage.setEnabled(false);
        bLancerRechercheVoisinage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLancerRechercheVoisinageActionPerformed(evt);
            }
        });
        jPanel5.add(bLancerRechercheVoisinage);

        jLabel7.setText("Recherche par voisinage (sans lemmatisation) avec une fenêtre de : ");
        jPanel5.add(jLabel7);

        tFenetreVoisinage2.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        tFenetreVoisinage2.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        tFenetreVoisinage2.setText("5");
        tFenetreVoisinage2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tFenetreVoisinage2ActionPerformed(evt);
            }
        });
        jPanel5.add(tFenetreVoisinage2);

        bLancerRechercheVoisinage2.setText("C'est parti !");
        bLancerRechercheVoisinage2.setEnabled(false);
        bLancerRechercheVoisinage2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLancerRechercheVoisinage2ActionPerformed(evt);
            }
        });
        jPanel5.add(bLancerRechercheVoisinage2);

        jPanel4.add(jPanel5, java.awt.BorderLayout.PAGE_START);

        jScrollPane5.setViewportView(tResultatRechercheCitations);

        jPanel4.add(jScrollPane5, java.awt.BorderLayout.CENTER);

        pRechercheCitations.setRightComponent(jPanel4);

        pMenu.addTab("(obsolète)", pRechercheCitations);

        getContentPane().add(pMenu, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void bChargerCSVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChargerCSVActionPerformed
        // TODO add your handling code here:
        /*JFileChooser loader = new JFileChooser();
        if(loader.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            final File toLoad = loader.getSelectedFile();
            lStatut.setText("Lecture en cours");
            tTexte.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        docActuel = ImportFichier.importBibleTSV(toLoad);
                        lStatut.setText("Test de charge en cours");
                        String s = docActuel.getTexteComplet();
                        lStatut.setText("Affichage en cours");
                        tTexte.setText(s);
                        tCaracteresLus.setText(docActuel.getListeCaracteres());
                        lStatut.setText(s.length() + " caractères");
                    } catch(IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        }*/
    }//GEN-LAST:event_bChargerCSVActionPerformed

    private void bSaveXMLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bSaveXMLActionPerformed
        // TODO add your handling code here:
        try {
            final File toSave = Demandes.demandeFichierDestination("Veuillez choisir un fichier de destination.");
            lStatut.setText("Export en cours");
            new Thread() {
                @Override
                public void run() {
                    try {
                        ExportFichier.exportXML(docActuel, toSave);
                        lStatut.setText("Le texte lu : ");
                    } catch(IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    } catch(IllegalArgumentException iae) {
                        if(iae.getCause() != null) {
                            lStatut.setText(iae.getClass() + " : " + iae.getMessage() + " (" + iae.getCause().getMessage()+")");
                        } else {
                            lStatut.setText(iae.getClass() + " : " + iae.getMessage());
                        }
                    }
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bSaveXMLActionPerformed

    private void bChargerXMLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChargerXMLActionPerformed
        try {
            final File toLoad = Demandes.demandeFichier("Veuillez choisir un fichier xml issu du logiciel.");
            lStatut.setText("Lecture en cours");
            tTexte.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        docActuel = ImportFichier.importUnicodeXML(toLoad);
                        lStatut.setText("Test de charge en cours");
                        String s = docActuel.getTexteComplet();
                        lStatut.setText("Affichage en cours");
                        tTexte.setText(s);
                        tCaracteresLus.setText(docActuel.getListeCaracteres());
                        lStatut.setText(s.length() + " caractères");
                    } catch(IOException | DOMCreationFailureException | IllegalArgumentException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bChargerXMLActionPerformed

    private void bTrouveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bTrouveActionPerformed
        // TODO add your handling code here:
        lTrouve.setText("En cours de recherche");
        new Thread() {
            @Override
            public void run() {
                long depart = System.currentTimeMillis();
                Pattern aTrouver = Pattern.compile(tTrouve.getText());
                Matcher chercheur = aTrouver.matcher(tTexte.getText());
                int trouvailles = 0;
                while(chercheur.find()) {
                    trouvailles ++;
                }
                int ms = (int)(System.currentTimeMillis() - depart);
                if(trouvailles == 0) {
                    lTrouve.setText("Ce texte n'a pas été retrouvé (temps : " + ms + " ms).");
                } else {
                    lTrouve.setText("Ce texte a été trouvé "+trouvailles+" fois (temps : " + ms + " ms).");
                }
            }
        }.start();
    }//GEN-LAST:event_bTrouveActionPerformed

    private void bChargerRTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChargerRTFActionPerformed
        // TODO add your handling code here:
        try {
            final File toLoad = Demandes.demandeFichier("Veuillez choisir un fichier rtf issu du TLG.");
            lStatut.setText("Lecture en cours");
            tTexte.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        docActuel = ImportFichier.importPatristiqueRTF(toLoad);
                        lStatut.setText("Test de charge en cours");
                        String s = docActuel.getTexteComplet();
                        lStatut.setText("Affichage en cours");
                        tTexte.setText(s);
                        tCaracteresLus.setText(docActuel.getListeCaracteres());
                        lStatut.setText(s.length() + " caractères");
                    } catch(IOException | BadLocationException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bChargerRTFActionPerformed

    private void bAjoutTestActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bAjoutTestActionPerformed
        // TODO add your handling code here:
        if(docActuel != null) {
            new Thread() {
                @Override
                public void run() {
                    corpus.addDocument(docActuel);
                    docActuel = null;
                    tTexte.setText("");
                    lStatut.setText("C'est envoyé");
                    DefaultListModel<Passage> model = new DefaultListModel<>();
                    for(int i=0; i<corpus.getDocuments().length; i++) {
                        model.addElement(corpus.getDocuments()[i]);
                    }
                    lCorpus.setModel(model);
                }
            }.start();
        }
    }//GEN-LAST:event_bAjoutTestActionPerformed

    private void bChargerRTFMasseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChargerRTFMasseActionPerformed
        // TODO add your handling code here:
        try {
            final File[] toMassLoad = Demandes.demandeFichiers("Veuillez choisir des fichiers rtf issus du TLG.");
            lStatut.setText("Lecture en cours");
            tTexte.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        for(int n=0; n<toMassLoad.length; n++) {
                            lStatut.setText("Lecture en cours (document "+(n+1)+"/"+toMassLoad.length+")");
                            docActuel = ImportFichier.importPatristiqueRTF(toMassLoad[n]);
                            corpus.addDocument(docActuel);
                            docActuel = null;
                        }
                        tTexte.setText(corpus.getTexteComplet());
                        tCaracteresLus.setText(corpus.getListeCaracteres());
                        lStatut.setText("Tout est chargé");
                        DefaultListModel<Passage> model = new DefaultListModel<>();
                        for(int i=0; i<corpus.getDocuments().length; i++) {
                            model.addElement(corpus.getDocuments()[i]);
                        }
                        lCorpus.setModel(model);
                    } catch(IOException | BadLocationException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bChargerRTFMasseActionPerformed

    private void bChoixTexteCiteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChoixTexteCiteActionPerformed
        // TODO add your handling code here:
        source = (Passage)lCorpus.getSelectedValue();
        lChoixTexteCite.setText("Recherches de citations de : "+source.getTitre());
    }//GEN-LAST:event_bChoixTexteCiteActionPerformed

    private void bChoixTexteCiteurActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChoixTexteCiteurActionPerformed
        // TODO add your handling code here:
        citeur = (Passage)lCorpus.getSelectedValue();
        lChoixTexteCiteur.setText("dans : "+citeur.getTitre());
    }//GEN-LAST:event_bChoixTexteCiteurActionPerformed

    private final Timer timerLitteral = new Timer(1000, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent ae) {
            tResultatRechercheCitations.setText("Recherche de citations en cours (" +
                    ((int)(rechercheLitterale.getAvancement()*100)) + "%).");
        }
    });
    
    private RechercheNLexes rechercheLitterale;
    
    private void bLancerRechercheLitteraleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLancerRechercheLitteraleActionPerformed
        // TODO add your handling code here:
        new Thread() {
            @Override
            public void run() {
                try {
                    tResultatRechercheCitations.setText("Recherche de citations en cours.");
                    rechercheLitterale = new RechercheNLexes(
                            new PassageType(source, PassageType.PASSAGE_BIBLIQUE), 
                            new PassageType(citeur, PassageType.PASSAGE_PATRISTIQUE), 
                            OrdreStrict.getInstance(OrdreStrict.VERSETS), OrdreStrict.getInstance(OrdreStrict.MOTS));
                    timerLitteral.start();
                    rechercheLitterale.setTailleFenetre(Integer.parseInt(tFenetreLitteral.getText()));
                    Citation[] trouvailles = rechercheLitterale.chercheCitations();
                    String s = "";
                    for(Citation c : trouvailles) {
                        s += c.toString() + "\n";
                    }
                    timerLitteral.stop();
                    tResultatRechercheCitations.setText("Affichage en cours.");
                    tResultatRechercheCitations.setText(s);
                } catch (ListeStatistiqueNonInitialiseeException ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }//GEN-LAST:event_bLancerRechercheLitteraleActionPerformed

    private void bLemmatiserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLemmatiserActionPerformed
        // TODO add your handling code here:
        new Thread() {
            @Override
            public void run() {
                String[] mots = tMotsALemmatiser.getText().split(" ");
                String resultat = "";
                for(String s : mots) {
                    String lemme = Arrays.toString(Lemmatiseurs.getToutesFormesLemmatisees(s));
                    resultat += s + " -> " + lemme + "\n";
                }
                tReponseLemmatisation.setText(resultat);
            }
        }.start();
    }//GEN-LAST:event_bLemmatiserActionPerformed

    private void bChargeCADPTLGActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChargeCADPTLGActionPerformed
        // TODO add your handling code here:
        JFileChooser loader = new JFileChooser();
        if(loader.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            final File toLoad = loader.getSelectedFile();
            lStatut.setText("Lecture en cours");
            new Thread() {
                @Override
                public void run() {
                    try {
                        ImportFichier.importCorrespondanceCADPTLG(toLoad);
                        tTexte.setText(CorrespondanceCADPTLG.getInstance().toString());
                        lStatut.setText("Import terminé");
                    } catch (IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }

                }
            }.start();
        }
    }//GEN-LAST:event_bChargeCADPTLGActionPerformed

    private void bChargeJERLXXActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChargeJERLXXActionPerformed
        // TODO add your handling code here:
        JFileChooser loader = new JFileChooser();
        if(loader.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            final File toLoad = loader.getSelectedFile();
            lStatut.setText("Lecture en cours");
            new Thread() {
                @Override
                public void run() {
                    try {
                        ImportFichier.importCorrespondanceJERLXX(toLoad);
                        tTexte.setText(CorrespondanceJERLXX.getInstance().toString());
                        lStatut.setText("Import terminé");
                    } catch (IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        }
    }//GEN-LAST:event_bChargeJERLXXActionPerformed


    private final Timer timerParVoisinage = new Timer(1000, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent ae) {
            tResultatRechercheCitations.setText("Recherche de citations en cours (" +
                    ((int)(rechercheParVoisinage.getAvancement()*10000))/100.0 + "%).");
        }
    });
    
    private RechercheParVoisinage rechercheParVoisinage;
    
    private void bLancerRechercheVoisinageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLancerRechercheVoisinageActionPerformed
        // TODO add your handling code here:
        new Thread() {
            @Override
            public void run() {
                tResultatRechercheCitations.setText("Recherche de citations en cours.");
                rechercheParVoisinage = new RechercheParVoisinage(source, citeur);
                timerParVoisinage.start();
                Citation[] trouvailles = rechercheParVoisinage.chercheCitations(Integer.parseInt(tFenetreVoisinage.getText()));
                String s = "";
                for(Citation c : trouvailles) {
                    s += c.toString() + "\n";
                }
                timerParVoisinage.stop();
                System.err.println("fini !");
                tResultatRechercheCitations.setText("Affichage en cours.");
                tResultatRechercheCitations.setText(trouvailles.length + " résultats");
            }
        }.start();
    }//GEN-LAST:event_bLancerRechercheVoisinageActionPerformed

    private void tFenetreVoisinage2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tFenetreVoisinage2ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_tFenetreVoisinage2ActionPerformed


    private final Timer timerParVoisinage2 = new Timer(1000, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent ae) {
            tResultatRechercheCitations.setText("Recherche de citations en cours (" +
                    ((int)(rechercheParVoisinage2.getAvancement()*10000))/100.0 + "%).");
        }
    });
    
    private RechercheParVoisinage rechercheParVoisinage2;
    
    private void bLancerRechercheVoisinage2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLancerRechercheVoisinage2ActionPerformed
        // TODO add your handling code here:
        new Thread() {
            @Override
            public void run() {
                tResultatRechercheCitations.setText("Recherche de citations en cours.");
                rechercheParVoisinage2 = new RechercheParVoisinage(source, citeur);
                //rechercheParVoisinage2.setUsageLemmatisation(false);
                timerParVoisinage2.start();
                Citation[] trouvailles = rechercheParVoisinage2.chercheCitations(Integer.parseInt(tFenetreVoisinage.getText()));
                String s = "";
                for(Citation c : trouvailles) {
                    s += c.toString() + "\n";
                }
                timerParVoisinage2.stop();
                tResultatRechercheCitations.setText("Affichage en cours.");
                tResultatRechercheCitations.setText(s);
            }
        }.start();
    }//GEN-LAST:event_bLancerRechercheVoisinage2ActionPerformed

    private void bListerLemmesNonTrouvesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bListerLemmesNonTrouvesActionPerformed
        // TODO add your handling code here:
        JFileChooser saver = new JFileChooser();
        if(saver.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
            final File sauvegarde = saver.getSelectedFile();
            new Thread() {
                @Override
                public void run() {
                    try {
                        ExportFichier.exporteTableTermes(sauvegarde, Archimedes.getInstance().listeTermesSansLemme());
                    } catch (IOException ex) {
                        GestionnaireErreurs.getInstance().affiche("Erreur d'application", 
                            "<html><p>Nous n'avons pas réussi à produire le fichier demandé.</p>"
                            + "<p>Pour information, l'erreur est</p>"
                            + "<p>"+ex.getClass()+" : "+ex.getMessage()+"</p></html>");
                    }
                }
            }.start();
        }
    }//GEN-LAST:event_bListerLemmesNonTrouvesActionPerformed

    private void bChargerTXTActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChargerTXTActionPerformed
        // TODO add your handling code here:
        try {
            final File toLoad = Demandes.demandeFichier("Veuillez choisir un fichier txt issu de BibleWorks.");
            lStatut.setText("Lecture en cours");
            tTexte.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        docActuel = ImportFichier.importTexteOuMorphoTXT(toLoad);
                        lStatut.setText("Test de charge en cours");
                        String s = docActuel.getTexteComplet();
                        lStatut.setText("Affichage en cours");
                        tTexte.setText(s);
                        tCaracteresLus.setText(docActuel.getListeCaracteres());
                        lStatut.setText(s.length() + " caractères");
                    } catch(IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bChargerTXTActionPerformed

    private void bLemmatiserBibleWorksActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLemmatiserBibleWorksActionPerformed
        // TODO add your handling code here:
        try {
            final File texte = Demandes.demandeFichier("Veuillez choisir le fichier contenant le texte à lemmatiser.");
            final File lemmes = Demandes.demandeFichier("Veuillez choisir le fichier contenant les lemmes.");
            lStatut.setText("Lecture en cours");
            tTexte.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        ImportFichier.augmenteListeLemmesBibleWorks(texte, lemmes);
                        tLemmesStockes.setText("Archimedes : \n\n" + 
                            Archimedes.getInstance().getStats() + 
                            "\n\n\nBibleWorks : \n\n" + 
                            BibleWorks.getInstance().getStats());
                        lStatut.setText("Lecture terminée");
                    } catch(IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bLemmatiserBibleWorksActionPerformed

    private void bLancerTFIDFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLancerTFIDFActionPerformed
        // TODO add your handling code here:
        new Thread() {
            @Override
            public void run() {
                System.err.println("C'est parti !");
                tTFIDF.setText("C'est en route !");
                String rapport = "Terme brut\tFréquence\tFréquence documentaire\ttf.idf\n";
                Terme[] liste = corpus.getListeTermes();
                for(Terme t: liste) {
                    rapport += t.getExpression() + "\t" + 
                            Outils.getFrequenceTerme(t, corpus, Outils.TERMES_BRUTS) + "\t" + 
                            Outils.getFrequenceDocumentaire(t, corpus, Outils.TERMES_BRUTS) + "\t" + 
                            Outils.getTF_IDF(t, corpus, Outils.TERMES_BRUTS) + "\n";
                }
                rapport += "\n\n\n";
                rapport += "Terme normalisé\tFréquence\tFréquence documentaire\ttf.idf\n";
                Set<Terme> liste2 = new HashSet<>();
                for(Terme t: liste) {
                    liste2.add(t.getFormeNormale());
                }
                for(Terme t: liste2) {
                    rapport += t.getExpression() + "\t" + 
                            Outils.getFrequenceTerme(t, corpus, Outils.TERMES_NORMALISES) + "\t" + 
                            Outils.getFrequenceDocumentaire(t, corpus, Outils.TERMES_NORMALISES) + "\t" + 
                            Outils.getTF_IDF(t, corpus, Outils.TERMES_NORMALISES) + "\n";
                }
                rapport += "\n\n\n";
                rapport += "Lemme\tFréquence\tFréquence documentaire\ttf.idf\n";
                Set<Lemme> liste3 = new HashSet<>();
                for(Terme t: liste) {
                    liste3.add(t.getLemmePrincipal());
                }
                for(Terme t: liste3) {
                    rapport += t.getExpression() + "\t" + 
                            Outils.getFrequenceTerme(t, corpus, Outils.TERMES_LEMMATISES) + "\t" + 
                            Outils.getFrequenceDocumentaire(t, corpus, Outils.TERMES_LEMMATISES) + "\t" + 
                            Outils.getTF_IDF(t, corpus, Outils.TERMES_LEMMATISES) + "\n";
                }
                tTFIDF.setText(rapport);
            }
        }.start();
    }//GEN-LAST:event_bLancerTFIDFActionPerformed

    private void bListerNomsPropresActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bListerNomsPropresActionPerformed
        // TODO add your handling code here:
        JFileChooser loader = new JFileChooser();
        if(loader.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            final File morphologie = loader.getSelectedFile();
            lStatut.setText("Lecture en cours");
            tTexte.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        ImportFichier.augmenteListeNomsPropresBibleWorks(morphologie);
                        lStatut.setText("Lecture terminée");
                    } catch(IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        }
    }//GEN-LAST:event_bListerNomsPropresActionPerformed

    private void bEditionLemmatiseeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bEditionLemmatiseeActionPerformed
        // TODO add your handling code here:
        try {
            final File destination = Demandes.demandeFichierDestination("Veuillez choisir un fichier de destination.");
            lStatut.setText("Rédaction en cours");
            new Thread() {
                @Override
                public void run() {
                    try {
                        ExportFichier.exporteTexteAvecLemmatisation(docActuel, destination);
                        lStatut.setText("Rédaction terminée");
                    } catch(IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bEditionLemmatiseeActionPerformed

    private void bChargerExperienceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChargerExperienceActionPerformed
        // TODO add your handling code here:
        lStatut.setText("Lecture en cours");
        new Thread() {
            @Override
            public void run() {
                try {
                    ArrayList<Citation> xpCit;
                    ArrayList<Citation> xpCitSA;
                    // Charger la Bible
                    lStatut.setText("Lecture de la base en cours - texte biblique");
                    xpBible = new PassageType(ImportFichier.importBibleTexteOuMorphoTXT(new File("Bible.txt")), PassageType.PASSAGE_BIBLIQUE);
                    // Charger le Quis Dives
                    lStatut.setText("Lecture de la base en cours - texte patristique");
                    xpQuisDives = new PassageType(ImportFichier.importPatristiqueRTF(new File("QuisDives.rtf")), PassageType.PASSAGE_PATRISTIQUE);
                    // Charger le fichier de citations
                    lStatut.setText("Lecture de la base en cours - citations");
                    xpRefs = ImportFichier.importCitationsTSV(new File("Citations.txt"), true, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PATRISTIQUE);
                    xpRefsSA = ImportFichier.importCitationsTSV(new File("Citations.txt"), false, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PATRISTIQUE);
                    // Afficher le contenu des citations dans tCitationsTemoin
                    lStatut.setText("Analyse de la base en cours");
                    String rapport = "";
                    xpCit = new ArrayList<>();
                    for (int i=0; i<xpRefs.length; i++) {
                        lStatut.setText("Analyse en cours - citation " + (i+1) + "/" + xpRefs.length);
                        ReferencesDeCitation ref = xpRefs[i];
                        rapport += "Citation de " + ref.getCite().toString()
                                + " dans " + ref.getCiteur().toString() + " : \n";
                        Passage txtCite = xpBible.getPassage().rassemblePassage(ref.getCite());
                        Passage txtCiteur = xpQuisDives.getPassage().rassemblePassage(ref.getCiteur());
                        Citation cit = new Citation(txtCite, txtCiteur);
                        xpCit.add(cit);
                        rapport += "Termes bruts communs (tous / pas vides / pas usuels / pas récurrents)\n";
                        rapport += cit.getNbTermesCommuns(Citation.MODE_NORMAL, Citation.TOLERANCE_VIDES_USUELS_RECURRENTS_SIGNIFICATIFS) + " / "+
                                cit.getNbTermesCommuns(Citation.MODE_NORMAL, Citation.TOLERANCE_USUELS_RECURRENTS_SIGNIFICATIFS) + " / "+
                                cit.getNbTermesCommuns(Citation.MODE_NORMAL, Citation.TOLERANCE_RECURRENTS_SIGNIFICATIFS) + " / "+
                                cit.getNbTermesCommuns(Citation.MODE_NORMAL, Citation.TOLERANCE_SIGNIFICATIFS) + " \n";
                        rapport += "Termes normalisés communs (tous / pas vides / pas usuels / pas récurrents)\n";
                        rapport += cit.getNbTermesCommuns(Citation.MODE_NORMALISE, Citation.TOLERANCE_VIDES_USUELS_RECURRENTS_SIGNIFICATIFS) + " / "+
                                cit.getNbTermesCommuns(Citation.MODE_NORMALISE, Citation.TOLERANCE_USUELS_RECURRENTS_SIGNIFICATIFS) + " / "+
                                cit.getNbTermesCommuns(Citation.MODE_NORMALISE, Citation.TOLERANCE_RECURRENTS_SIGNIFICATIFS) + " / "+
                                cit.getNbTermesCommuns(Citation.MODE_NORMALISE, Citation.TOLERANCE_SIGNIFICATIFS) + " \n";
                        rapport += "Lemmes communs (tous / pas vides / pas usuels / pas récurrents)\n";
                        rapport += cit.getNbTermesCommuns(Citation.MODE_LEMMATISE, Citation.TOLERANCE_VIDES_USUELS_RECURRENTS_SIGNIFICATIFS) + " / "+
                                cit.getNbTermesCommuns(Citation.MODE_LEMMATISE, Citation.TOLERANCE_USUELS_RECURRENTS_SIGNIFICATIFS) + " / "+
                                cit.getNbTermesCommuns(Citation.MODE_LEMMATISE, Citation.TOLERANCE_RECURRENTS_SIGNIFICATIFS) + " / "+
                                cit.getNbTermesCommuns(Citation.MODE_LEMMATISE, Citation.TOLERANCE_SIGNIFICATIFS) + " \n";
                        rapport += "Texte consécutif commun\n";
                        rapport += cit.getTaillePlusGrandeChaineDeMotsCommune(Citation.MODE_NORMAL, false) + " termes / "+
                                cit.getTaillePlusGrandeChaineDeMotsCommune(Citation.MODE_NORMALISE, false) + " termes normalisés / "+
                                cit.getTaillePlusGrandeChaineDeMotsCommune(Citation.MODE_LEMMATISE, false) + " lemmes à la suite communs\n";
                        rapport += " -> Texte cité : \n" + new Texte(txtCite).getTexte() + "\n";
                        rapport += " -> Texte de la citation : \n" + new Texte(txtCiteur).getTexte() + "\n\n";
                    }
                    xpCitations = new Citation[xpCit.size()];
                    xpCit.toArray(xpCitations);
                    xpCitSA = new ArrayList<>();
                    for (int i=0; i<xpRefsSA.length; i++) {
                        ReferencesDeCitation ref = xpRefsSA[i];
                        Passage txtCite = xpBible.getPassage().rassemblePassage(ref.getCite());
                        Passage txtCiteur = xpQuisDives.getPassage().rassemblePassage(ref.getCiteur());
                        xpCitSA.add(new Citation(txtCite, txtCiteur));
                    }
                    xpCitationsSA = new Citation[xpCitSA.size()];
                    xpCitSA.toArray(xpCitationsSA);
                    
                    testSrc = ImportFichier.importTestTXT(new File("Bible - Test.txt"));
                    testCit = ImportFichier.importPatristiqueRTF(new File("QuisDives - Test.rtf"));
                    testRefs = ImportFichier.importCitationsTSV(new File("Citations - Test.txt"), true, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PATRISTIQUE);
                    testRefsSA = ImportFichier.importCitationsTSV(new File("Citations - Test.txt"), false, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PATRISTIQUE);
                    xpCit = new ArrayList<>();
                    for (int i=0; i<testRefs.length; i++) {
                        ReferencesDeCitation ref = testRefs[i];
                        Passage txtCite = testSrc.rassemblePassage(ref.getCite());
                        Passage txtCiteur = testCit.rassemblePassage(ref.getCiteur());
                        xpCit.add(new Citation(txtCite, txtCiteur));
                    }
                    testCitations = new Citation[xpCit.size()];
                    xpCit.toArray(testCitations);
                    xpCitSA = new ArrayList<>();
                    for (int i=0; i<testRefsSA.length; i++) {
                        ReferencesDeCitation ref = testRefsSA[i];
                        Passage txtCite = testSrc.rassemblePassage(ref.getCite());
                        Passage txtCiteur = testCit.rassemblePassage(ref.getCiteur());
                        xpCitSA.add(new Citation(txtCite, txtCiteur));
                    }
                    testCitationsSA = new Citation[xpCitSA.size()];
                    xpCitSA.toArray(testCitationsSA);
                    
                    lStatut.setText("Affichage en cours dans l'onglet 'Expériences'");
                    tCitationsTemoin.setText(rapport);
                    System.gc();
                    lStatut.setText("Lecture terminée.");
                } catch (IOException | BadLocationException |IllegalArgumentException ex) {
                    GestionnaireErreurs.getInstance().affiche("Impossible de lire la base d'expérience correctement",
                            ex.getClass() + " : " + ex.getMessage());
                }
            }
        }.start();
    }//GEN-LAST:event_bChargerExperienceActionPerformed

    private RechercheNLexes rechercheLitteraleNew;
    private final Timer timerRechercheLitteraleNew = new Timer(200, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent ae) {
            lXpLitteralRapport.setText("Recherche de citations en cours (" +
                    ((int)(rechercheLitteraleNew.getAvancement()*10000))/100.0 + "%).");
            lXpToutRapport.setText(lXpLitteralRapport.getText());
        }
    });
    
    private RechercheParVoisinage rechercheParVoisinageNew;
    private final Timer timerRechercheParVoisinageNew = new Timer(200, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent ae) {
            lXpVoisinageRapport.setText("Recherche de citations en cours (" +
                    ((int)(rechercheParVoisinageNew.getAvancement()*10000))/100.0 + "%).");
            lXpToutRapport.setText(lXpVoisinageRapport.getText());
        }
    });
    
    private Citation[] resultat;
    
    private void bXpLitteralLancerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bXpLitteralLancerActionPerformed
        // TODO add your handling code here:
        lXpLitteralRapport.setText("Recherche de citations en cours (0%)");
        final long tps0 = System.currentTimeMillis();
        rechercheLitteraleNew = new RechercheNLexes(xpBible, xpQuisDives, OrdreStrict.getInstance(OrdreStrict.VERSETS), OrdreStrict.getInstance(OrdreStrict.MOTS));
        rechercheLitteraleNew.setImportanceOrdreMots(cXpOrdre.isSelected()?
                Recherche.L_ORDRE_DES_MOTS_COMPTE:
                Recherche.L_ORDRE_DES_MOTS_NE_COMPTE_PAS);
        rechercheLitteraleNew.setFiltrageMotsVides(cXpMotsVides.isSelected()?
                Recherche.TEXTE_SANS_MOTS_VIDES:
                Recherche.TEXTE_AVEC_MOTS_VIDES);
        rechercheLitteraleNew.setTraitementTermes(
                cXpTrAucun.isSelected()?Recherche.TERMES_BRUTS:
                (cXpTrNorm.isSelected()?Recherche.TERMES_NORMALISES:
                Recherche.TERMES_LEMMATISES));
        rechercheLitteraleNew.setToleranceCorrespondance(
                cXpTolExact.isSelected()?Recherche.CORRESPONDANCE_STRICTE:
                (cXpTolSeuil1.isSelected()?Recherche.CORRESPONDANCE_SEUILLEE_EN_VALEUR:
                Recherche.CORRESPONDANCE_SEUILLEE_EN_POURCENTAGE), 
                Integer.parseInt(tXpLitteralSeuil.getText()));
                //Integer.parseInt(tXpLitteralParamN.getText()));
        timerRechercheLitteraleNew.start();
        new Thread() {
            @Override
            public void run() {
                try {
                    rechercheLitteraleNew.setTailleFenetre(Integer.parseInt(tXpLitteralParamN.getText()));
                    resultat = rechercheLitteraleNew.chercheCitations();
                    timerRechercheLitteraleNew.stop();
                    lXpLitteralRapport.setText("Analyse en cours");
                    String rapport = "";
                    for (int i=0; i<resultat.length; i++) {
                        rapport += "Citation de " + resultat[i].getCite().getSousPassages()[0].getReferenceInitialeDans(xpBible.getPassage()) 
                                + " dans " + resultat[i].getCiteur().getSousPassages()[0].getReferenceInitialeDans(xpQuisDives.getPassage()) + " : \n";
                        Passage txtCite = resultat[i].getCite();
                        Passage txtCiteur = resultat[i].getCiteur();
                        rapport += " -> Texte cité (" + txtCite.getNbSousPassages() +" mots) : \n" + new Texte(txtCite).getTexte() + "\n";
                        rapport += " -> Texte de la citation (" + txtCiteur.getNbSousPassages() +" mots) : \n" + new Texte(txtCiteur).getTexte() + "\n\n";
                    }
                    lXpLitteralRapport.setText("Affichage en cours");
                    tCitationsLitteral.setText(rapport);
                    
                    long tps = System.currentTimeMillis() - tps0;
                    tXpLitteralCpteRendu.setText("Résultats\n" +
                            resultat.length + " citations trouvées en "+
                            Temps.getTexte(tps)+
                            "\nMode indulgent (avec allusions) : précision " + 
                                ((int)(100.0*ComparateurCitations.getPrecision(resultat, xpCitations, 
                            ComparateurCitations.IDENTIQUE_SI_CHEVAUCHEMENT, ComparateurCitations.METRIQUES_EPUREES))) + 
                                "%, rappel " + 
                                ((int)(100.0*ComparateurCitations.getRappel(resultat, xpCitations, 
                            ComparateurCitations.IDENTIQUE_SI_CHEVAUCHEMENT, ComparateurCitations.METRIQUES_EPUREES))) + 
                                "%\nMode indulgent (sans allusions) : précision " + 
                                ((int)(100.0*ComparateurCitations.getPrecision(resultat, xpCitationsSA, 
                            ComparateurCitations.IDENTIQUE_SI_CHEVAUCHEMENT, ComparateurCitations.METRIQUES_EPUREES))) + 
                                "%, rappel " + 
                                ((int)(100.0*ComparateurCitations.getRappel(resultat, xpCitationsSA, 
                            ComparateurCitations.IDENTIQUE_SI_CHEVAUCHEMENT, ComparateurCitations.METRIQUES_EPUREES))) + 
                                "%\nMode exact (avec allusions) : précision " + 
                                ((int)(100.0*ComparateurCitations.getPrecision(resultat, xpCitations, 
                            ComparateurCitations.IDENTIQUE_SI_SUPERPOSITION, ComparateurCitations.METRIQUES_EPUREES))) + 
                                "%, rappel " + 
                                ((int)(100.0*ComparateurCitations.getRappel(resultat, xpCitations, 
                            ComparateurCitations.IDENTIQUE_SI_SUPERPOSITION, ComparateurCitations.METRIQUES_EPUREES))) + 
                                "%\n" + ComparateurCitations.getSpectreTxt(resultat, xpCitations, 
                            ComparateurCitations.IDENTIQUE_SI_CHEVAUCHEMENT, ComparateurCitations.METRIQUES_EPUREES));
                    System.gc();
                    lXpLitteralRapport.setText("Recherche terminée.");
                } catch (ListeStatistiqueNonInitialiseeException ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }//GEN-LAST:event_bXpLitteralLancerActionPerformed
     
    
    private void bXpToutLancerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bXpToutLancerActionPerformed
        // TODO add your handling code here:
        lXpToutRapport.setText("Lecture de la base en cours");
        new Thread() {
            @Override
            public void run() {
                long tps0;
                long tps;
                tCpteRenduToutesXP.setText("");
                AnalyseurSpectral analyseur = new AnalyseurSpectral();
                AnalyseurSSpace analyseur2 = new AnalyseurSSpace();
                try {
                    tps0 = System.currentTimeMillis();
                    ArrayList<Citation> xpCit;
                    ArrayList<Citation> xpCitSA;
                    boolean philon = (cbXPCorpus.getSelectedItem().toString().equals("Philon"));
                    // Charger la Bible
                    lXpToutRapport.setText("Lecture de la base en cours - texte biblique");
                    if(philon) {
                        xpBible = new PassageType(ImportFichier.importBibleTexteOuMorphoTXT(new File("Pentateuque - ordre JER.txt")), PassageType.PASSAGE_BIBLIQUE);
                    } else {
                        xpBible = new PassageType(ImportFichier.importBibleTexteOuMorphoTXT(new File("LXX et NTG.txt")), PassageType.PASSAGE_BIBLIQUE);
                    }
                    // Charger le Quis Dives
                    lXpToutRapport.setText("Lecture de la base en cours - texte patristique");
                    if(philon) {
                        xpQuisDives = new PassageType(ImportFichier.importPhilonTexteOuMorphoTXT(new File("Philon d'Alexandrie.txt")), PassageType.PASSAGE_PHILON);
                    } else {
                        xpQuisDives = new PassageType(ImportFichier.importPatristiqueRTF(new File("QuisDives.rtf")), PassageType.PASSAGE_PATRISTIQUE);
                    }
                    // Charger le fichier de citations
                    lXpToutRapport.setText("Lecture de la base en cours - citations");
                    if(philon) {
                        xpRefs = ImportFichier.importCitationsTSV(new File("CitationsPhilon.txt"), true, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PHILON);
                        xpRefsSA = ImportFichier.importCitationsTSV(new File("CitationsPhilon.txt"), false, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PHILON);
                    } else {
                        xpRefs = ImportFichier.importCitationsTSV(new File("Citations.txt"), true, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PATRISTIQUE);
                        xpRefsSA = ImportFichier.importCitationsTSV(new File("Citations.txt"), false, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PATRISTIQUE);
                    }
                    // Afficher le contenu des citations dans tCitationsTemoin
                    lXpToutRapport.setText("Analyse de la base en cours");
                    xpCit = new ArrayList<>();
                    for (int i=0; i<xpRefs.length; i++) {
                        ReferencesDeCitation ref = xpRefs[i];
                        Passage txtCite = xpBible.getPassage().rassemblePassage(ref.getCite());
                        Passage txtCiteur = xpQuisDives.getPassage().rassemblePassage(ref.getCiteur());
                        xpCit.add(new Citation(txtCite, txtCiteur));
                    }
                    xpCitations = new Citation[xpCit.size()];
                    xpCit.toArray(xpCitations);
                    xpCitSA = new ArrayList<>();
                    for (int i=0; i<xpRefsSA.length; i++) {
                        ReferencesDeCitation ref = xpRefsSA[i];
                        Passage txtCite = xpBible.getPassage().rassemblePassage(ref.getCite());
                        Passage txtCiteur = xpQuisDives.getPassage().rassemblePassage(ref.getCiteur());
                        xpCitSA.add(new Citation(txtCite, txtCiteur));
                    }
                    xpCitationsSA = new Citation[xpCitSA.size()];
                    xpCitSA.toArray(xpCitationsSA);
                    
                    lXpToutRapport.setText("Préparation de l'analyseur spectral");
                    File fichier = new File("blocs de mots.txt");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(fichier), "UTF-8"));
                    while(reader.ready()) {
                        String[] ligne = reader.readLine().split(" ");
                        Terme[] termes = new Terme[ligne.length];
                        for(int i=0; i<ligne.length; i++) {
                            termes[i] = Terme.cree(ligne[i]);
                        }
                        analyseur.addBlocDeMots(termes);
                    }
                    
                    lXpToutRapport.setText("Préparation de l'analyseur sémantique");
                    /*ArrayList<Terme[]> documents = new ArrayList<>();
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(fichier), "UTF-8"));
                    while(reader.ready()) {
                        String[] ligne = reader.readLine().split(" ");
                        Terme[] termes = new Terme[ligne.length];
                        for(int i=0; i<ligne.length; i++) {
                            termes[i] = Terme.cree(ligne[i]);
                        }
                        documents.add(termes);
                    }
                    analyseur2 = new AnalyseurSSpace(AnalyseurSSpace.LSA, documents);*/
                    /*lXpToutRapport.setText("Préparation des statistiques de lemmes vides");
                    LemmesStatistiquementVides.init();*/
                    
                    testSrc = ImportFichier.importTestTXT(new File("Bible - Test.txt"));
                    testCit = ImportFichier.importPatristiqueRTF(new File("QuisDives - Test.rtf"));
                    testRefs = ImportFichier.importCitationsTSV(new File("Citations - Test.txt"), true, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PATRISTIQUE);
                    testRefsSA = ImportFichier.importCitationsTSV(new File("Citations - Test.txt"), false, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PATRISTIQUE);
                    xpCit = new ArrayList<>();
                    for (int i=0; i<testRefs.length; i++) {
                        ReferencesDeCitation ref = testRefs[i];
                        Passage txtCite = testSrc.rassemblePassage(ref.getCite());
                        Passage txtCiteur = testCit.rassemblePassage(ref.getCiteur());
                        xpCit.add(new Citation(txtCite, txtCiteur));
                    }
                    testCitations = new Citation[xpCit.size()];
                    xpCit.toArray(testCitations);
                    xpCitSA = new ArrayList<>();
                    for (int i=0; i<testRefsSA.length; i++) {
                        ReferencesDeCitation ref = testRefsSA[i];
                        Passage txtCite = testSrc.rassemblePassage(ref.getCite());
                        Passage txtCiteur = testCit.rassemblePassage(ref.getCiteur());
                        xpCitSA.add(new Citation(txtCite, txtCiteur));
                    }
                    testCitationsSA = new Citation[xpCitSA.size()];
                    xpCitSA.toArray(testCitationsSA);
                    
                    System.gc();
                    lXpToutRapport.setText("Lecture de la base terminée.");
                    tps = System.currentTimeMillis() - tps0;
                    tCpteRenduToutesXP.setText(tCpteRenduToutesXP.getText()+"Base d'expérience lue en " + Temps.getTexte(tps) + ".\n\n");
                } catch(Exception e) {
                    tCpteRenduToutesXP.setText(tCpteRenduToutesXP.getText()+"Erreur\n"+e.getClass()+" : "+e.getMessage()+"\n"+
                            Arrays.toString(e.getStackTrace())+"\n");
                    e.printStackTrace();
                }
                
                try {
                    Experiences xp = new Experiences(tCpteRenduToutesXP, lXpToutRapport, tXPPrefixe.getText(), 
                            xpBible, xpQuisDives, xpCitations, xpCitationsSA, analyseur);
                    xp.run();
                } catch(Exception e) {
                    tCpteRenduToutesXP.setText(tCpteRenduToutesXP.getText()+"Erreur\n"+e.getClass()+" : "+e.getMessage()+"\n"+
                            Arrays.toString(e.getStackTrace())+"\n");
                    e.printStackTrace();
                }
            }
        }.start();
    }//GEN-LAST:event_bXpToutLancerActionPerformed

    private void cXpOrdreActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cXpOrdreActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_cXpOrdreActionPerformed

    private void bChargerTestActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChargerTestActionPerformed
        // TODO add your handling code here:
        try {
            final File toLoad = Demandes.demandeFichier("Veuillez choisir un fichier txt.");
            lStatut.setText("Lecture en cours");
            tTexte.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        docActuel = ImportFichier.importTestTXT(toLoad);
                        lStatut.setText("Test de charge en cours");
                        String s = docActuel.getTexteComplet();
                        lStatut.setText("Affichage en cours");
                        tTexte.setText(s);
                        tCaracteresLus.setText(docActuel.getListeCaracteres());
                        lStatut.setText(s.length() + " caractères");
                    } catch(IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bChargerTestActionPerformed

    private void bXpVoisinageLancerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bXpVoisinageLancerActionPerformed
        // TODO add your handling code here:
        lXpVoisinageRapport.setText("Recherche de citations en cours (0%)");
        final long tps0 = System.currentTimeMillis();
        rechercheParVoisinageNew = new RechercheParVoisinage(xpBible.getPassage(), xpQuisDives.getPassage());
        rechercheParVoisinageNew.setFiltrageMotsVides(cXpVMotsVides.isSelected()?
                Recherche.TEXTE_SANS_MOTS_VIDES:
                Recherche.TEXTE_AVEC_MOTS_VIDES);
        rechercheParVoisinageNew.setMultiCitation(cXpVMulticitation.isSelected()?
                Recherche.CITATIONS_VERS_PLUSIEURS_SOURCES:
                Recherche.CITATIONS_VERS_UNE_SEULE_SOURCE);
        rechercheParVoisinageNew.setTraitementTermes(
                cXpVTrAucun.isSelected()?Recherche.TERMES_BRUTS:
                (cXpVTrNorm.isSelected()?Recherche.TERMES_NORMALISES:
                Recherche.TERMES_LEMMATISES));
        timerRechercheParVoisinageNew.start();
        new Thread() {
            @Override
            public void run() {
                resultat = rechercheParVoisinageNew.chercheCitations(
                        Integer.parseInt(tXpVoisinageParamN.getText()));
                timerRechercheParVoisinageNew.stop();
                lXpVoisinageRapport.setText("Analyse en cours");
                String rapport = "";
                for (int i=0; i<resultat.length; i++) {
                    rapport += "Citation de " + resultat[i].getCite().getSousPassages()[0].getReferenceInitialeDans(xpBible.getPassage()) 
                            + " dans " + resultat[i].getCiteur().getSousPassages()[0].getReferenceInitialeDans(xpQuisDives.getPassage()) + " : \n";
                    Passage txtCite = resultat[i].getCite();
                    Passage txtCiteur = resultat[i].getCiteur();
                    rapport += " -> Texte cité (" + txtCite.getNbSousPassages() +" mots) : \n" + new Texte(txtCite).getTexte() + "\n";
                    rapport += " -> Texte de la citation (" + txtCiteur.getNbSousPassages() +" mots) : \n" + new Texte(txtCiteur).getTexte() + "\n\n";
                }
                lXpVoisinageRapport.setText("Affichage en cours");
                tCitationsVoisinage.setText(rapport);
                
                long tps = System.currentTimeMillis() - tps0;
                tXpVoisinageCpteRendu.setText("Résultats\n" +
                        resultat.length + " citations trouvées en "+
                        Temps.getTexte(tps)+
                        "\nMode indulgent (avec allusions) : précision " + 
                            ((int)(100.0*ComparateurCitations.getPrecision(resultat, xpCitations, 
                        ComparateurCitations.IDENTIQUE_SI_CHEVAUCHEMENT, ComparateurCitations.METRIQUES_EPUREES))) + 
                            "%, rappel " + 
                            ((int)(100.0*ComparateurCitations.getRappel(resultat, xpCitations, 
                        ComparateurCitations.IDENTIQUE_SI_CHEVAUCHEMENT, ComparateurCitations.METRIQUES_EPUREES))) + 
                            "%\nMode indulgent (sans allusions) : précision " + 
                            ((int)(100.0*ComparateurCitations.getPrecision(resultat, xpCitationsSA, 
                        ComparateurCitations.IDENTIQUE_SI_CHEVAUCHEMENT, ComparateurCitations.METRIQUES_EPUREES))) + 
                            "%, rappel " + 
                            ((int)(100.0*ComparateurCitations.getRappel(resultat, xpCitationsSA, 
                        ComparateurCitations.IDENTIQUE_SI_CHEVAUCHEMENT, ComparateurCitations.METRIQUES_EPUREES))) + 
                            "%\nMode exact (avec allusions) : précision " + 
                            ((int)(100.0*ComparateurCitations.getPrecision(resultat, xpCitations, 
                        ComparateurCitations.IDENTIQUE_SI_SUPERPOSITION, ComparateurCitations.METRIQUES_EPUREES))) + 
                            "%, rappel " + 
                            ((int)(100.0*ComparateurCitations.getRappel(resultat, xpCitations, 
                        ComparateurCitations.IDENTIQUE_SI_SUPERPOSITION, ComparateurCitations.METRIQUES_EPUREES))) + 
                            "%");
                System.gc();
                lXpVoisinageRapport.setText("Recherche terminée.");
            }
        }.start();
    }//GEN-LAST:event_bXpVoisinageLancerActionPerformed

    private void bStatsBaseXPActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bStatsBaseXPActionPerformed
        // TODO add your handling code here:
        JFileChooser saver = new JFileChooser();
        int ok = saver.showSaveDialog(tCitationsTemoin);
        if(ok == JFileChooser.CANCEL_OPTION) {
            return;
        }
        final File destination = saver.getSelectedFile();
        lStatut.setText("Lecture en cours");
        new Thread() {
            @Override
            public void run() {
                try {
                    // Charger la Bible
                    lStatut.setText("Lecture en cours - texte biblique");
                    xpBible = new PassageType(ImportFichier.importBibleTexteOuMorphoTXT(new File("Bible.txt")), PassageType.PASSAGE_BIBLIQUE);
                    // Charger le Quis Dives
                    lStatut.setText("Lecture en cours - texte patristique");
                    xpQuisDives = new PassageType(ImportFichier.importPatristiqueRTF(new File("QuisDives.rtf")), PassageType.PASSAGE_PATRISTIQUE);
                    // Charger le fichier de citations
                    lStatut.setText("Lecture en cours - citations");
                    xpRefs = ImportFichier.importCitationsTSV(new File("Citations.txt"), true, PassageType.PASSAGE_BIBLIQUE, PassageType.PASSAGE_PATRISTIQUE);
                    // Afficher le contenu des citations dans tCitationsTemoin
                    lStatut.setText("Analyse en cours");
                    ArrayList<Citation> xpCit = new ArrayList<>();
                    for (int i=0; i<xpRefs.length; i++) {
                        lStatut.setText("Analyse en cours - citation " + (i+1) + "/" + xpRefs.length);
                        ReferencesDeCitation ref = xpRefs[i];
                        Passage txtCite = xpBible.getPassage().rassemblePassage(ref.getCite());
                        Passage txtCiteur = xpQuisDives.getPassage().rassemblePassage(ref.getCiteur());
                        Citation cit = new Citation(txtCite, txtCiteur);
                        xpCit.add(cit);
                    }
                    xpCitations = new Citation[xpCit.size()];
                    xpCit.toArray(xpCitations);

                    lStatut.setText("Export en cours");
                    ExportFichier.exporteStatsCitations(xpCitations, xpRefs, destination);
                    System.gc();
                    lStatut.setText("Lecture terminée.");
                } catch (IOException | BadLocationException |IllegalArgumentException ex) {
                    GestionnaireErreurs.getInstance().affiche("Impossible de lire la base d'expérience correctement ou d'exporter",
                            ex.getClass() + " : " + ex.getMessage());
                }
            }
        }.start();
    }//GEN-LAST:event_bStatsBaseXPActionPerformed

    
    private AnalyseurSpectral clusteriseur;
    private final Timer timerClusteriseur = new Timer(200, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent ae) {
            lStatut.setText("Clustering en cours (" +
                    ((int)(clusteriseur.getAvancement()*10000))/100.0 + "%).");
        }
    });
    
    private void bClusteringActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bClusteringActionPerformed
        // TODO add your handling code here:
        new Thread() {
            @Override
            public void run() {
                Passage[] liste = corpus.getDocuments();
                Map<Passage, Integer> traitements = new HashMap<>();
                for(int i=0; i<liste.length; i++) {
                    Passage p = liste[i];
                    lStatut.setText("Préparation du texte " + (i+1) + "/" + liste.length + ".");
                    if(new Texte(p).getVersets().length>0) {
                        traitements.put(p, AnalyseurSpectral.SEPARATEUR_VERSET);
                    } else {
                        traitements.put(p, AnalyseurSpectral.SEPARATEUR_PHRASE);
                    }
                }
                clusteriseur = new AnalyseurSpectral();
                timerClusteriseur.start();
                clusteriseur.addDocuments(traitements);
                timerClusteriseur.stop();
                lStatut.setText("C'est terminé.");
            }
        }.start();
    }//GEN-LAST:event_bClusteringActionPerformed

    private RechercheNLexes rechercheTC;
    private final Timer timerRechercheTC = new Timer(200, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent ae) {
            lStatut.setText("Analyse en cours (" +
                    rechercheTC.getStatut()+" - " +
                    ((int)(rechercheTC.getAvancement()*10000))/100.0 + "%).");
        }
    });
    private void bTableCorrespondanceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bTableCorrespondanceActionPerformed
        // TODO add your handling code here:
        new Thread() {
            @Override
            public void run() {
                try {
                    lStatut.setText("Lecture en cours - texte biblique");
                    PassageType xpBible1 = new PassageType(ImportFichier.importBibleTexteOuMorphoTXT(new File("Bible.txt")), PassageType.PASSAGE_BIBLIQUE);
                    PassageType xpBible2 = new PassageType(ImportFichier.importBibleTexteOuMorphoTXT(new File("Bible.txt")), PassageType.PASSAGE_BIBLIQUE);
                    rechercheTC = new RechercheNLexes(xpBible1, xpBible2, OrdreStrict.getInstance(OrdreStrict.VERSETS), OrdreStrict.getInstance(OrdreStrict.VERSETS));
                    rechercheTC.setFiltrageMotsVides(Recherche.TEXTE_SANS_MOTS_VIDES);
                    rechercheTC.setImportanceOrdreMots(Recherche.L_ORDRE_DES_MOTS_COMPTE);
                    rechercheTC.setTraitementTermes(Recherche.TERMES_LEMMATISES);
                    rechercheTC.setToleranceCorrespondance(Recherche.CORRESPONDANCE_STRICTE, 0);
                    rechercheTC.setSimilarite(Recherche.SIMILARITE_EXACTE, 0, 1.0);
                    rechercheTC.setSeuilFusion(50);
                    rechercheTC.setSourceEtCiteurIdentiques(true);
                    lStatut.setText("Analyse en cours");
                    timerRechercheTC.start();
                    rechercheTC.setTailleFenetre(5);
                    Citation[] citationsTrouvees = rechercheTC.chercheCitations();
                    timerRechercheTC.stop();
                    lStatut.setText("Regroupement des références");
                    Map<String, Set<String>> aExporter = new HashMap<>();
                    for(int i=0; i<citationsTrouvees.length; i++) {
                        String commun = new Texte(citationsTrouvees[i].getCiteur()).getTexte();
                        if(!aExporter.containsKey(commun)) {
                            Set<String> rr = new HashSet<>();
                            aExporter.put(commun, rr);
                        }
                        Passage src = citationsTrouvees[i].getCite();
                        Passage src0 = src.getSousPassages()[0];
                        Passage src1 = src.getSousPassages()[src.getNbSousPassages()-1];
                        String txtRefSource = References.toReference(
                                src0.getReferenceInitialeDans(xpBible1.getPassage()), 
                                src1.getReferenceInitialeDans(xpBible1.getPassage()), 
                                xpBible1.getType());
                        aExporter.get(commun).add(txtRefSource);

                        Passage cit = citationsTrouvees[i].getCiteur();
                        Passage cit0 = cit.getSousPassages()[0];
                        Passage cit1 = cit.getSousPassages()[cit.getNbSousPassages()-1];
                        String txtRefCiteur = References.toReference(
                                cit0.getReferenceInitialeDans(xpBible2.getPassage()), 
                                cit1.getReferenceInitialeDans(xpBible2.getPassage()), 
                                xpBible2.getType());
                        aExporter.get(commun).add(txtRefCiteur);
                    }
                    
                    lStatut.setText("Export en cours");
                    ExportFichier.exporteCorrespondanceInterne(aExporter, new File("TableCorrespondance.txt"));
                    lStatut.setText("Terminé, "+citationsTrouvees.length+" citations entrées");
                } catch (ListeStatistiqueNonInitialiseeException ex) {
                    ex.printStackTrace();
                } catch (IOException | IllegalArgumentException ex) {
                    ex.printStackTrace();
                    GestionnaireErreurs.getInstance().affiche("Impossible de lire le texte biblique correctement.",
                            ex.getClass() + " : " + ex.getMessage());
                }
            }
        }.start();
        
    }//GEN-LAST:event_bTableCorrespondanceActionPerformed

    private void bListeTermesFrqActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bListeTermesFrqActionPerformed
        // TODO add your handling code here:
        new Thread() {
            @Override
            public void run() {
                try {
                    lStatut.setText("Lecture en cours - texte biblique");
                    Passage bible = ImportFichier.importBibleTexteOuMorphoTXT(new File("Bible.txt"));
                    Texte tBible = new Texte(bible);
                    lStatut.setText("Récupérations des lemmes les plus fréquents");
                    Map<String, Integer> lesPlusFrequents1 = tBible.getSuitesDeLemmesLesPlusFrequentes(1, 1000, true);
                    ExportFichier.exporteTableFrequences(new File("Frequence1.txt"), lesPlusFrequents1);
                    lStatut.setText("Récupérations des suites de 2 lemmes les plus fréquentes");
                    Map<String, Integer> lesPlusFrequents2 = tBible.getSuitesDeLemmesLesPlusFrequentes(2, 1000, true);
                    ExportFichier.exporteTableFrequences(new File("Frequence2.txt"), lesPlusFrequents2);
                    lStatut.setText("Récupérations des suites de 3 lemmes les plus fréquentes");
                    Map<String, Integer> lesPlusFrequents3 = tBible.getSuitesDeLemmesLesPlusFrequentes(3, 1000, true);
                    ExportFichier.exporteTableFrequences(new File("Frequence3.txt"), lesPlusFrequents3);
                    lStatut.setText("Récupérations des suites de 4 lemmes les plus fréquentes");
                    Map<String, Integer> lesPlusFrequents4 = tBible.getSuitesDeLemmesLesPlusFrequentes(4, 1000, true);
                    ExportFichier.exporteTableFrequences(new File("Frequence4.txt"), lesPlusFrequents4);
                    lStatut.setText("Récupérations des suites de 5 lemmes les plus fréquentes");
                    Map<String, Integer> lesPlusFrequents5 = tBible.getSuitesDeLemmesLesPlusFrequentes(5, 1000, true);
                    ExportFichier.exporteTableFrequences(new File("Frequence5.txt"), lesPlusFrequents5);
                    lStatut.setText("Terminé");
               } catch (IOException | IllegalArgumentException ex) {
                    ex.printStackTrace();
                    GestionnaireErreurs.getInstance().affiche("Impossible de lire le texte biblique correctement.",
                            ex.getClass() + " : " + ex.getMessage());
                }
            }
        }.start();
    }//GEN-LAST:event_bListeTermesFrqActionPerformed

    private void bLemmatiserFichierActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLemmatiserFichierActionPerformed
        // TODO add your handling code here:
        try {
            final File lemmes = Demandes.demandeFichier("Veuillez choisir un fichier contenant les termes et leurs lemmes.");
            lStatut.setText("Lecture en cours");
            tTexte.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        ImportFichier.augmenteListeLemmesTXT(lemmes);
                        tLemmesStockes.setText("Archimedes : \n\n" + 
                            Archimedes.getInstance().getStats() + 
                            "\n\n\nBibleWorks : \n\n" + 
                            BibleWorks.getInstance().getStats());
                        lStatut.setText("Lecture terminée");
                    } catch(IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bLemmatiserFichierActionPerformed

    private void bDedoublonnerLemmesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bDedoublonnerLemmesActionPerformed
        // TODO add your handling code here:
        lStatut.setText("Dédoublonnage en cours");
        new Thread() {
            @Override
            public void run() {
                SourcesChretiennes aDedoublonner = SourcesChretiennes.getInstance();
                aDedoublonner.dedoublonne();
                lAuditStatut.setText("Dédoublonnage terminé");
            }
        }.start();
    }//GEN-LAST:event_bDedoublonnerLemmesActionPerformed

    private AnalyseurSpectral analyseur;
    private AuditAnalyseurSpectral auditeur;
    private final Timer timerAuditAS = new Timer(200, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent ae) {
            lAuditStatut.setText(auditeur.getStatut()+" - " +
                    ((int)(auditeur.getAvancement()*10000))/100.0 + "%");
        }
    });
    private void bAuditLancerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bAuditLancerActionPerformed
        // TODO add your handling code here:
        new Thread() {
            @Override
            public void run() {
                tAuditResultat.setText("");
                int nbTermes = (Integer)(spAuditNbTermes.getValue());
                int traitement = cbAuditTraitement.getSelectedIndex();
                int termes = cbAuditTermesChoisis.getSelectedIndex();
                double seuil = (Double)(tfAuditSeuil.getValue());
                int distance = bcAuditDistance.getSelectedIndex();
                lAuditStatut.setText("Création de l'analyseur");
                try {
                    if(analyseur == null) {
                        analyseur = new AnalyseurSpectral();
                        File dir = new File("corpus");
                        dir.createNewFile();
                        if(dir.isDirectory()) {
                            File[] liste = dir.listFiles();
                            for(File doc: liste) {
                                String nom = doc.getName();
                                if(nom.endsWith(".txt")) {
                                    Passage pDoc = ImportFichier.importBibleTexteOuMorphoTXT(doc);
                                    if(nom.startsWith("v")) {
                                        analyseur.addDocument(pDoc, AnalyseurSpectral.SEPARATEUR_VERSET);
                                    } else { // startsWith("p")
                                        analyseur.addDocument(pDoc, AnalyseurSpectral.SEPARATEUR_PHRASE);
                                    }
                                } else if(nom.endsWith(".rtf")) {
                                    Passage pDoc = ImportFichier.importPatristiqueRTF(doc);
                                    if(nom.startsWith("v")) {
                                        analyseur.addDocument(pDoc, AnalyseurSpectral.SEPARATEUR_VERSET);
                                    } else { // startsWith("p")
                                        analyseur.addDocument(pDoc, AnalyseurSpectral.SEPARATEUR_PHRASE);
                                    }
                                }
                            }
                        } else {
                            throw new FileNotFoundException("pas de répertoire corpus");
                        }
                    }
                } catch(IOException | BadLocationException ex) {
                    tAuditResultat.setText(ex.getClass() + " : " + ex.getMessage());
                    lAuditStatut.setText("Erreur");
                }
                if(analyseur != null) {
                    lAuditStatut.setText("Audit");
                    timerAuditAS.start();
                    auditeur = new AuditAnalyseurSpectral(analyseur);
                    Map<Integer, Integer> clusters = auditeur.getRepartitionClusters(nbTermes, traitement, termes, seuil, distance);
                    Integer[] tailles = new Integer[clusters.keySet().size()];
                    clusters.keySet().toArray(tailles);
                    Arrays.sort(tailles);

                    String resultat = "Nombre de clusters suivant leur taille\n\n";
                    for(int i=0; i<tailles.length; i++) {
                        if(clusters.containsKey(i)) {
                            resultat += i + "\t" + clusters.get(i) + "\n";
                        }
                    }
                    tAuditResultat.setText(resultat);
                    timerAuditAS.stop();
                    lAuditStatut.setText("Audit terminé");
                }  
            }
        }.start();
    }//GEN-LAST:event_bAuditLancerActionPerformed

    private void tfAuditSeuilActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tfAuditSeuilActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_tfAuditSeuilActionPerformed

    private void bCopieBWDansSCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bCopieBWDansSCActionPerformed
        // TODO add your handling code here:
        lStatut.setText("Copie en cours");
        for(String forme: BibleWorks.getInstance().getListeFormes()) {
            for(String lemme: BibleWorks.getInstance().getFormesLemmatisees(forme)) {
                SourcesChretiennes.getInstance().addLemme(forme, lemme);
            }
        }
        SourcesChretiennes.getInstance().archive();
        lStatut.setText("Copie terminée");
    }//GEN-LAST:event_bCopieBWDansSCActionPerformed

    private void bLemmeDeLemmeEstLemmeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLemmeDeLemmeEstLemmeActionPerformed
        // TODO add your handling code here:
        lStatut.setText("Lemmatisation en cours");
        Perseus.getInstance().lemmatiseLemmes();
        BibleWorks.getInstance().lemmatiseLemmes();
        SourcesChretiennes.getInstance().lemmatiseLemmes();
        lStatut.setText("Lemmatisation terminée");
    }//GEN-LAST:event_bLemmeDeLemmeEstLemmeActionPerformed

    private void bChargerBibleTXTActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bChargerBibleTXTActionPerformed
        // TODO add your handling code here:
        try {
            final File toLoad = Demandes.demandeFichier("Veuillez choisir un fichier txt issu de BibleWorks contenant une bible.");
            lStatut.setText("Lecture en cours");
            tTexte.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        docActuel = ImportFichier.importBibleTexteOuMorphoTXT(toLoad);
                        lStatut.setText("Test de charge en cours");
                        String s = docActuel.getTexteComplet();
                        lStatut.setText("Affichage en cours");
                        tTexte.setText(s);
                        tCaracteresLus.setText(docActuel.getListeCaracteres());
                        lStatut.setText(s.length() + " caractères");
                    } catch(IOException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bChargerBibleTXTActionPerformed

    private void bFrequencesTermesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bFrequencesTermesActionPerformed
        // TODO add your handling code here:
        try {
            lStatut.setText("Lecture en cours");
            String[] ext = {"txt", "rtf"};
            String[] expl = {"Fichier bibleworks (*.txt)", "fichier TLG (*.rtf)"};
            final File[] toMassLoad = Demandes.demandeFichiers("Veuiller choisir des fichiers dont indexer les termes.", ext, expl);
            new Thread() {
                @Override
                public void run() {
                    for(int i=0; i<toMassLoad.length; i++) {
                        File f = toMassLoad[i];
                        lStatut.setText("Lecture en cours (" + (i+1) + "/" + toMassLoad.length + ")");
                        try {
                            Passage p;
                            if(f.getName().endsWith("txt")) {
                                p = ImportFichier.importTexteOuMorphoTXT(f);
                            } else {
                                p = ImportFichier.importPatristiqueRTF(f);
                            }
                            Terme[] termes = new Texte(p).getContenu();
                            Map<Terme, Integer> occurrences = new HashMap<>();
                            for(Terme terme: termes) {
                                if(!occurrences.containsKey(terme)) {
                                    occurrences.put(terme, 0);
                                }
                                occurrences.put(terme, occurrences.get(terme) + 1);
                            }
                            Frequences.getInstance().addDocument(f.getName(), occurrences);
                        }catch(IOException|BadLocationException ioe) {
                            lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                        }
                    }
                    lStatut.setText("Ecriture en cours");
                    Frequences.getInstance().archive();
                    lStatut.setText("Alimentation terminée");
                }
            }.start();
        } catch(InteractionRefuseeException ire) {
            
        }
    }//GEN-LAST:event_bFrequencesTermesActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        try {
            File srcBC = Demandes.demandeFichier("Veuillez préciser le fichier contenant le tableau de lemmes en BetaCode",
                    new String[]{"txt"}, new String[]{"texte séparateur tabulation"});
            lStatut.setText("Ecriture en cours");
            ImportFichier.importLemmesPerseusEnBetaCode(srcBC);
            lStatut.setText("Alimentation terminée");
        } catch (InteractionRefuseeException ex) {
            
        } catch(IOException ioe) {
            lStatut.setText(ioe.getMessage());
        }
    }//GEN-LAST:event_jButton1ActionPerformed

    private void bBlocsMotsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bBlocsMotsActionPerformed
        // TODO add your handling code here:
        new Thread() {
            @Override
            public void run() {
                try {
                    File[] aLire = Demandes.demandeFichiers("Veuillez choisir les fichiers à lire", 
                            new String[]{"txt", "rtf"}, new String[]{"BibleWorks", "TLG"});
                    File aAlimenter = new File("blocs de mots.txt");
                    aAlimenter.createNewFile();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(aAlimenter, true), "UTF-8"));
                    for(File f: aLire) {
                        lStatut.setText("Lecture en cours (" + f.getName() + ")");
                        Passage txt;
                        if(f.getName().endsWith("txt")) {
                            txt = ImportFichier.importTexteOuMorphoTXT(f);
                        } else {
                            txt = ImportFichier.importPatristiqueRTF(f);
                        }
                        lStatut.setText("Ecriture en cours(" + f.getName() + ")");
                        Passage[] mots = txt.getAllMotsNonVides();
                        for(int i=0; i<mots.length; i++) {
                            writer.write(mots[i].getContenu().getExpression());
                            if(i%10==9) {
                                writer.write("\n");
                            } else {
                                writer.write(" ");
                            }
                        }
                        writer.write("\n");
                        writer.flush();
                    }
                    lStatut.setText("Terminé");
                } catch (InteractionRefuseeException ex) {

                } catch(Exception ioe) {
                    lStatut.setText(ioe.getMessage());
                }
            }
        }.start();
    }//GEN-LAST:event_bBlocsMotsActionPerformed

    private void generationNLexesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_generationNLexesActionPerformed
        // TODO add your handling code here:
        lStatut.setText("Lecture de la base en cours");
        new Thread() {
            @Override
            public void run() {
                try {
                    int n = Demandes.demandeEntier("Génération de n-lexes avec n=?");
                    int traitement = Demandes.demandeEntier("Traitement à effectuer ? (0 : aucun, 1 : normalisation, 2 : lemmatisation)");
                    boolean avecMotsVides = Demandes.demandeOuiNon("Avec les mots vides ?");
                    
                    // Charger la Bible
                    lStatut.setText("Lecture de la base en cours - texte biblique");
                    xpBible = new PassageType(ImportFichier.importBibleTexteOuMorphoTXT(new File("Bible.txt")), PassageType.PASSAGE_BIBLIQUE);
                    // Charger le Quis Dives
                    lStatut.setText("Lecture de la base en cours - texte patristique");
                    xpQuisDives = new PassageType(ImportFichier.importPatristiqueRTF(new File("QuisDives.rtf")), PassageType.PASSAGE_PATRISTIQUE);
                    
                    lStatut.setText("Génération des fichiers");
                    File fichier = new File("nLexesBible.txt");
                    fichier.createNewFile();
                    ExportFichier.exporteNLexes(fichier, xpBible, n, traitement, avecMotsVides);
                    fichier = new File("nLexesQuisDives.txt");
                    fichier.createNewFile();
                    ExportFichier.exporteNLexes(fichier, xpQuisDives, n, traitement, avecMotsVides);
                    
                    System.gc();
                    lStatut.setText("Lecture de la base terminée.");
                } catch(Exception e) {
                    lStatut.setText(lStatut.getText()+"Erreur\n"+e.getClass()+" : "+e.getMessage()+"\n"+
                            Arrays.toString(e.getStackTrace())+"\n");
                }
            }
        }.start();
    }//GEN-LAST:event_generationNLexesActionPerformed

    private void bLemmesParFrequenceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLemmesParFrequenceActionPerformed
        // TODO add your handling code here:
        lStatut.setText("Edition en cours");
        new Thread() {
            @Override
            public void run() {
                try {
                    int limite = Demandes.demandeEntier("Combien de documents manquants au max ?");
                    File fichier = Demandes.demandeFichierDestination("Nom du fichier de destination ?");

                    Map<Terme, Integer> df = new HashMap<>();

                    for(Terme t: Frequences.getInstance().getTermes()) {
                        Lemme l = t.getLemmePrincipal();
                        if(!df.containsKey(l)) {
                            df.put(l, 0);
                        }
                        df.put(l, Math.max(0, df.get(l) + Frequences.getInstance().getNbDocuments(t)));
                    }
                    
                    Map<Integer, Set<Terme>> listes = new HashMap<>();
                    for(int i=0; i<=limite; i++) {
                        listes.put(i, new HashSet<Terme>());
                    }
                    for(Terme t: df.keySet()) {
                        int manquants = Frequences.getInstance().getDocuments().length - df.get(t);
                        if(manquants <= limite) {
                            listes.get(manquants).add(t);
                        }
                    }

                    ExportFichier.exporteFrequencesTermes(fichier, listes, limite);
                    lStatut.setText("Edition teminée");
                } catch(InteractionRefuseeException ire) {

                } catch(Exception e) {
                    lStatut.setText(lStatut.getText()+"Erreur\n"+e.getClass()+" : "+e.getMessage()+"\n"+
                            Arrays.toString(e.getStackTrace())+"\n");
                }
            }
        }.start();
    }//GEN-LAST:event_bLemmesParFrequenceActionPerformed

    private void bStatsLemmatiseursActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bStatsLemmatiseursActionPerformed
        // TODO add your handling code here:
        final File fb;
        final File fc;
        final File fp;
        final File fd;
        try {
            fb = Demandes.demandeFichier("Liste des formes de BibleWorks");
            fc = Demandes.demandeFichier("Liste des formes de Sources Chrétiennes");
            fp = Demandes.demandeFichier("Liste des formes de Perseus");
            fd = Demandes.demandeFichier("Liste des formes de Demandées");
        } catch(InteractionRefuseeException ire) {
            return;
        }
        lStatut.setText("Calcul en cours");
        new Thread() {
            @Override
            public void run() {
                try {
                    ArrayList<Terme> lb = new ArrayList<>(Arrays.asList(ImportFichier.importeListeFormes(fb)));
                    ArrayList<Terme> lc = new ArrayList<>(Arrays.asList(ImportFichier.importeListeFormes(fc)));
                    ArrayList<Terme> lp = new ArrayList<>(Arrays.asList(ImportFichier.importeListeFormes(fp)));
                    ArrayList<Terme> ld = new ArrayList<>(Arrays.asList(ImportFichier.importeListeFormes(fd)));

                    ArrayList<Terme> lt0 = new ArrayList<>();
                    lt0.addAll(lb);
                    lt0.addAll(lc);
                    lt0.addAll(lp);
                    lt0.addAll(ld);
                    
                    String s = "Liste BW : " + lb.size() + "\n";
                    s += "Liste SC : " + lc.size() + "\n";
                    s += "Liste P : " + lp.size() + "\n";
                    s += "Liste D : " + ld.size() + "\n";
                    s += "Total : " + lt0.size() + "\n";
                    Set<Terme> lt = new HashSet<>(lt0);
                    s += "Total sans doublons : " + lt.size() + "\n\n";

                    int tB = 0, tC = 0, tP = 0, tBC = 0, tBP = 0, tCP = 0, tBCP = 0;
                    int dB = 0, dC = 0, dP = 0, dBC = 0, dBP = 0, dCP = 0, dBCP = 0, dR = 0;
                    int i=0;
                    for(Terme t: lt) {
                        i++;
                        lStatut.setText("Calcul en cours (" + i + "/" + lt.size() + ")");
                        boolean b = lb.contains(t);
                        boolean c = lc.contains(t);
                        boolean p = lp.contains(t);
                        boolean d = ld.contains(t);

                        if(b && !c && !p) {
                            if(d) {
                                dB++;
                            }
                            tB++;
                        } else if(!b && c && !p) {
                            if(d) {
                                dC++;
                            }
                            tC++;
                        } else if(!b && !c && p) {
                            if(d) {
                                dP++;
                            }
                            tP++;
                        } else if(b && c && !p) {
                            if(d) {
                                dBC++;
                            }
                            tBC++;
                        } else if(b && !c && p) {
                            if(d) {
                                dBP++;
                            }
                            tBP++;
                        } else if(!b && c && p) {
                            if(d) {
                                dCP++;
                            }
                            tCP++;
                        } else if(b && c && p) {
                            if(d) {
                                dBCP++;
                            }
                            tBCP++;
                        } else {
                            if(d) {
                                dR++;
                            }
                        }
                        
                        tTexte.setText(s + "Liste des formes : \n\n"
                            + "Formes disponibles dans les lemmatiseurs \n"
                            + "B : " + tB + "\n"
                            + "C : " + tC + "\n"
                            + "P : " + tP + "\n"
                            + "B+C : " + tBC + "\n"
                            + "B+P : " + tBP + "\n"
                            + "C+P : " + tCP + "\n"
                            + "B+C+P : " + tBCP + "\n"
                            + "\n"
                            + "Formes demandées et leur disponibilité dans les lemmatiseurs \n"
                            + "- : " + dR + "\n"
                            + "B : " + dB + "\n"
                            + "C : " + dC + "\n"
                            + "P : " + dP + "\n"
                            + "B+C : " + dBC + "\n"
                            + "B+P : " + dBP + "\n"
                            + "C+P : " + dCP + "\n"
                            + "B+C+P : " + dBCP + "\n"
                            + "");
                    }
                    lStatut.setText("Calcul terminé");

                } catch(Exception e) {
                    lStatut.setText(lStatut.getText()+"Erreur\n"+e.getClass()+" : "+e.getMessage()+"\n"+
                                    Arrays.toString(e.getStackTrace())+"\n");
                }
            }
        }.start();
    }//GEN-LAST:event_bStatsLemmatiseursActionPerformed

    private void bGenereBaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bGenereBaseActionPerformed
        // TODO add your handling code here:
        lStatut.setText("Génération de la base en cours");
        try {
            File f = Demandes.demandeFichier("Fichier de la Bible (txt)");
            ExportFichier.exportBaseLemmes(f);
            lStatut.setText("Génération de la base terminée");
        } catch(InteractionRefuseeException ire) {
            return;
        } catch(IOException e) {
            lStatut.setText(lStatut.getText()+"Erreur\n"+e.getClass()+" : "+e.getMessage()+"\n"+
                                    Arrays.toString(e.getStackTrace())+"\n");
        }
    }//GEN-LAST:event_bGenereBaseActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FenetreDeveloppement.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                new FenetreDeveloppement().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bAjoutTest;
    private javax.swing.JButton bAuditLancer;
    private javax.swing.JButton bBlocsMots;
    private javax.swing.JButton bChargeCADPTLG;
    private javax.swing.JButton bChargeJERLXX;
    private javax.swing.JButton bChargerBibleTXT;
    private javax.swing.JButton bChargerCSV;
    private javax.swing.JButton bChargerExperience;
    private javax.swing.JButton bChargerRTF;
    private javax.swing.JButton bChargerRTFMasse;
    private javax.swing.JButton bChargerTXT;
    private javax.swing.JButton bChargerTest;
    private javax.swing.JButton bChargerXML;
    private javax.swing.JButton bChoixTexteCite;
    private javax.swing.JButton bChoixTexteCiteur;
    private javax.swing.JButton bClustering;
    private javax.swing.JButton bCopieBWDansSC;
    private javax.swing.JButton bDedoublonnerLemmes;
    private javax.swing.JButton bEditionLemmatisee;
    private javax.swing.JButton bFrequencesTermes;
    private javax.swing.JButton bGenereBase;
    private javax.swing.JButton bLancerRechercheLitterale;
    private javax.swing.JButton bLancerRechercheVoisinage;
    private javax.swing.JButton bLancerRechercheVoisinage2;
    private javax.swing.JButton bLancerTFIDF;
    private javax.swing.JButton bLemmatiser;
    private javax.swing.JButton bLemmatiserBibleWorks;
    private javax.swing.JButton bLemmatiserFichier;
    private javax.swing.JButton bLemmeDeLemmeEstLemme;
    private javax.swing.JButton bLemmesParFrequence;
    private javax.swing.JButton bListeTermesFrq;
    private javax.swing.JButton bListerLemmesNonTrouves;
    private javax.swing.JButton bListerNomsPropres;
    private javax.swing.JButton bSaveXML;
    private javax.swing.JButton bStatsBaseXP;
    private javax.swing.JButton bStatsLemmatiseurs;
    private javax.swing.JButton bTableCorrespondance;
    private javax.swing.JButton bTrouve;
    private javax.swing.JButton bXpLitteralLancer;
    private javax.swing.JButton bXpToutLancer;
    private javax.swing.JButton bXpVoisinageLancer;
    private javax.swing.JComboBox bcAuditDistance;
    private javax.swing.ButtonGroup boutonsTolerance;
    private javax.swing.ButtonGroup boutonsTraitement;
    private javax.swing.ButtonGroup boutonsVTraitement;
    private javax.swing.JCheckBox cXpMotsVides;
    private javax.swing.JCheckBox cXpOrdre;
    private javax.swing.JRadioButton cXpTolExact;
    private javax.swing.JRadioButton cXpTolSeuil1;
    private javax.swing.JRadioButton cXpTolSeuil2;
    private javax.swing.JRadioButton cXpTrAucun;
    private javax.swing.JRadioButton cXpTrLemm;
    private javax.swing.JRadioButton cXpTrNorm;
    private javax.swing.JCheckBox cXpVMotsVides;
    private javax.swing.JCheckBox cXpVMulticitation;
    private javax.swing.JRadioButton cXpVTrAucun;
    private javax.swing.JRadioButton cXpVTrLemm;
    private javax.swing.JRadioButton cXpVTrNorm;
    private javax.swing.JComboBox cbAuditTermesChoisis;
    private javax.swing.JComboBox cbAuditTraitement;
    private javax.swing.JComboBox cbXPCorpus;
    private javax.swing.JButton generationNLexes;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanel15;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanel17;
    private javax.swing.JPanel jPanel18;
    private javax.swing.JPanel jPanel19;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel20;
    private javax.swing.JPanel jPanel21;
    private javax.swing.JPanel jPanel22;
    private javax.swing.JPanel jPanel23;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane10;
    private javax.swing.JScrollPane jScrollPane11;
    private javax.swing.JScrollPane jScrollPane12;
    private javax.swing.JScrollPane jScrollPane13;
    private javax.swing.JScrollPane jScrollPane14;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JScrollPane jScrollPane6;
    private javax.swing.JScrollPane jScrollPane7;
    private javax.swing.JScrollPane jScrollPane8;
    private javax.swing.JScrollPane jScrollPane9;
    private javax.swing.JLabel lAuditStatut;
    private javax.swing.JLabel lChoixTexteCite;
    private javax.swing.JLabel lChoixTexteCiteur;
    private javax.swing.JList lCorpus;
    private javax.swing.JLabel lMemoire;
    private javax.swing.JLabel lStatut;
    private javax.swing.JLabel lTrouve;
    private javax.swing.JLabel lXpLitteralRapport;
    private javax.swing.JLabel lXpToutRapport;
    private javax.swing.JLabel lXpVoisinageRapport;
    private javax.swing.JPanel pCaracteres;
    private javax.swing.JPanel pExperiences;
    private javax.swing.JPanel pLemmatisation;
    private javax.swing.JTabbedPane pListeExperiences;
    private javax.swing.JPanel pMain;
    private javax.swing.JTabbedPane pMenu;
    private javax.swing.JPanel pMenuLecture;
    private javax.swing.JSplitPane pRechercheCitations;
    private javax.swing.JPanel pStatsLemmatiseurs;
    private javax.swing.JPanel pStatut;
    private javax.swing.JPanel pTabLecture;
    private javax.swing.JPanel pTabStats;
    private javax.swing.JPanel pXpLitteral;
    private javax.swing.JPanel pXpLitteralEval;
    private javax.swing.JPanel pXpLitteralParams;
    private javax.swing.JPanel pXpTemoin;
    private javax.swing.JPanel pXpToutLancer;
    private javax.swing.JPanel pXpVoisinage;
    private javax.swing.JPanel pXpVoisinageEval;
    private javax.swing.JPanel pXpVoisinageParams;
    private javax.swing.JSpinner spAuditNbTermes;
    private javax.swing.JEditorPane tAuditResultat;
    private javax.swing.JTextArea tCaracteresLus;
    private javax.swing.JEditorPane tCitationsLitteral;
    private javax.swing.JEditorPane tCitationsTemoin;
    private javax.swing.JEditorPane tCitationsVoisinage;
    private javax.swing.JEditorPane tCpteRenduToutesXP;
    private javax.swing.JFormattedTextField tFenetreLitteral;
    private javax.swing.JFormattedTextField tFenetreVoisinage;
    private javax.swing.JFormattedTextField tFenetreVoisinage2;
    private javax.swing.JTextArea tLemmesStockes;
    private javax.swing.JTextField tMotsALemmatiser;
    private javax.swing.JEditorPane tReponseLemmatisation;
    private javax.swing.JEditorPane tResultatRechercheCitations;
    private javax.swing.JEditorPane tTFIDF;
    private javax.swing.JEditorPane tTexte;
    private javax.swing.JTextField tTrouve;
    private javax.swing.JTextField tXPPrefixe;
    private javax.swing.JTextArea tXpLitteralCpteRendu;
    private javax.swing.JFormattedTextField tXpLitteralParamN;
    private javax.swing.JFormattedTextField tXpLitteralSeuil;
    private javax.swing.JTextArea tXpVoisinageCpteRendu;
    private javax.swing.JFormattedTextField tXpVoisinageParamN;
    private javax.swing.JFormattedTextField tfAuditSeuil;
    // End of variables declaration//GEN-END:variables
}
