/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.ihm;

import javax.swing.JOptionPane;
import fr.cnrs.liris.drim.grt.proc.base.Bases;
/**
 *
 * @author Sam
 */
public class FenetreDemarrage extends javax.swing.JFrame {

    /**
     * Creates new form FenetreDemarrage
     */
    public FenetreDemarrage() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        cbChoixBase = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        jPanel6 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jPanel7 = new javax.swing.JPanel();
        tLoginLexis = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        tMdpLexis = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jPanel8 = new javax.swing.JPanel();
        tLoginBiblindex = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        tMdpBiblindex = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        bRecherche = new javax.swing.JButton();
        bLemma = new javax.swing.JButton();
        bCodec = new javax.swing.JButton();
        bDev = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Greek Reuse Toolkit");

        jPanel1.setLayout(new java.awt.GridLayout(1, 1, 10, 10));

        jLabel1.setText("<html><p>Bonjour. Vous avez décidé de travailler avec Greek Quotation Toolkit, une boîte à outils pour le traitement du grec <i>Koinè</i> développée dans le cadre du projet ANR Biblindex.</p><p>Dans quel domaine souhaitez-vous travailler aujourd'hui ?</p><p>Et, avant cela, où trouverons-nous les informations dont nous aurons besoin ?</p></html>");
        jLabel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel1.add(jLabel1);

        getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);

        jPanel2.setLayout(new java.awt.BorderLayout());

        jPanel4.setLayout(new java.awt.GridLayout(4, 1));

        jPanel5.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEADING));

        jLabel2.setText("Je souhaite utiliser, si besoin est, les informations lexicales données par");
        jPanel5.add(jLabel2);

        cbChoixBase.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "des fichiers sur mon poste", "une base sur mon poste", "la base du projet à la MOM" }));
        jPanel5.add(cbChoixBase);

        jLabel3.setText(".");
        jPanel5.add(jLabel3);

        jPanel4.add(jPanel5);

        jPanel6.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEADING));

        jLabel4.setText("Si je dois accéder à des bases de données, on va me demander des identifiants ; voici ceux que j'utiliserai :");
        jPanel6.add(jLabel4);

        jPanel4.add(jPanel6);

        jPanel7.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEADING));

        tLoginLexis.setColumns(12);
        tLoginLexis.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        tLoginLexis.setText("identifiant");
        jPanel7.add(tLoginLexis);

        jLabel5.setText(" et ");
        jPanel7.add(jLabel5);

        tMdpLexis.setColumns(12);
        tMdpLexis.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        tMdpLexis.setText("mot de passe");
        jPanel7.add(tMdpLexis);

        jLabel7.setText("pour la base Lexis et");
        jPanel7.add(jLabel7);

        jPanel4.add(jPanel7);

        jPanel8.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEADING));

        tLoginBiblindex.setColumns(12);
        tLoginBiblindex.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        tLoginBiblindex.setText("identifiant");
        jPanel8.add(tLoginBiblindex);

        jLabel8.setText(" et ");
        jPanel8.add(jLabel8);

        tMdpBiblindex.setColumns(12);
        tMdpBiblindex.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        tMdpBiblindex.setText("mot de passe");
        jPanel8.add(tMdpBiblindex);

        jLabel6.setText("pour la base Biblindex. Avec ces informations : ");
        jPanel8.add(jLabel6);

        jPanel4.add(jPanel8);

        jPanel2.add(jPanel4, java.awt.BorderLayout.NORTH);

        jPanel3.setLayout(new javax.swing.BoxLayout(jPanel3, javax.swing.BoxLayout.PAGE_AXIS));

        bRecherche.setText("<html><ul><li>Je souhaite travailler à la recherche de nouvelles citations, ou au raffinage de citations déjà délimitées <i>(nécessite l'accès aux bases Lexis et Biblindex ou aux fichiers du poste)</i>.</li></ul></html>");
        bRecherche.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        bRecherche.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRechercheActionPerformed(evt);
            }
        });
        jPanel3.add(bRecherche);

        bLemma.setText("<html><ul><li>Je souhaite travailler avec le lemmatiseur, ou l'améliorer <i>(nécessite l'accès à la base Lexis ou aux fichiers du poste)</i>.</li></ul></html>");
        bLemma.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        bLemma.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLemmaActionPerformed(evt);
            }
        });
        jPanel3.add(bLemma);

        bCodec.setText("<html><ul><li>Je souhaite visionner un texte, ou exporter un texte dans un nouveau format <i>(ne nécessite aucun accès particulier)</i>.</li></ul></html>");
        bCodec.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        bCodec.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bCodecActionPerformed(evt);
            }
        });
        jPanel3.add(bCodec);

        bDev.setText("<html><ul><li>Je souhaite travailler directement sur l'interface de développement <i>(nécessite l'accès aux bases Lexis et Biblindex ou aux fichiers du poste)</i>.</li></ul></html>");
        bDev.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        bDev.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bDevActionPerformed(evt);
            }
        });
        jPanel3.add(bDev);

        jPanel2.add(jPanel3, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void bCodecActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bCodecActionPerformed
        // TODO add your handling code here:
        if(valideIds(false, false)) {
            new FenetreCodec().setVisible(true);
            setVisible(false);
        }
    }//GEN-LAST:event_bCodecActionPerformed

    private void bLemmaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLemmaActionPerformed
        // TODO add your handling code here:
        if(valideIds(true, false)) {
            new FenetreLemmatiseur().setVisible(true);
            setVisible(false);
        }
    }//GEN-LAST:event_bLemmaActionPerformed

    private void bRechercheActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRechercheActionPerformed
        // TODO add your handling code here:
        if(valideIds(true, true)) {
            new FenetreRecherche().setVisible(true);
            setVisible(false);
        }
    }//GEN-LAST:event_bRechercheActionPerformed

    private void bDevActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bDevActionPerformed
        // TODO add your handling code here:
        if(valideIds(true, true)) {
            new FenetreDeveloppement().setVisible(true);
            setVisible(false);
        }
    }//GEN-LAST:event_bDevActionPerformed

    private boolean valideIds(boolean baseLexis, boolean baseBiblindex) {
        String choix = cbChoixBase.getSelectedItem().toString();
        String url;
        switch(choix) {
            case "des fichiers sur mon poste":
                Bases.setSansBase();
                break;
            case "une base sur mon poste":
                url = "127.0.0.1";
                Bases.setInfosLexis(url, "Lexis", tLoginLexis.getText(), tMdpLexis.getText());
                Bases.setInfosBiblindex(url, "Biblindex", tLoginBiblindex.getText(), tMdpBiblindex.getText());
                break;
            case "la base du projet à la MOM":
                url = "bddmom.mom.fr:3316";
                Bases.setInfosLexis(url, "Lexis", tLoginLexis.getText(), tMdpLexis.getText());
                Bases.setInfosBiblindex(url, "Biblindex", tLoginBiblindex.getText(), tMdpBiblindex.getText());
                break;
            default:
                Bases.setSansBase();
        }
        boolean resultat = true;
        if(Bases.utiliseBases() && baseLexis) {
            if(!Bases.getBaseLexis().testOK()) {
                JOptionPane.showMessageDialog(this, Bases.getBaseLexis().getErreurConnexion(), "Nous n'arrivons pas à nous connecter à la base Lexis.", JOptionPane.ERROR_MESSAGE);
                resultat = false;
            }
        }
        if(Bases.utiliseBases() && baseBiblindex) {
            if(!Bases.getBaseBiblindex().testOK()) {
                JOptionPane.showMessageDialog(this, Bases.getBaseBiblindex().getErreurConnexion(), "Nous n'arrivons pas à nous connecter à la base Biblindex.", JOptionPane.ERROR_MESSAGE);
                resultat = false;
            }
        }
        return resultat;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bCodec;
    private javax.swing.JButton bDev;
    private javax.swing.JButton bLemma;
    private javax.swing.JButton bRecherche;
    private javax.swing.JComboBox cbChoixBase;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JTextField tLoginBiblindex;
    private javax.swing.JTextField tLoginLexis;
    private javax.swing.JTextField tMdpBiblindex;
    private javax.swing.JTextField tMdpLexis;
    // End of variables declaration//GEN-END:variables
}
