/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.ihm;

import fr.cnrs.liris.drim.grt.ihm.exceptions.InteractionRefuseeException;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/**
 *
 * @author sgesche
 */
public class Demandes {
    private static JComponent contexteAffichage = null;
    
    public static void setContexteAffichage(JComponent contexte) {
        contexteAffichage = contexte;
    }
    
    public static String demandeTexte(String consigne) {
        return JOptionPane.showInputDialog(contexteAffichage, consigne, "");
    }
    
    public static boolean demandeOuiNon(String consigne) throws InteractionRefuseeException {
        return JOptionPane.showConfirmDialog(contexteAffichage, consigne, "", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION;
    }
    
    public static int demandeEntier(String consigne) throws InteractionRefuseeException {
        String resultat = demandeTexte(consigne);
        try {
            return Integer.parseInt(resultat);
        } catch(NumberFormatException nfe) {
            throw new InteractionRefuseeException(consigne, nfe);
        }
    }
    
    public static File demandeFichier(String consigne) throws InteractionRefuseeException {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle(consigne);
        int resultat = chooser.showOpenDialog(contexteAffichage);
        if(resultat == JFileChooser.APPROVE_OPTION) {
            return chooser.getSelectedFile();
        } else {
            throw new InteractionRefuseeException(consigne);
        }
    }
    
    public static File demandeFichierDestination(String consigne) throws InteractionRefuseeException {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle(consigne);
        int resultat = chooser.showSaveDialog(contexteAffichage);
        if(resultat == JFileChooser.APPROVE_OPTION) {
            return chooser.getSelectedFile();
        } else {
            throw new InteractionRefuseeException(consigne);
        }
    }
    
    public static File[] demandeFichiers(String consigne) throws InteractionRefuseeException {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(consigne);
        int resultat = chooser.showOpenDialog(contexteAffichage);
        if(resultat == JFileChooser.APPROVE_OPTION) {
            return chooser.getSelectedFiles();
        } else {
            throw new InteractionRefuseeException(consigne);
        }
    }
    
    public static File demandeFichier(String consigne, String[] extensions, String[] descriptions) throws InteractionRefuseeException {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle(consigne);
        chooser.setAcceptAllFileFilterUsed(false);
        for(int i=0; i<extensions.length; i++) {
            final String ext = extensions[i];
            final String desc = descriptions[i];
            FileFilter filtre = new FileFilter() {
                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith("." + ext) || f.isDirectory();
                }
                @Override
                public String getDescription() {
                    return desc;
                }
            };
            chooser.addChoosableFileFilter(filtre);
        }
        int resultat = chooser.showOpenDialog(contexteAffichage);
        if(resultat == JFileChooser.APPROVE_OPTION) {
            return chooser.getSelectedFile();
        } else {
            throw new InteractionRefuseeException(consigne);
        }
    }
    
    public static File[] demandeFichiers(String consigne, String[] extensions, String[] descriptions) throws InteractionRefuseeException {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setMultiSelectionEnabled(true);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(consigne);
        for(int i=0; i<extensions.length; i++) {
            final String ext = extensions[i];
            final String desc = descriptions[i];
            FileFilter filtre = new FileFilter() {
                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith("." + ext) || f.isDirectory();
                }
                @Override
                public String getDescription() {
                    return desc;
                }
            };
            chooser.addChoosableFileFilter(filtre);
        }
        int resultat = chooser.showOpenDialog(contexteAffichage);
        if(resultat == JFileChooser.APPROVE_OPTION) {
            return chooser.getSelectedFiles();
        } else {
            throw new InteractionRefuseeException(consigne);
        }
    }
    
}
