/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexFloatFFT;
import jnt.FFT.ComplexFloatFFT_Mixed;

public class RealFloat2DFFT_Even {
    int nrows;
    int ncols;
    int rowspan;
    ComplexFloatFFT rowFFT;
    ComplexFloatFFT colFFT;

    public RealFloat2DFFT_Even(int n, int n2) {
        this.nrows = n;
        this.ncols = n2;
        this.rowspan = n2 + 2;
        if (n2 % 2 != 0) {
            throw new Error("The number of columns must be even!");
        }
        this.rowFFT = new ComplexFloatFFT_Mixed(n2 / 2);
        this.colFFT = n == n2 / 2 ? this.rowFFT : new ComplexFloatFFT_Mixed(n);
    }

    protected void checkData(float[] fArray, int n) {
        if (n < this.ncols + 2) {
            throw new IllegalArgumentException("The row span " + n + "is not long enough for ncols=" + this.ncols);
        }
        if (this.nrows * n > fArray.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.nrows + "x" + n + " data.length=" + fArray.length);
        }
    }

    public void transform(float[] fArray) {
        this.transform(fArray, this.ncols + 2);
    }

    public void transform(float[] fArray, int n) {
        int n2;
        this.checkData(fArray, n);
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.rowFFT.transform(fArray, n2 * n, 2);
            this.shuffle(fArray, n2 * n, 1);
        }
        n2 = this.ncols / 2 + 1;
        for (int i = 0; i < n2; ++i) {
            this.colFFT.transform(fArray, 2 * i, n);
        }
    }

    public float[] toWraparoundOrder(float[] fArray, int n) {
        float[] fArray2 = new float[2 * this.nrows * this.ncols];
        int n2 = this.ncols / 2;
        for (int i = 0; i < this.nrows; ++i) {
            int n3 = 2 * i * this.ncols;
            int n4 = i * n;
            int n5 = i == 0 ? 0 : (this.nrows - i) * 2 * this.ncols;
            fArray2[n3] = fArray[n4];
            fArray2[n3 + 1] = fArray[n4 + 1];
            fArray2[n3 + this.ncols] = fArray[n4 + this.ncols];
            fArray2[n3 + this.ncols + 1] = fArray[n4 + this.ncols + 1];
            for (int j = 1; j < n2; ++j) {
                fArray2[n3 + 2 * j] = fArray[n4 + 2 * j];
                fArray2[n3 + 2 * j + 1] = fArray[n4 + 2 * j + 1];
                fArray2[n5 + 2 * (this.ncols - j)] = fArray[n4 + 2 * j];
                fArray2[n5 + 2 * (this.ncols - j) + 1] = -fArray[n4 + 2 * j + 1];
            }
        }
        return fArray2;
    }

    public void backtransform(float[] fArray) {
        this.backtransform(fArray, this.ncols + 2);
    }

    public void backtransform(float[] fArray, int n) {
        int n2;
        this.checkData(fArray, n);
        int n3 = this.ncols / 2 + 1;
        for (n2 = 0; n2 < n3; ++n2) {
            this.colFFT.backtransform(fArray, 2 * n2, n);
        }
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.shuffle(fArray, n2 * n, -1);
            this.rowFFT.backtransform(fArray, n2 * n, 2);
        }
    }

    private void shuffle(float[] fArray, int n, int n2) {
        int n3 = this.ncols / 2;
        int n4 = this.ncols / 4;
        float f = 0.5f;
        float f2 = -0.5f * (float)n2;
        double d = (double)n2 * Math.PI / (double)n3;
        float f3 = (float)Math.sin(0.5 * d);
        float f4 = -2.0f * f3 * f3;
        float f5 = (float)(-Math.sin(d));
        float f6 = 1.0f + f4;
        float f7 = f5;
        for (int i = 1; i < n4; ++i) {
            int n5 = n + 2 * i;
            int n6 = n + this.ncols - 2 * i;
            float f8 = f * (fArray[n5] + fArray[n6]);
            float f9 = f * (fArray[n5 + 1] - fArray[n6 + 1]);
            float f10 = -f2 * (fArray[n5 + 1] + fArray[n6 + 1]);
            float f11 = f2 * (fArray[n5] - fArray[n6]);
            fArray[n5] = f8 + f6 * f10 - f7 * f11;
            fArray[n5 + 1] = f9 + f6 * f11 + f7 * f10;
            fArray[n6] = f8 - f6 * f10 + f7 * f11;
            fArray[n6 + 1] = -f9 + f6 * f11 + f7 * f10;
            f3 = f6;
            f6 += f3 * f4 - f7 * f5;
            f7 += f3 * f5 + f7 * f4;
        }
        float f12 = fArray[n];
        if (n2 == 1) {
            fArray[n] = f12 + fArray[n + 1];
            fArray[n + this.ncols] = f12 - fArray[n + 1];
            fArray[n + 1] = 0.0f;
            fArray[n + this.ncols + 1] = 0.0f;
        } else {
            fArray[n] = f * (f12 + fArray[n + this.ncols]);
            fArray[n + 1] = f * (f12 - fArray[n + this.ncols]);
            fArray[n + this.ncols] = 0.0f;
            fArray[n + this.ncols + 1] = 0.0f;
        }
        if (this.ncols % 4 == 0) {
            int n7 = n + n3 + 1;
            fArray[n7] = fArray[n7] * -1.0f;
        }
    }

    public float normalization() {
        return 2.0f / ((float)this.nrows * (float)this.ncols);
    }

    public void inverse(float[] fArray) {
        this.inverse(fArray, this.ncols + 2);
    }

    public void inverse(float[] fArray, int n) {
        this.backtransform(fArray, n);
        float f = this.normalization();
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                int n2 = i * n + j;
                fArray[n2] = fArray[n2] * f;
            }
        }
    }
}

