/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexFloatFFT;
import jnt.FFT.ComplexFloatFFT_Mixed;

public class ComplexFloat2DFFT {
    int nrows;
    int ncols;
    ComplexFloatFFT rowFFT;
    ComplexFloatFFT colFFT;

    public ComplexFloat2DFFT(int n, int n2) {
        this.nrows = n;
        this.ncols = n2;
        this.rowFFT = new ComplexFloatFFT_Mixed(n2);
        this.colFFT = n == n2 ? this.rowFFT : new ComplexFloatFFT_Mixed(n);
    }

    protected void checkData(float[] fArray, int n) {
        if (n < 2 * this.ncols) {
            throw new IllegalArgumentException("The row span " + n + "is shorter than the row length " + 2 * this.ncols);
        }
        if (this.nrows * n > fArray.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.nrows + "x" + n + " data.length=" + fArray.length);
        }
    }

    public void transform(float[] fArray) {
        this.transform(fArray, 2 * this.ncols);
    }

    public void transform(float[] fArray, int n) {
        int n2;
        this.checkData(fArray, n);
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.rowFFT.transform(fArray, n2 * n, 2);
        }
        for (n2 = 0; n2 < this.ncols; ++n2) {
            this.colFFT.transform(fArray, 2 * n2, n);
        }
    }

    public float[] toWraparoundOrder(float[] fArray) {
        return fArray;
    }

    public float[] toWraparoundOrder(float[] fArray, int n) {
        if (n == 2 * this.ncols) {
            return fArray;
        }
        float[] fArray2 = new float[2 * this.nrows * this.ncols];
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                fArray2[i * 2 * this.ncols + 2 * j] = fArray[i * n + 2 * j];
                fArray2[i * 2 * this.ncols + 2 * j + 1] = fArray[i * n + 2 * j + 1];
            }
        }
        return fArray2;
    }

    public void backtransform(float[] fArray) {
        this.backtransform(fArray, 2 * this.ncols);
    }

    public void backtransform(float[] fArray, int n) {
        int n2;
        this.checkData(fArray, n);
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.rowFFT.backtransform(fArray, n2 * n, 2);
        }
        for (n2 = 0; n2 < this.ncols; ++n2) {
            this.colFFT.backtransform(fArray, 2 * n2, n);
        }
    }

    public float normalization() {
        return 1.0f / ((float)this.nrows * (float)this.ncols);
    }

    public void inverse(float[] fArray) {
        this.inverse(fArray, 2 * this.ncols);
    }

    public void inverse(float[] fArray, int n) {
        this.backtransform(fArray, n);
        float f = this.normalization();
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                int n2 = i * n + 2 * j;
                fArray[n2] = fArray[n2] * f;
                int n3 = i * n + 2 * j + 1;
                fArray[n3] = fArray[n3] * f;
            }
        }
    }
}

