/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexDoubleFFT;
import jnt.FFT.Factorize;

public class ComplexDoubleFFT_Radix2
extends ComplexDoubleFFT {
    static final double PI = Math.PI;
    static final int FORWARD = -1;
    static final int BACKWARD = 1;
    static final int DECINTIME = 0;
    static final int DECINFREQ = 1;
    private int logn;
    private int decimate = 0;
    private double[] trigs;

    public ComplexDoubleFFT_Radix2(int n) {
        super(n);
        int n2 = Factorize.log2(n);
        if (n2 < 0) {
            throw new Error(n + " is not a power of 2");
        }
        this.logn = n2;
        this.trigs = new double[this.logn + 1];
        double d = Math.PI;
        for (int i = 0; i <= this.logn; ++i) {
            this.trigs[i] = Math.sin(d);
            d /= 2.0;
        }
    }

    public void setDecimateInTime() {
        this.decimate = 0;
    }

    public void setDecimateInFrequency() {
        this.decimate = 1;
    }

    @Override
    public void transform(double[] dArray, int n, int n2) {
        this.checkData(dArray, n, n2);
        this.transform_internal(dArray, n, n2, -1);
    }

    @Override
    public void backtransform(double[] dArray, int n, int n2) {
        this.checkData(dArray, n, n2);
        this.transform_internal(dArray, n, n2, 1);
    }

    void transform_internal(double[] dArray, int n, int n2, int n3) {
        if (this.decimate == 1) {
            this.transform_DIF(dArray, n, n2, n3);
        } else {
            this.transform_DIT(dArray, n, n2, n3);
        }
    }

    void transform_DIT(double[] dArray, int n, int n2, int n3) {
        if (this.n == 1) {
            return;
        }
        this.bitreverse(dArray, n, n2);
        int n4 = 0;
        int n5 = 1;
        while (n4 < this.logn) {
            int n6;
            int n7;
            int n8;
            double d = 1.0;
            double d2 = 0.0;
            double d3 = (double)n3 * this.trigs[n4];
            double d4 = (double)n3 * this.trigs[n4 + 1];
            double d5 = 2.0 * d4 * d4;
            for (n8 = 0; n8 < this.n; n8 += 2 * n5) {
                n7 = n + n8 * n2;
                n6 = n + (n8 + n5) * n2;
                double d6 = dArray[n6];
                double d7 = dArray[n6 + 1];
                dArray[n6] = dArray[n7] - d6;
                dArray[n6 + 1] = dArray[n7 + 1] - d7;
                int n9 = n7;
                dArray[n9] = dArray[n9] + d6;
                int n10 = n7 + 1;
                dArray[n10] = dArray[n10] + d7;
            }
            for (n8 = 1; n8 < n5; ++n8) {
                double d8 = d - d3 * d2 - d5 * d;
                double d9 = d2 + d3 * d - d5 * d2;
                d = d8;
                d2 = d9;
                for (n7 = 0; n7 < this.n; n7 += 2 * n5) {
                    n6 = n + (n7 + n8) * n2;
                    int n11 = n + (n7 + n8 + n5) * n2;
                    double d10 = dArray[n11];
                    double d11 = dArray[n11 + 1];
                    double d12 = d * d10 - d2 * d11;
                    double d13 = d * d11 + d2 * d10;
                    dArray[n11] = dArray[n6] - d12;
                    dArray[n11 + 1] = dArray[n6 + 1] - d13;
                    int n12 = n6;
                    dArray[n12] = dArray[n12] + d12;
                    int n13 = n6 + 1;
                    dArray[n13] = dArray[n13] + d13;
                }
            }
            ++n4;
            n5 *= 2;
        }
    }

    void transform_DIF(double[] dArray, int n, int n2, int n3) {
        if (this.n == 1) {
            return;
        }
        int n4 = 0;
        int n5 = this.n / 2;
        while (n4 < this.logn) {
            double d = 1.0;
            double d2 = 0.0;
            double d3 = (double)n3 * this.trigs[this.logn - 1 - n4];
            double d4 = (double)n3 * this.trigs[this.logn - n4];
            double d5 = 2.0 * d4 * d4;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < this.n; j += 2 * n5) {
                    int n6 = n + (i + j) * n2;
                    int n7 = n + (i + j + n5) * n2;
                    double d6 = dArray[n6] + dArray[n7];
                    double d7 = dArray[n6 + 1] + dArray[n7 + 1];
                    double d8 = dArray[n6] - dArray[n7];
                    double d9 = dArray[n6 + 1] - dArray[n7 + 1];
                    dArray[n6] = d6;
                    dArray[n6 + 1] = d7;
                    dArray[n7] = d * d8 - d2 * d9;
                    dArray[n7 + 1] = d * d9 + d2 * d8;
                }
                double d10 = d - d3 * d2 - d5 * d;
                double d11 = d2 + d3 * d - d5 * d2;
                d = d10;
                d2 = d11;
            }
            ++n4;
            n5 /= 2;
        }
        this.bitreverse(dArray, n, n2);
    }

    protected void bitreverse(double[] dArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.n - 1; ++i) {
            int n4 = n + i * n2;
            int n5 = n + n3 * n2;
            int n6 = this.n / 2;
            if (i < n3) {
                double d = dArray[n4];
                double d2 = dArray[n4 + 1];
                dArray[n4] = dArray[n5];
                dArray[n4 + 1] = dArray[n5 + 1];
                dArray[n5] = d;
                dArray[n5 + 1] = d2;
            }
            while (n6 <= n3) {
                n3 -= n6;
                n6 /= 2;
            }
            n3 += n6;
        }
    }
}

