/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexDoubleFFT;
import jnt.FFT.Factorize;

public class ComplexDoubleFFT_Mixed
extends ComplexDoubleFFT {
    static final double PI = Math.PI;
    private int[] factors;
    private double[][][] twiddle;
    private int[] available_factors = new int[]{7, 6, 5, 4, 3, 2};

    public ComplexDoubleFFT_Mixed(int n) {
        super(n);
        this.setup_wavetable(n);
    }

    @Override
    public void transform(double[] dArray, int n, int n2) {
        this.checkData(dArray, n, n2);
        this.transform_internal(dArray, n, n2, -1);
    }

    @Override
    public void backtransform(double[] dArray, int n, int n2) {
        this.checkData(dArray, n, n2);
        this.transform_internal(dArray, n, n2, 1);
    }

    void setup_wavetable(int n) {
        if (n <= 0) {
            throw new Error("length must be positive integer : " + n);
        }
        this.n = n;
        this.factors = Factorize.factor(n, this.available_factors);
        double d = Math.PI * -2 / (double)n;
        int n2 = 1;
        this.twiddle = new double[this.factors.length][][];
        for (int i = 0; i < this.factors.length; ++i) {
            int n3;
            int n4 = this.factors[i];
            int n5 = n2;
            int n6 = n / (n2 *= n4);
            this.twiddle[i] = new double[n6 + 1][2 * (n4 - 1)];
            double[][] dArray = this.twiddle[i];
            for (n3 = 1; n3 < n4; ++n3) {
                dArray[0][2 * (n3 - 1)] = 1.0;
                dArray[0][2 * (n3 - 1) + 1] = 0.0;
            }
            for (n3 = 1; n3 <= n6; ++n3) {
                int n7 = 0;
                for (int j = 1; j < n4; ++j) {
                    n7 += n3 * n5;
                    double d2 = d * (double)(n7 %= n);
                    dArray[n3][2 * (j - 1)] = Math.cos(d2);
                    dArray[n3][2 * (j - 1) + 1] = Math.sin(d2);
                }
            }
        }
    }

    void transform_internal(double[] dArray, int n, int n2, int n3) {
        int n4;
        if (this.n == 1) {
            return;
        }
        double[] dArray2 = new double[2 * this.n];
        int n5 = 1;
        boolean bl = false;
        block8: for (n4 = 0; n4 < this.factors.length; ++n4) {
            int n6;
            int n7;
            double[] dArray3;
            int n8;
            int n9;
            double[] dArray4;
            int n10 = this.factors[n4];
            n5 *= n10;
            if (!bl) {
                dArray4 = dArray;
                n9 = n;
                n8 = n2;
                dArray3 = dArray2;
                n7 = 0;
                n6 = 2;
                bl = true;
            } else {
                dArray4 = dArray2;
                n9 = 0;
                n8 = 2;
                dArray3 = dArray;
                n7 = n;
                n6 = n2;
                bl = false;
            }
            switch (n10) {
                case 2: {
                    this.pass_2(n4, dArray4, n9, n8, dArray3, n7, n6, n3, n5);
                    continue block8;
                }
                case 3: {
                    this.pass_3(n4, dArray4, n9, n8, dArray3, n7, n6, n3, n5);
                    continue block8;
                }
                case 4: {
                    this.pass_4(n4, dArray4, n9, n8, dArray3, n7, n6, n3, n5);
                    continue block8;
                }
                case 5: {
                    this.pass_5(n4, dArray4, n9, n8, dArray3, n7, n6, n3, n5);
                    continue block8;
                }
                case 6: {
                    this.pass_6(n4, dArray4, n9, n8, dArray3, n7, n6, n3, n5);
                    continue block8;
                }
                case 7: {
                    this.pass_7(n4, dArray4, n9, n8, dArray3, n7, n6, n3, n5);
                    continue block8;
                }
                default: {
                    this.pass_n(n4, dArray4, n9, n8, dArray3, n7, n6, n3, n10, n5);
                }
            }
        }
        if (bl) {
            for (n4 = 0; n4 < this.n; ++n4) {
                dArray[n + n2 * n4] = dArray2[2 * n4];
                dArray[n + n2 * n4 + 1] = dArray2[2 * n4 + 1];
            }
        }
    }

    void pass_2(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, int n6, int n7) {
        int n8 = 2;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = n3 * n9;
        int n13 = n5 * n11;
        int n14 = n2;
        int n15 = n4;
        for (int i = 0; i < n10; ++i) {
            double[] dArray3 = this.twiddle[n][i];
            double d = dArray3[0];
            double d2 = (double)(-n6) * dArray3[1];
            for (int j = 0; j < n11; ++j) {
                double d3 = dArray[n14];
                double d4 = dArray[n14 + 1];
                double d5 = dArray[n14 + n12];
                double d6 = dArray[n14 + n12 + 1];
                n14 += n3;
                dArray2[n15] = d3 + d5;
                dArray2[n15 + 1] = d4 + d6;
                double d7 = d3 - d5;
                double d8 = d4 - d6;
                dArray2[n15 + n13] = d * d7 - d2 * d8;
                dArray2[n15 + n13 + 1] = d * d8 + d2 * d7;
                n15 += n5;
            }
            n15 += (n8 - 1) * n13;
        }
    }

    void pass_3(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, int n6, int n7) {
        int n8 = 3;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = (n8 - 1) * n11;
        double d = (double)n6 * Math.sqrt(3.0) / 2.0;
        int n13 = n3 * n9;
        int n14 = n5 * n11;
        int n15 = n2;
        int n16 = n4;
        for (int i = 0; i < n10; ++i) {
            double[] dArray3 = this.twiddle[n][i];
            double d2 = dArray3[0];
            double d3 = (double)(-n6) * dArray3[1];
            double d4 = dArray3[2];
            double d5 = (double)(-n6) * dArray3[3];
            for (int j = 0; j < n11; ++j) {
                double d6 = dArray[n15];
                double d7 = dArray[n15 + 1];
                double d8 = dArray[n15 + n13];
                double d9 = dArray[n15 + n13 + 1];
                double d10 = dArray[n15 + 2 * n13];
                double d11 = dArray[n15 + 2 * n13 + 1];
                n15 += n3;
                double d12 = d8 + d10;
                double d13 = d9 + d11;
                double d14 = d6 - d12 / 2.0;
                double d15 = d7 - d13 / 2.0;
                double d16 = d * (d8 - d10);
                double d17 = d * (d9 - d11);
                dArray2[n16] = d6 + d12;
                dArray2[n16 + 1] = d7 + d13;
                double d18 = d14 - d17;
                double d19 = d15 + d16;
                dArray2[n16 + n14] = d2 * d18 - d3 * d19;
                dArray2[n16 + n14 + 1] = d2 * d19 + d3 * d18;
                d18 = d14 + d17;
                d19 = d15 - d16;
                dArray2[n16 + 2 * n14] = d4 * d18 - d5 * d19;
                dArray2[n16 + 2 * n14 + 1] = d4 * d19 + d5 * d18;
                n16 += n5;
            }
            n16 += (n8 - 1) * n14;
        }
    }

    void pass_4(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, int n6, int n7) {
        int n8 = 4;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = (n8 - 1) * n11;
        int n13 = n2;
        int n14 = n4;
        int n15 = n3 * n9;
        int n16 = n5 * n11;
        for (int i = 0; i < n10; ++i) {
            double[] dArray3 = this.twiddle[n][i];
            double d = dArray3[0];
            double d2 = (double)(-n6) * dArray3[1];
            double d3 = dArray3[2];
            double d4 = (double)(-n6) * dArray3[3];
            double d5 = dArray3[4];
            double d6 = (double)(-n6) * dArray3[5];
            for (int j = 0; j < n11; ++j) {
                double d7 = dArray[n13];
                double d8 = dArray[n13 + 1];
                double d9 = dArray[n13 + n15];
                double d10 = dArray[n13 + n15 + 1];
                double d11 = dArray[n13 + 2 * n15];
                double d12 = dArray[n13 + 2 * n15 + 1];
                double d13 = dArray[n13 + 3 * n15];
                double d14 = dArray[n13 + 3 * n15 + 1];
                n13 += n3;
                double d15 = d7 + d11;
                double d16 = d8 + d12;
                double d17 = d9 + d13;
                double d18 = d10 + d14;
                double d19 = d7 - d11;
                double d20 = d8 - d12;
                double d21 = (double)n6 * (d9 - d13);
                double d22 = (double)n6 * (d10 - d14);
                dArray2[n14] = d15 + d17;
                dArray2[n14 + 1] = d16 + d18;
                double d23 = d19 - d22;
                double d24 = d20 + d21;
                dArray2[n14 + n16] = d * d23 - d2 * d24;
                dArray2[n14 + n16 + 1] = d * d24 + d2 * d23;
                d23 = d15 - d17;
                d24 = d16 - d18;
                dArray2[n14 + 2 * n16] = d3 * d23 - d4 * d24;
                dArray2[n14 + 2 * n16 + 1] = d3 * d24 + d4 * d23;
                d23 = d19 + d22;
                d24 = d20 - d21;
                dArray2[n14 + 3 * n16] = d5 * d23 - d6 * d24;
                dArray2[n14 + 3 * n16 + 1] = d5 * d24 + d6 * d23;
                n14 += n5;
            }
            n14 += (n8 - 1) * n16;
        }
    }

    void pass_5(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, int n6, int n7) {
        int n8 = 5;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = (n8 - 1) * n11;
        double d = Math.sqrt(5.0) / 4.0;
        double d2 = (double)n6 * Math.sin(1.2566370614359172);
        double d3 = (double)n6 * Math.sin(0.6283185307179586);
        int n13 = n2;
        int n14 = n4;
        int n15 = n3 * n9;
        int n16 = n5 * n11;
        for (int i = 0; i < n10; ++i) {
            double[] dArray3 = this.twiddle[n][i];
            double d4 = dArray3[0];
            double d5 = (double)(-n6) * dArray3[1];
            double d6 = dArray3[2];
            double d7 = (double)(-n6) * dArray3[3];
            double d8 = dArray3[4];
            double d9 = (double)(-n6) * dArray3[5];
            double d10 = dArray3[6];
            double d11 = (double)(-n6) * dArray3[7];
            for (int j = 0; j < n11; ++j) {
                double d12 = dArray[n13];
                double d13 = dArray[n13 + 1];
                double d14 = dArray[n13 + n15];
                double d15 = dArray[n13 + n15 + 1];
                double d16 = dArray[n13 + 2 * n15];
                double d17 = dArray[n13 + 2 * n15 + 1];
                double d18 = dArray[n13 + 3 * n15];
                double d19 = dArray[n13 + 3 * n15 + 1];
                double d20 = dArray[n13 + 4 * n15];
                double d21 = dArray[n13 + 4 * n15 + 1];
                n13 += n3;
                double d22 = d14 + d20;
                double d23 = d15 + d21;
                double d24 = d16 + d18;
                double d25 = d17 + d19;
                double d26 = d14 - d20;
                double d27 = d15 - d21;
                double d28 = d16 - d18;
                double d29 = d17 - d19;
                double d30 = d22 + d24;
                double d31 = d23 + d25;
                double d32 = d * (d22 - d24);
                double d33 = d * (d23 - d25);
                double d34 = d12 - d30 / 4.0;
                double d35 = d13 - d31 / 4.0;
                double d36 = d34 + d32;
                double d37 = d35 + d33;
                double d38 = d34 - d32;
                double d39 = d35 - d33;
                double d40 = d2 * d26 + d3 * d28;
                double d41 = d2 * d27 + d3 * d29;
                double d42 = d3 * d26 - d2 * d28;
                double d43 = d3 * d27 - d2 * d29;
                dArray2[n14] = d12 + d30;
                dArray2[n14 + 1] = d13 + d31;
                double d44 = d36 - d41;
                double d45 = d37 + d40;
                dArray2[n14 + n16] = d4 * d44 - d5 * d45;
                dArray2[n14 + n16 + 1] = d4 * d45 + d5 * d44;
                d44 = d38 - d43;
                d45 = d39 + d42;
                dArray2[n14 + 2 * n16] = d6 * d44 - d7 * d45;
                dArray2[n14 + 2 * n16 + 1] = d6 * d45 + d7 * d44;
                d44 = d38 + d43;
                d45 = d39 - d42;
                dArray2[n14 + 3 * n16] = d8 * d44 - d9 * d45;
                dArray2[n14 + 3 * n16 + 1] = d8 * d45 + d9 * d44;
                d44 = d36 + d41;
                d45 = d37 - d40;
                dArray2[n14 + 4 * n16] = d10 * d44 - d11 * d45;
                dArray2[n14 + 4 * n16 + 1] = d10 * d45 + d11 * d44;
                n14 += n5;
            }
            n14 += (n8 - 1) * n16;
        }
    }

    void pass_6(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, int n6, int n7) {
        int n8 = 6;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = (n8 - 1) * n11;
        double d = (double)n6 * Math.sqrt(3.0) / 2.0;
        int n13 = n2;
        int n14 = n4;
        int n15 = n3 * n9;
        int n16 = n5 * n11;
        for (int i = 0; i < n10; ++i) {
            double[] dArray3 = this.twiddle[n][i];
            double d2 = dArray3[0];
            double d3 = (double)(-n6) * dArray3[1];
            double d4 = dArray3[2];
            double d5 = (double)(-n6) * dArray3[3];
            double d6 = dArray3[4];
            double d7 = (double)(-n6) * dArray3[5];
            double d8 = dArray3[6];
            double d9 = (double)(-n6) * dArray3[7];
            double d10 = dArray3[8];
            double d11 = (double)(-n6) * dArray3[9];
            for (int j = 0; j < n11; ++j) {
                double d12 = dArray[n13];
                double d13 = dArray[n13 + 1];
                double d14 = dArray[n13 + n15];
                double d15 = dArray[n13 + n15 + 1];
                double d16 = dArray[n13 + 2 * n15];
                double d17 = dArray[n13 + 2 * n15 + 1];
                double d18 = dArray[n13 + 3 * n15];
                double d19 = dArray[n13 + 3 * n15 + 1];
                double d20 = dArray[n13 + 4 * n15];
                double d21 = dArray[n13 + 4 * n15 + 1];
                double d22 = dArray[n13 + 5 * n15];
                double d23 = dArray[n13 + 5 * n15 + 1];
                n13 += n3;
                double d24 = d16 + d20;
                double d25 = d17 + d21;
                double d26 = d12 - d24 / 2.0;
                double d27 = d13 - d25 / 2.0;
                double d28 = d * (d16 - d20);
                double d29 = d * (d17 - d21);
                double d30 = d12 + d24;
                double d31 = d13 + d25;
                double d32 = d26 - d29;
                double d33 = d27 + d28;
                double d34 = d26 + d29;
                double d35 = d27 - d28;
                double d36 = d22 + d14;
                double d37 = d23 + d15;
                double d38 = d18 - d36 / 2.0;
                double d39 = d19 - d37 / 2.0;
                double d40 = d * (d22 - d14);
                double d41 = d * (d23 - d15);
                double d42 = d18 + d36;
                double d43 = d19 + d37;
                double d44 = d38 - d41;
                double d45 = d39 + d40;
                double d46 = d38 + d41;
                double d47 = d39 - d40;
                dArray2[n14] = d30 + d42;
                dArray2[n14 + 1] = d31 + d43;
                double d48 = d32 - d44;
                double d49 = d33 - d45;
                dArray2[n14 + n16] = d2 * d48 - d3 * d49;
                dArray2[n14 + n16 + 1] = d2 * d49 + d3 * d48;
                d48 = d34 + d46;
                d49 = d35 + d47;
                dArray2[n14 + 2 * n16] = d4 * d48 - d5 * d49;
                dArray2[n14 + 2 * n16 + 1] = d4 * d49 + d5 * d48;
                d48 = d30 - d42;
                d49 = d31 - d43;
                dArray2[n14 + 3 * n16] = d6 * d48 - d7 * d49;
                dArray2[n14 + 3 * n16 + 1] = d6 * d49 + d7 * d48;
                d48 = d32 + d44;
                d49 = d33 + d45;
                dArray2[n14 + 4 * n16] = d8 * d48 - d9 * d49;
                dArray2[n14 + 4 * n16 + 1] = d8 * d49 + d9 * d48;
                d48 = d34 - d46;
                d49 = d35 - d47;
                dArray2[n14 + 5 * n16] = d10 * d48 - d11 * d49;
                dArray2[n14 + 5 * n16 + 1] = d10 * d49 + d11 * d48;
                n14 += n5;
            }
            n14 += (n8 - 1) * n16;
        }
    }

    void pass_7(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, int n6, int n7) {
        int n8 = 7;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = (n8 - 1) * n11;
        double d = Math.cos(0.8975979010256552);
        double d2 = Math.cos(1.7951958020513104);
        double d3 = Math.cos(2.6927937030769655);
        double d4 = (double)(-n6) * Math.sin(0.8975979010256552);
        double d5 = (double)(-n6) * Math.sin(1.7951958020513104);
        double d6 = (double)(-n6) * Math.sin(2.6927937030769655);
        int n13 = n2;
        int n14 = n4;
        int n15 = n3 * n9;
        int n16 = n5 * n11;
        for (int i = 0; i < n10; ++i) {
            double[] dArray3 = this.twiddle[n][i];
            double d7 = dArray3[0];
            double d8 = (double)(-n6) * dArray3[1];
            double d9 = dArray3[2];
            double d10 = (double)(-n6) * dArray3[3];
            double d11 = dArray3[4];
            double d12 = (double)(-n6) * dArray3[5];
            double d13 = dArray3[6];
            double d14 = (double)(-n6) * dArray3[7];
            double d15 = dArray3[8];
            double d16 = (double)(-n6) * dArray3[9];
            double d17 = dArray3[10];
            double d18 = (double)(-n6) * dArray3[11];
            for (int j = 0; j < n11; ++j) {
                double d19 = dArray[n13];
                double d20 = dArray[n13 + 1];
                double d21 = dArray[n13 + n15];
                double d22 = dArray[n13 + n15 + 1];
                double d23 = dArray[n13 + 2 * n15];
                double d24 = dArray[n13 + 2 * n15 + 1];
                double d25 = dArray[n13 + 3 * n15];
                double d26 = dArray[n13 + 3 * n15 + 1];
                double d27 = dArray[n13 + 4 * n15];
                double d28 = dArray[n13 + 4 * n15 + 1];
                double d29 = dArray[n13 + 5 * n15];
                double d30 = dArray[n13 + 5 * n15 + 1];
                double d31 = dArray[n13 + 6 * n15];
                double d32 = dArray[n13 + 6 * n15 + 1];
                n13 += n3;
                double d33 = d21 + d31;
                double d34 = d22 + d32;
                double d35 = d21 - d31;
                double d36 = d22 - d32;
                double d37 = d23 + d29;
                double d38 = d24 + d30;
                double d39 = d23 - d29;
                double d40 = d24 - d30;
                double d41 = d27 + d25;
                double d42 = d28 + d26;
                double d43 = d27 - d25;
                double d44 = d28 - d26;
                double d45 = d37 + d33;
                double d46 = d38 + d34;
                double d47 = d43 + d39;
                double d48 = d44 + d40;
                double d49 = d19 + d45 + d41;
                double d50 = d20 + d46 + d42;
                double d51 = ((d + d2 + d3) / 3.0 - 1.0) * (d45 + d41);
                double d52 = ((d + d2 + d3) / 3.0 - 1.0) * (d46 + d42);
                double d53 = (2.0 * d - d2 - d3) / 3.0 * (d33 - d41);
                double d54 = (2.0 * d - d2 - d3) / 3.0 * (d34 - d42);
                double d55 = (d - 2.0 * d2 + d3) / 3.0 * (d41 - d37);
                double d56 = (d - 2.0 * d2 + d3) / 3.0 * (d42 - d38);
                double d57 = (d + d2 - 2.0 * d3) / 3.0 * (d37 - d33);
                double d58 = (d + d2 - 2.0 * d3) / 3.0 * (d38 - d34);
                double d59 = (d4 + d5 - d6) / 3.0 * (d47 + d35);
                double d60 = (d4 + d5 - d6) / 3.0 * (d48 + d36);
                double d61 = (2.0 * d4 - d5 + d6) / 3.0 * (d35 - d43);
                double d62 = (2.0 * d4 - d5 + d6) / 3.0 * (d36 - d44);
                double d63 = (d4 - 2.0 * d5 - d6) / 3.0 * (d43 - d39);
                double d64 = (d4 - 2.0 * d5 - d6) / 3.0 * (d44 - d40);
                double d65 = (d4 + d5 + 2.0 * d6) / 3.0 * (d39 - d35);
                double d66 = (d4 + d5 + 2.0 * d6) / 3.0 * (d40 - d36);
                double d67 = d49 + d51;
                double d68 = d50 + d52;
                double d69 = d53 + d55;
                double d70 = d54 + d56;
                double d71 = d57 - d55;
                double d72 = d58 - d56;
                double d73 = -d53 - d57;
                double d74 = -d54 - d58;
                double d75 = d61 + d63;
                double d76 = d62 + d64;
                double d77 = d65 - d63;
                double d78 = d66 - d64;
                double d79 = -d65 - d61;
                double d80 = -d66 - d62;
                double d81 = d67 + d69;
                double d82 = d68 + d70;
                double d83 = d67 + d71;
                double d84 = d68 + d72;
                double d85 = d67 + d73;
                double d86 = d68 + d74;
                double d87 = d75 + d59;
                double d88 = d76 + d60;
                double d89 = d77 + d59;
                double d90 = d78 + d60;
                double d91 = d79 + d59;
                double d92 = d80 + d60;
                dArray2[n14] = d49;
                dArray2[n14 + 1] = d50;
                double d93 = d81 + d88;
                double d94 = d82 - d87;
                dArray2[n14 + n16] = d7 * d93 - d8 * d94;
                dArray2[n14 + n16 + 1] = d7 * d94 + d8 * d93;
                d93 = d85 + d92;
                d94 = d86 - d91;
                dArray2[n14 + 2 * n16] = d9 * d93 - d10 * d94;
                dArray2[n14 + 2 * n16 + 1] = d9 * d94 + d10 * d93;
                d93 = d83 - d90;
                d94 = d84 + d89;
                dArray2[n14 + 3 * n16] = d11 * d93 - d12 * d94;
                dArray2[n14 + 3 * n16 + 1] = d11 * d94 + d12 * d93;
                d93 = d83 + d90;
                d94 = d84 - d89;
                dArray2[n14 + 4 * n16] = d13 * d93 - d14 * d94;
                dArray2[n14 + 4 * n16 + 1] = d13 * d94 + d14 * d93;
                d93 = d85 - d92;
                d94 = d86 + d91;
                dArray2[n14 + 5 * n16] = d15 * d93 - d16 * d94;
                dArray2[n14 + 5 * n16 + 1] = d15 * d94 + d16 * d93;
                d93 = d81 - d88;
                d94 = d82 + d87;
                dArray2[n14 + 6 * n16] = d17 * d93 - d18 * d94;
                dArray2[n14 + 6 * n16 + 1] = d17 * d94 + d18 * d93;
                n14 += n5;
            }
            n14 += (n8 - 1) * n16;
        }
    }

    void pass_n(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14 = 0;
        int n15 = 0;
        int n16 = this.n / n7;
        int n17 = this.n / n8;
        int n18 = n8 / n7;
        int n19 = (n7 - 1) * n18;
        for (n14 = 0; n14 < n16; ++n14) {
            dArray2[n4 + n5 * n14] = dArray[n2 + n3 * n14];
            dArray2[n4 + n5 * n14 + 1] = dArray[n2 + n3 * n14 + 1];
        }
        for (n13 = 1; n13 < (n7 - 1) / 2 + 1; ++n13) {
            for (n14 = 0; n14 < n16; ++n14) {
                int n20 = n14 + n13 * n16;
                n12 = n14 + (n7 - n13) * n16;
                dArray2[n4 + n5 * n20] = dArray[n2 + n3 * n20] + dArray[n2 + n3 * n12];
                dArray2[n4 + n5 * n20 + 1] = dArray[n2 + n3 * n20 + 1] + dArray[n2 + n3 * n12 + 1];
                dArray2[n4 + n5 * n12] = dArray[n2 + n3 * n20] - dArray[n2 + n3 * n12];
                dArray2[n4 + n5 * n12 + 1] = dArray[n2 + n3 * n20 + 1] - dArray[n2 + n3 * n12 + 1];
            }
        }
        for (n14 = 0; n14 < n16; ++n14) {
            dArray[n2 + n3 * n14] = dArray2[n4 + n5 * n14];
            dArray[n2 + n3 * n14 + 1] = dArray2[n4 + n5 * n14 + 1];
        }
        for (n11 = 1; n11 < (n7 - 1) / 2 + 1; ++n11) {
            for (n14 = 0; n14 < n16; ++n14) {
                int n21 = n2 + n3 * n14;
                dArray[n21] = dArray[n21] + dArray2[n4 + n5 * (n14 + n11 * n16)];
                int n22 = n2 + n3 * n14 + 1;
                dArray[n22] = dArray[n22] + dArray2[n4 + n5 * (n14 + n11 * n16) + 1];
            }
        }
        double[] dArray3 = this.twiddle[n][n17];
        for (n13 = 1; n13 < (n7 - 1) / 2 + 1; ++n13) {
            n12 = n13;
            int n23 = n13 * n16;
            int n24 = (n7 - n13) * n16;
            for (n14 = 0; n14 < n16; ++n14) {
                dArray[n2 + n3 * (n14 + n23)] = dArray2[n4 + n5 * n14];
                dArray[n2 + n3 * (n14 + n23) + 1] = dArray2[n4 + n5 * n14 + 1];
                dArray[n2 + n3 * (n14 + n24)] = dArray2[n4 + n5 * n14];
                dArray[n2 + n3 * (n14 + n24) + 1] = dArray2[n4 + n5 * n14 + 1];
            }
            for (n11 = 1; n11 < (n7 - 1) / 2 + 1; ++n11) {
                double d;
                double d2;
                if (n12 == 0) {
                    d2 = 1.0;
                    d = 0.0;
                } else {
                    d2 = dArray3[2 * (n12 - 1)];
                    d = (double)(-n6) * dArray3[2 * (n12 - 1) + 1];
                }
                for (n14 = 0; n14 < n16; ++n14) {
                    double d3 = d2 * dArray2[n4 + n5 * (n14 + n11 * n16)];
                    double d4 = d * dArray2[n4 + n5 * (n14 + (n7 - n11) * n16) + 1];
                    double d5 = d2 * dArray2[n4 + n5 * (n14 + n11 * n16) + 1];
                    double d6 = d * dArray2[n4 + n5 * (n14 + (n7 - n11) * n16)];
                    int n25 = n2 + n3 * (n14 + n23);
                    dArray[n25] = dArray[n25] + (d3 - d4);
                    int n26 = n2 + n3 * (n14 + n23) + 1;
                    dArray[n26] = dArray[n26] + (d5 + d6);
                    int n27 = n2 + n3 * (n14 + n24);
                    dArray[n27] = dArray[n27] + (d3 + d4);
                    int n28 = n2 + n3 * (n14 + n24) + 1;
                    dArray[n28] = dArray[n28] + (d5 - d6);
                }
                n12 += n13;
                n12 %= n7;
            }
        }
        n14 = 0;
        n15 = 0;
        for (n10 = 0; n10 < n18; ++n10) {
            dArray2[n4 + n5 * n10] = dArray[n2 + n3 * n10];
            dArray2[n4 + n5 * n10 + 1] = dArray[n2 + n3 * n10 + 1];
        }
        for (n11 = 1; n11 < n7; ++n11) {
            for (n10 = 0; n10 < n18; ++n10) {
                dArray2[n4 + n5 * (n10 + n11 * n18)] = dArray[n2 + n3 * (n10 + n11 * n16)];
                dArray2[n4 + n5 * (n10 + n11 * n18) + 1] = dArray[n2 + n3 * (n10 + n11 * n16) + 1];
            }
        }
        n14 = n18;
        n15 = n8;
        for (n9 = 1; n9 < n17; ++n9) {
            for (n10 = 0; n10 < n18; ++n10) {
                dArray2[n4 + n5 * n15] = dArray[n2 + n3 * n14];
                dArray2[n4 + n5 * n15 + 1] = dArray[n2 + n3 * n14 + 1];
                ++n14;
                ++n15;
            }
            n15 += n19;
        }
        n14 = n18;
        n15 = n8;
        for (n9 = 1; n9 < n17; ++n9) {
            dArray3 = this.twiddle[n][n9];
            for (n10 = 0; n10 < n18; ++n10) {
                for (n11 = 1; n11 < n7; ++n11) {
                    double d = dArray[n2 + n3 * (n14 + n11 * n16)];
                    double d7 = dArray[n2 + n3 * (n14 + n11 * n16) + 1];
                    double d8 = dArray3[2 * (n11 - 1)];
                    double d9 = (double)(-n6) * dArray3[2 * (n11 - 1) + 1];
                    dArray2[n4 + n5 * (n15 + n11 * n18)] = d8 * d - d9 * d7;
                    dArray2[n4 + n5 * (n15 + n11 * n18) + 1] = d8 * d7 + d9 * d;
                }
                ++n14;
                ++n15;
            }
            n15 += n19;
        }
    }
}

