/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexDoubleFFT;
import jnt.FFT.ComplexDoubleFFT_Mixed;

public class ComplexDouble2DFFT {
    int nrows;
    int ncols;
    ComplexDoubleFFT rowFFT;
    ComplexDoubleFFT colFFT;

    public ComplexDouble2DFFT(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("The array dimensions >=0 : " + n + "," + n2);
        }
        this.nrows = n;
        this.ncols = n2;
        this.rowFFT = new ComplexDoubleFFT_Mixed(n2);
        this.colFFT = n == n2 ? this.rowFFT : new ComplexDoubleFFT_Mixed(n);
    }

    protected void checkData(double[] dArray, int n) {
        if (n < 2 * this.ncols) {
            throw new IllegalArgumentException("The row span " + n + "is shorter than the row length " + 2 * this.ncols);
        }
        if (this.nrows * n > dArray.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.nrows + "x" + n + " data.length=" + dArray.length);
        }
    }

    public void transform(double[] dArray) {
        this.transform(dArray, 2 * this.ncols);
    }

    public void transform(double[] dArray, int n) {
        int n2;
        this.checkData(dArray, n);
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.rowFFT.transform(dArray, n2 * n, 2);
        }
        for (n2 = 0; n2 < this.ncols; ++n2) {
            this.colFFT.transform(dArray, 2 * n2, n);
        }
    }

    public double[] toWraparoundOrder(double[] dArray) {
        return dArray;
    }

    public double[] toWraparoundOrder(double[] dArray, int n) {
        if (n == 2 * this.ncols) {
            return dArray;
        }
        double[] dArray2 = new double[2 * this.nrows * this.ncols];
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                dArray2[i * 2 * this.ncols + 2 * j] = dArray[i * n + 2 * j];
                dArray2[i * 2 * this.ncols + 2 * j + 1] = dArray[i * n + 2 * j + 1];
            }
        }
        return dArray2;
    }

    public void backtransform(double[] dArray) {
        this.backtransform(dArray, 2 * this.ncols);
    }

    public void backtransform(double[] dArray, int n) {
        int n2;
        this.checkData(dArray, n);
        for (n2 = 0; n2 < this.ncols; ++n2) {
            this.colFFT.backtransform(dArray, 2 * n2, n);
        }
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.rowFFT.backtransform(dArray, n2 * n, 2);
        }
    }

    public double normalization() {
        return 1.0 / ((double)this.nrows * (double)this.ncols);
    }

    public void inverse(double[] dArray) {
        this.inverse(dArray, 2 * this.ncols);
    }

    public void inverse(double[] dArray, int n) {
        this.backtransform(dArray, n);
        double d = this.normalization();
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                int n2 = i * n + 2 * j;
                dArray[n2] = dArray[n2] * d;
                int n3 = i * n + 2 * j + 1;
                dArray[n3] = dArray[n3] * d;
            }
        }
    }
}

