/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi.semeval;

import edu.ucla.sspace.wordsi.AssignmentReporter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SemEvalReporter
implements AssignmentReporter {
    private final Map<String, List<Assignment>> assignmentMap;
    private PrintStream writer;

    public SemEvalReporter(OutputStream outputStream) {
        this.writer = new PrintStream(outputStream);
        this.assignmentMap = new HashMap<String, List<Assignment>>();
    }

    @Override
    public synchronized void updateAssignment(String string, String string2, int n) {
        int n2 = string2.lastIndexOf(".");
        String string3 = string2.substring(0, n2);
        this.writer.printf("%s %s %s.%d\n", string3, string2, string3, n);
    }

    @Override
    public void finalizeReport() {
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assignContextToKey(String string, String string2, int n) {
        List<Assignment> list = this.assignmentMap.get(string);
        if (list == null) {
            SemEvalReporter semEvalReporter = this;
            synchronized (semEvalReporter) {
                list = this.assignmentMap.get(string);
                if (list == null) {
                    list = Collections.synchronizedList(new ArrayList());
                    this.assignmentMap.put(string, list);
                }
            }
        }
        list.add(new Assignment(string2, n));
    }

    @Override
    public String[] contextLabels(String string) {
        List<Assignment> list = this.assignmentMap.get(string);
        if (list == null) {
            return new String[0];
        }
        String[] stringArray = new String[list.size()];
        for (Assignment assignment : list) {
            stringArray[assignment.id] = assignment.key;
        }
        return stringArray;
    }

    private class Assignment {
        public String key;
        public int id;

        public Assignment(String string, int n) {
            this.key = string;
            this.id = n;
        }
    }
}

